/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.api.client.screen;

import committee.nova.mods.avaritia.api.client.screen.component.Text;
import committee.nova.mods.avaritia.api.client.util.GuiUtils;
import committee.nova.mods.avaritia.api.util.StringUtils;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class StringInputScreen
extends Screen {
    private final Screen previousScreen;
    private final Text titleText;
    private final Text messageText;
    private final String validator;
    private final Consumer<String> onDataReceived1;
    private final Function<String, String> onDataReceived2;
    private final Supplier<Boolean> shouldClose;
    private EditBox inputField;
    private Button submitButton;
    private final String defaultValue;
    private Text errorText;

    public StringInputScreen(Screen callbackScreen, Text titleText, Text messageText, String validator, Consumer<String> onDataReceived) {
        this(callbackScreen, titleText, messageText, validator, "", onDataReceived);
    }

    public StringInputScreen(Screen callbackScreen, Text titleText, Text messageText, String validator, String defaultValue, Consumer<String> onDataReceived) {
        this(callbackScreen, titleText, messageText, validator, defaultValue, onDataReceived, null);
    }

    public StringInputScreen(Screen callbackScreen, Text titleText, Text messageText, String validator, String defaultValue, Consumer<String> onDataReceived, Supplier<Boolean> shouldClose) {
        super((Component)Component.literal((String)"StringInputScreen"));
        this.previousScreen = callbackScreen;
        this.onDataReceived1 = onDataReceived;
        this.onDataReceived2 = null;
        this.titleText = titleText;
        this.messageText = messageText;
        this.validator = validator;
        this.defaultValue = defaultValue;
        this.shouldClose = shouldClose;
    }

    public StringInputScreen(Screen callbackScreen, Text titleText, Text messageText, String validator, Function<String, String> onDataReceived) {
        this(callbackScreen, titleText, messageText, validator, "", onDataReceived);
    }

    public StringInputScreen(Screen callbackScreen, Text titleText, Text messageText, String validator, String defaultValue, Function<String, String> onDataReceived) {
        this(callbackScreen, titleText, messageText, validator, defaultValue, onDataReceived, null);
    }

    public StringInputScreen(Screen callbackScreen, Text titleText, Text messageText, String validator, String defaultValue, Function<String, String> onDataReceived, Supplier<Boolean> shouldClose) {
        super((Component)Component.literal((String)"StringInputScreen"));
        this.previousScreen = callbackScreen;
        this.onDataReceived1 = null;
        this.onDataReceived2 = onDataReceived;
        this.titleText = titleText;
        this.messageText = messageText;
        this.validator = validator;
        this.defaultValue = defaultValue;
        this.shouldClose = shouldClose;
    }

    protected void init() {
        if (this.shouldClose != null && Boolean.TRUE.equals(this.shouldClose.get())) {
            Minecraft.getInstance().setScreen(this.previousScreen);
        }
        this.inputField = GuiUtils.newTextFieldWidget(this.font, this.width / 2 - 100, this.height / 2 - 20, 200, 20, (Component)GuiUtils.textToComponent(this.messageText));
        this.inputField.setMaxLength(Integer.MAX_VALUE);
        if (StringUtils.isNotNullOrEmpty(this.validator)) {
            this.inputField.setFilter(s -> s.matches(this.validator));
        }
        this.inputField.setValue(this.defaultValue);
        this.addRenderableWidget((GuiEventListener)this.inputField);
        this.submitButton = GuiUtils.newButton(this.width / 2 + 5, this.height / 2 + 10, 95, 20, (Component)Component.literal((String)"\u63d0\u4ea4"), button -> {
            String value = this.inputField.getValue();
            if (StringUtils.isNullOrEmpty(value)) {
                Minecraft.getInstance().setScreen(this.previousScreen);
            } else if (this.onDataReceived1 != null) {
                this.onDataReceived1.accept(value);
                Minecraft.getInstance().setScreen(this.previousScreen);
            } else if (this.onDataReceived2 != null) {
                String result = this.onDataReceived2.apply(value);
                if (StringUtils.isNotNullOrEmpty(result)) {
                    this.errorText = Text.literal(result).setColor(-65536);
                } else {
                    Minecraft.getInstance().setScreen(this.previousScreen);
                }
            }
        });
        this.addRenderableWidget((GuiEventListener)this.submitButton);
        this.addRenderableWidget((GuiEventListener)GuiUtils.newButton(this.width / 2 - 100, this.height / 2 + 10, 95, 20, (Component)Component.literal((String)"\u53d6\u6d88"), button -> Minecraft.getInstance().setScreen(this.previousScreen)));
    }

    @ParametersAreNonnullByDefault
    public void render(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.renderBackground(graphics);
        super.render(graphics, mouseX, mouseY, delta);
        GuiUtils.drawString(this.titleText.setGraphics(graphics), (float)this.width / 2.0f - 100.0f, (float)this.height / 2.0f - 33.0f);
        if (this.errorText != null) {
            GuiUtils.drawLimitedText(this.errorText.setGraphics(graphics), (double)((float)this.width / 2.0f - 100.0f), (double)((float)this.height / 2.0f + 2.0f), 200, GuiUtils.EllipsisPosition.MIDDLE);
        }
        if (StringUtils.isNotNullOrEmpty(this.inputField.getValue())) {
            this.submitButton.setMessage((Component)Component.literal((String)"\u63d0\u4ea4"));
        } else {
            this.submitButton.setMessage((Component)Component.literal((String)"\u53d6\u6d88"));
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 3) {
            Minecraft.getInstance().setScreen(this.previousScreen);
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 259 && !this.inputField.isFocused()) {
            Minecraft.getInstance().setScreen(this.previousScreen);
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean isPauseScreen() {
        return false;
    }
}

