/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.api.client.screen.component;

import com.mojang.blaze3d.platform.NativeImage;
import committee.nova.mods.avaritia.api.client.screen.component.KeyEventManager;
import committee.nova.mods.avaritia.api.client.screen.component.Text;
import committee.nova.mods.avaritia.api.client.screen.coordinate.Coordinate;
import committee.nova.mods.avaritia.api.client.screen.coordinate.TexCoordinate;
import committee.nova.mods.avaritia.api.client.util.GuiUtils;
import committee.nova.mods.avaritia.api.client.util.TextureUtils;
import committee.nova.mods.avaritia.api.util.StringUtils;
import java.util.function.Consumer;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class OperationButton {
    private String id;
    private Consumer<RenderContext> customRenderFunction;
    private Runnable customPopupFunction = null;
    private ResourceLocation texture;
    private boolean transparentCheck;
    private int textureWidth;
    private int textureHeight;
    private double baseX;
    private double baseY;
    private double scale = 1.0;
    private double x;
    private double y;
    private double width;
    private double height;
    private int operation;
    private boolean pressed;
    private boolean hovered;
    private double normalU;
    private double normalV;
    private double normalWidth;
    private double normalHeight;
    private double hoverU;
    private double hoverV;
    private double hoverWidth;
    private double hoverHeight;
    private double tapU;
    private double tapV;
    private double tapWidth;
    private double tapHeight;
    private int normalBgColor;
    private int hoverBgColor;
    private int tapBgColor;
    private int normalFgColor;
    private int hoverFgColor;
    private int tapFgColor;
    private boolean flipHorizontal;
    private boolean flipVertical;
    private double rotatedAngle;
    private double tremblingAmplitude;
    private Text tooltip;
    private String keyNames;

    public OperationButton(int operation, Consumer<RenderContext> customRenderFunction) {
        this.operation = operation;
        this.customRenderFunction = customRenderFunction;
    }

    public OperationButton(int operation, ResourceLocation resource) {
        this.operation = operation;
        this.texture = resource;
        this.transparentCheck = true;
    }

    public OperationButton setCoordinate(Coordinate coordinate) {
        this.x = coordinate.getX();
        this.y = coordinate.getY();
        this.width = coordinate.getWidth();
        this.height = coordinate.getHeight();
        return this;
    }

    public OperationButton setNormal(Coordinate normal) {
        this.normalU = normal.getU0();
        this.normalV = normal.getV0();
        this.normalWidth = normal.getUWidth();
        this.normalHeight = normal.getVHeight();
        return this;
    }

    public OperationButton setHover(Coordinate hover) {
        this.hoverU = hover.getU0();
        this.hoverV = hover.getV0();
        this.hoverWidth = hover.getUWidth();
        this.hoverHeight = hover.getVHeight();
        return this;
    }

    public OperationButton setTap(Coordinate tap) {
        this.tapU = tap.getU0();
        this.tapV = tap.getV0();
        this.tapWidth = tap.getUWidth();
        this.tapHeight = tap.getVHeight();
        return this;
    }

    public double getRealX() {
        return this.baseX + this.x * this.scale;
    }

    public double getRealY() {
        return this.baseY + this.y * this.scale;
    }

    public double getRealWidth() {
        return this.width * this.scale;
    }

    public double getRealHeight() {
        return this.height * this.scale;
    }

    public double getRealMouseX(double mouseX, double mouseY) {
        double startX = this.getRealX();
        double startY = this.getRealY();
        double width = this.getRealWidth();
        double height = this.getRealHeight();
        double realX = mouseX;
        if (this.getRotatedAngle() == 90.0) {
            realX = startX + (mouseY - startY);
        } else if (this.getRotatedAngle() == 180.0) {
            realX = startX + (width - (mouseX - startX));
        } else if (this.getRotatedAngle() == 270.0) {
            realX = startX + (height - (mouseY - startY));
        }
        if (this.flipHorizontal) {
            realX = startX + (width - (realX - startX));
        }
        return realX;
    }

    public double getRealMouseY(double mouseX, double mouseY) {
        double startX = this.getRealX();
        double startY = this.getRealY();
        double width = this.getRealWidth();
        double height = this.getRealHeight();
        double realY = mouseY;
        if (this.getRotatedAngle() == 90.0) {
            realY = startY + (width - (mouseX - startX));
        } else if (this.getRotatedAngle() == 180.0) {
            realY = startY + (height - (mouseY - startY));
        } else if (this.getRotatedAngle() == 270.0) {
            realY = startY + (mouseX - startX);
        }
        if (this.flipVertical) {
            realY = startY + (height - (realY - startY));
        }
        return realY;
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return mouseX >= this.getRealX() && mouseX <= this.getRealX() + this.getRealWidth() && mouseY >= this.getRealY() && mouseY <= this.getRealY() + this.getRealHeight();
    }

    public boolean isMouseOverEx(double mouseX, double mouseY) {
        if (!this.isMouseOver(mouseX, mouseY)) {
            return false;
        }
        if (this.texture == null) {
            return true;
        }
        if (!this.transparentCheck) {
            return true;
        }
        int textureX = (int)((this.getRealMouseX(mouseX, mouseY) - this.getRealX()) / (this.getRealWidth() / this.getHoverWidth()) + this.hoverU);
        int textureY = (int)((this.getRealMouseY(mouseX, mouseY) - this.getRealY()) / (this.getRealHeight() / this.getHoverHeight()) + this.hoverV);
        NativeImage image = TextureUtils.getTextureImage(this.texture);
        if (image != null) {
            int pixel = image.getPixelRGBA(textureX, textureY);
            int alpha = pixel >> 24 & 0xFF;
            return alpha > 0;
        }
        return true;
    }

    public double getU() {
        if (this.hovered && this.pressed) {
            return this.tapU;
        }
        if (this.hovered) {
            return this.hoverU;
        }
        return this.normalU;
    }

    public double getV() {
        if (this.hovered && this.pressed) {
            return this.tapV;
        }
        if (this.hovered) {
            return this.hoverV;
        }
        return this.normalV;
    }

    public double getUWidth() {
        if (this.hovered && this.pressed) {
            return this.tapWidth;
        }
        if (this.hovered) {
            return this.hoverWidth;
        }
        return this.normalWidth;
    }

    public double getVHeight() {
        if (this.hovered && this.pressed) {
            return this.tapHeight;
        }
        if (this.hovered) {
            return this.hoverHeight;
        }
        return this.normalHeight;
    }

    public int getBackgroundColor() {
        if (this.hovered && this.pressed) {
            return this.tapBgColor;
        }
        if (this.hovered) {
            return this.hoverBgColor;
        }
        return this.normalBgColor;
    }

    private int getForegroundColor() {
        if (this.hovered && this.pressed) {
            return this.tapFgColor;
        }
        if (this.hovered) {
            return this.hoverFgColor;
        }
        return this.normalFgColor;
    }

    public OperationButton setTooltip(String content) {
        this.tooltip = Text.literal(content);
        return this;
    }

    public OperationButton setTooltip(Text text) {
        this.tooltip = text;
        return this;
    }

    public void render(GuiGraphics graphics, KeyEventManager keyManager) {
        this.render(graphics, false, keyManager);
    }

    public void render(GuiGraphics graphics, boolean renderPopup, KeyEventManager keyManager) {
        if (this.customRenderFunction != null) {
            this.customRenderFunction.accept(new RenderContext(graphics, keyManager, this));
        } else {
            TexCoordinate texCoordinate = new TexCoordinate().setTotalWidth(this.textureWidth).setTotalHeight(this.textureHeight);
            Coordinate coordinate = new Coordinate().setX(this.x).setY(this.y).setWidth(this.width).setHeight(this.height).setU0(this.getU()).setV0(this.getV()).setUWidth(this.getUWidth()).setVHeight(this.getVHeight());
            int bgColor = this.getBackgroundColor();
            if (bgColor != 0) {
                GuiUtils.fill(graphics, (int)(this.baseX + coordinate.getX() * this.scale), (int)(this.baseY + coordinate.getY() * this.scale), (int)(coordinate.getWidth() * this.scale), (int)(coordinate.getHeight() * this.scale), bgColor);
            }
            if (this.isHovered() && this.getTremblingAmplitude() > 0.0) {
                GuiUtils.renderTremblingTexture(graphics, this.texture, texCoordinate, coordinate, this.baseX, this.baseY, this.scale, true, this.getTremblingAmplitude());
            } else {
                GuiUtils.renderRotatedTexture(graphics, this.texture, texCoordinate, coordinate, this.baseX, this.baseY, this.scale, this.rotatedAngle, this.flipHorizontal, this.flipVertical);
            }
            int fgColor = this.getForegroundColor();
            if (fgColor != 0) {
                GuiUtils.fill(graphics, (int)(this.baseX + coordinate.getX() * this.scale), (int)(this.baseY + coordinate.getY() * this.scale), (int)(coordinate.getWidth() * this.scale), (int)(coordinate.getHeight() * this.scale), fgColor);
            }
        }
        if (renderPopup) {
            this.renderPopup(graphics, null, keyManager);
        }
    }

    public void renderPopup(GuiGraphics graphics, KeyEventManager keyManager) {
        this.renderPopup(graphics, null, keyManager);
    }

    public void renderPopup(GuiGraphics graphics, Font font, KeyEventManager keyManager) {
        if ((StringUtils.isNullOrEmptyEx(this.keyNames) || keyManager.isKeyPressed(this.keyNames)) && this.isHovered()) {
            if (this.customPopupFunction != null) {
                this.customPopupFunction.run();
            } else if (this.tooltip != null && StringUtils.isNotNullOrEmpty(this.tooltip.getContent()) && Minecraft.getInstance().screen != null) {
                if (font == null) {
                    font = Minecraft.getInstance().font;
                }
                GuiUtils.drawPopupMessage(this.tooltip.setGraphics(graphics).setFont(font), (int)keyManager.getMouseX(), (int)keyManager.getMouseY(), Minecraft.getInstance().screen.width, Minecraft.getInstance().screen.height);
            }
        }
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public Consumer<RenderContext> getCustomRenderFunction() {
        return this.customRenderFunction;
    }

    @Generated
    public Runnable getCustomPopupFunction() {
        return this.customPopupFunction;
    }

    @Generated
    public ResourceLocation getTexture() {
        return this.texture;
    }

    @Generated
    public boolean isTransparentCheck() {
        return this.transparentCheck;
    }

    @Generated
    public int getTextureWidth() {
        return this.textureWidth;
    }

    @Generated
    public int getTextureHeight() {
        return this.textureHeight;
    }

    @Generated
    public double getBaseX() {
        return this.baseX;
    }

    @Generated
    public double getBaseY() {
        return this.baseY;
    }

    @Generated
    public double getScale() {
        return this.scale;
    }

    @Generated
    public double getX() {
        return this.x;
    }

    @Generated
    public double getY() {
        return this.y;
    }

    @Generated
    public double getWidth() {
        return this.width;
    }

    @Generated
    public double getHeight() {
        return this.height;
    }

    @Generated
    public int getOperation() {
        return this.operation;
    }

    @Generated
    public boolean isPressed() {
        return this.pressed;
    }

    @Generated
    public boolean isHovered() {
        return this.hovered;
    }

    @Generated
    public double getNormalU() {
        return this.normalU;
    }

    @Generated
    public double getNormalV() {
        return this.normalV;
    }

    @Generated
    public double getNormalWidth() {
        return this.normalWidth;
    }

    @Generated
    public double getNormalHeight() {
        return this.normalHeight;
    }

    @Generated
    public double getHoverU() {
        return this.hoverU;
    }

    @Generated
    public double getHoverV() {
        return this.hoverV;
    }

    @Generated
    public double getHoverWidth() {
        return this.hoverWidth;
    }

    @Generated
    public double getHoverHeight() {
        return this.hoverHeight;
    }

    @Generated
    public double getTapU() {
        return this.tapU;
    }

    @Generated
    public double getTapV() {
        return this.tapV;
    }

    @Generated
    public double getTapWidth() {
        return this.tapWidth;
    }

    @Generated
    public double getTapHeight() {
        return this.tapHeight;
    }

    @Generated
    public int getNormalBgColor() {
        return this.normalBgColor;
    }

    @Generated
    public int getHoverBgColor() {
        return this.hoverBgColor;
    }

    @Generated
    public int getTapBgColor() {
        return this.tapBgColor;
    }

    @Generated
    public int getNormalFgColor() {
        return this.normalFgColor;
    }

    @Generated
    public int getHoverFgColor() {
        return this.hoverFgColor;
    }

    @Generated
    public int getTapFgColor() {
        return this.tapFgColor;
    }

    @Generated
    public boolean isFlipHorizontal() {
        return this.flipHorizontal;
    }

    @Generated
    public boolean isFlipVertical() {
        return this.flipVertical;
    }

    @Generated
    public double getRotatedAngle() {
        return this.rotatedAngle;
    }

    @Generated
    public double getTremblingAmplitude() {
        return this.tremblingAmplitude;
    }

    @Generated
    public Text getTooltip() {
        return this.tooltip;
    }

    @Generated
    public String getKeyNames() {
        return this.keyNames;
    }

    @Generated
    public OperationButton setId(String id) {
        this.id = id;
        return this;
    }

    @Generated
    public OperationButton setCustomRenderFunction(Consumer<RenderContext> customRenderFunction) {
        this.customRenderFunction = customRenderFunction;
        return this;
    }

    @Generated
    public OperationButton setCustomPopupFunction(Runnable customPopupFunction) {
        this.customPopupFunction = customPopupFunction;
        return this;
    }

    @Generated
    public OperationButton setTexture(ResourceLocation texture) {
        this.texture = texture;
        return this;
    }

    @Generated
    public OperationButton setTransparentCheck(boolean transparentCheck) {
        this.transparentCheck = transparentCheck;
        return this;
    }

    @Generated
    public OperationButton setTextureWidth(int textureWidth) {
        this.textureWidth = textureWidth;
        return this;
    }

    @Generated
    public OperationButton setTextureHeight(int textureHeight) {
        this.textureHeight = textureHeight;
        return this;
    }

    @Generated
    public OperationButton setBaseX(double baseX) {
        this.baseX = baseX;
        return this;
    }

    @Generated
    public OperationButton setBaseY(double baseY) {
        this.baseY = baseY;
        return this;
    }

    @Generated
    public OperationButton setScale(double scale) {
        this.scale = scale;
        return this;
    }

    @Generated
    public OperationButton setX(double x) {
        this.x = x;
        return this;
    }

    @Generated
    public OperationButton setY(double y) {
        this.y = y;
        return this;
    }

    @Generated
    public OperationButton setWidth(double width) {
        this.width = width;
        return this;
    }

    @Generated
    public OperationButton setHeight(double height) {
        this.height = height;
        return this;
    }

    @Generated
    public OperationButton setOperation(int operation) {
        this.operation = operation;
        return this;
    }

    @Generated
    public OperationButton setPressed(boolean pressed) {
        this.pressed = pressed;
        return this;
    }

    @Generated
    public OperationButton setHovered(boolean hovered) {
        this.hovered = hovered;
        return this;
    }

    @Generated
    public OperationButton setNormalU(double normalU) {
        this.normalU = normalU;
        return this;
    }

    @Generated
    public OperationButton setNormalV(double normalV) {
        this.normalV = normalV;
        return this;
    }

    @Generated
    public OperationButton setNormalWidth(double normalWidth) {
        this.normalWidth = normalWidth;
        return this;
    }

    @Generated
    public OperationButton setNormalHeight(double normalHeight) {
        this.normalHeight = normalHeight;
        return this;
    }

    @Generated
    public OperationButton setHoverU(double hoverU) {
        this.hoverU = hoverU;
        return this;
    }

    @Generated
    public OperationButton setHoverV(double hoverV) {
        this.hoverV = hoverV;
        return this;
    }

    @Generated
    public OperationButton setHoverWidth(double hoverWidth) {
        this.hoverWidth = hoverWidth;
        return this;
    }

    @Generated
    public OperationButton setHoverHeight(double hoverHeight) {
        this.hoverHeight = hoverHeight;
        return this;
    }

    @Generated
    public OperationButton setTapU(double tapU) {
        this.tapU = tapU;
        return this;
    }

    @Generated
    public OperationButton setTapV(double tapV) {
        this.tapV = tapV;
        return this;
    }

    @Generated
    public OperationButton setTapWidth(double tapWidth) {
        this.tapWidth = tapWidth;
        return this;
    }

    @Generated
    public OperationButton setTapHeight(double tapHeight) {
        this.tapHeight = tapHeight;
        return this;
    }

    @Generated
    public OperationButton setNormalBgColor(int normalBgColor) {
        this.normalBgColor = normalBgColor;
        return this;
    }

    @Generated
    public OperationButton setHoverBgColor(int hoverBgColor) {
        this.hoverBgColor = hoverBgColor;
        return this;
    }

    @Generated
    public OperationButton setTapBgColor(int tapBgColor) {
        this.tapBgColor = tapBgColor;
        return this;
    }

    @Generated
    public OperationButton setNormalFgColor(int normalFgColor) {
        this.normalFgColor = normalFgColor;
        return this;
    }

    @Generated
    public OperationButton setHoverFgColor(int hoverFgColor) {
        this.hoverFgColor = hoverFgColor;
        return this;
    }

    @Generated
    public OperationButton setTapFgColor(int tapFgColor) {
        this.tapFgColor = tapFgColor;
        return this;
    }

    @Generated
    public OperationButton setFlipHorizontal(boolean flipHorizontal) {
        this.flipHorizontal = flipHorizontal;
        return this;
    }

    @Generated
    public OperationButton setFlipVertical(boolean flipVertical) {
        this.flipVertical = flipVertical;
        return this;
    }

    @Generated
    public OperationButton setRotatedAngle(double rotatedAngle) {
        this.rotatedAngle = rotatedAngle;
        return this;
    }

    @Generated
    public OperationButton setTremblingAmplitude(double tremblingAmplitude) {
        this.tremblingAmplitude = tremblingAmplitude;
        return this;
    }

    @Generated
    public OperationButton setKeyNames(String keyNames) {
        this.keyNames = keyNames;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OperationButton)) {
            return false;
        }
        OperationButton other = (OperationButton)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isTransparentCheck() != other.isTransparentCheck()) {
            return false;
        }
        if (this.getTextureWidth() != other.getTextureWidth()) {
            return false;
        }
        if (this.getTextureHeight() != other.getTextureHeight()) {
            return false;
        }
        if (Double.compare(this.getBaseX(), other.getBaseX()) != 0) {
            return false;
        }
        if (Double.compare(this.getBaseY(), other.getBaseY()) != 0) {
            return false;
        }
        if (Double.compare(this.getScale(), other.getScale()) != 0) {
            return false;
        }
        if (Double.compare(this.getX(), other.getX()) != 0) {
            return false;
        }
        if (Double.compare(this.getY(), other.getY()) != 0) {
            return false;
        }
        if (Double.compare(this.getWidth(), other.getWidth()) != 0) {
            return false;
        }
        if (Double.compare(this.getHeight(), other.getHeight()) != 0) {
            return false;
        }
        if (this.getOperation() != other.getOperation()) {
            return false;
        }
        if (this.isPressed() != other.isPressed()) {
            return false;
        }
        if (this.isHovered() != other.isHovered()) {
            return false;
        }
        if (Double.compare(this.getNormalU(), other.getNormalU()) != 0) {
            return false;
        }
        if (Double.compare(this.getNormalV(), other.getNormalV()) != 0) {
            return false;
        }
        if (Double.compare(this.getNormalWidth(), other.getNormalWidth()) != 0) {
            return false;
        }
        if (Double.compare(this.getNormalHeight(), other.getNormalHeight()) != 0) {
            return false;
        }
        if (Double.compare(this.getHoverU(), other.getHoverU()) != 0) {
            return false;
        }
        if (Double.compare(this.getHoverV(), other.getHoverV()) != 0) {
            return false;
        }
        if (Double.compare(this.getHoverWidth(), other.getHoverWidth()) != 0) {
            return false;
        }
        if (Double.compare(this.getHoverHeight(), other.getHoverHeight()) != 0) {
            return false;
        }
        if (Double.compare(this.getTapU(), other.getTapU()) != 0) {
            return false;
        }
        if (Double.compare(this.getTapV(), other.getTapV()) != 0) {
            return false;
        }
        if (Double.compare(this.getTapWidth(), other.getTapWidth()) != 0) {
            return false;
        }
        if (Double.compare(this.getTapHeight(), other.getTapHeight()) != 0) {
            return false;
        }
        if (this.getNormalBgColor() != other.getNormalBgColor()) {
            return false;
        }
        if (this.getHoverBgColor() != other.getHoverBgColor()) {
            return false;
        }
        if (this.getTapBgColor() != other.getTapBgColor()) {
            return false;
        }
        if (this.getNormalFgColor() != other.getNormalFgColor()) {
            return false;
        }
        if (this.getHoverFgColor() != other.getHoverFgColor()) {
            return false;
        }
        if (this.getTapFgColor() != other.getTapFgColor()) {
            return false;
        }
        if (this.isFlipHorizontal() != other.isFlipHorizontal()) {
            return false;
        }
        if (this.isFlipVertical() != other.isFlipVertical()) {
            return false;
        }
        if (Double.compare(this.getRotatedAngle(), other.getRotatedAngle()) != 0) {
            return false;
        }
        if (Double.compare(this.getTremblingAmplitude(), other.getTremblingAmplitude()) != 0) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Consumer<RenderContext> this$customRenderFunction = this.getCustomRenderFunction();
        Consumer<RenderContext> other$customRenderFunction = other.getCustomRenderFunction();
        if (this$customRenderFunction == null ? other$customRenderFunction != null : !this$customRenderFunction.equals(other$customRenderFunction)) {
            return false;
        }
        Runnable this$customPopupFunction = this.getCustomPopupFunction();
        Runnable other$customPopupFunction = other.getCustomPopupFunction();
        if (this$customPopupFunction == null ? other$customPopupFunction != null : !this$customPopupFunction.equals(other$customPopupFunction)) {
            return false;
        }
        ResourceLocation this$texture = this.getTexture();
        ResourceLocation other$texture = other.getTexture();
        if (this$texture == null ? other$texture != null : !this$texture.equals(other$texture)) {
            return false;
        }
        Text this$tooltip = this.getTooltip();
        Text other$tooltip = other.getTooltip();
        if (this$tooltip == null ? other$tooltip != null : !this$tooltip.equals(other$tooltip)) {
            return false;
        }
        String this$keyNames = this.getKeyNames();
        String other$keyNames = other.getKeyNames();
        return !(this$keyNames == null ? other$keyNames != null : !this$keyNames.equals(other$keyNames));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OperationButton;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isTransparentCheck() ? 79 : 97);
        result = result * 59 + this.getTextureWidth();
        result = result * 59 + this.getTextureHeight();
        long $baseX = Double.doubleToLongBits(this.getBaseX());
        result = result * 59 + (int)($baseX >>> 32 ^ $baseX);
        long $baseY = Double.doubleToLongBits(this.getBaseY());
        result = result * 59 + (int)($baseY >>> 32 ^ $baseY);
        long $scale = Double.doubleToLongBits(this.getScale());
        result = result * 59 + (int)($scale >>> 32 ^ $scale);
        long $x = Double.doubleToLongBits(this.getX());
        result = result * 59 + (int)($x >>> 32 ^ $x);
        long $y = Double.doubleToLongBits(this.getY());
        result = result * 59 + (int)($y >>> 32 ^ $y);
        long $width = Double.doubleToLongBits(this.getWidth());
        result = result * 59 + (int)($width >>> 32 ^ $width);
        long $height = Double.doubleToLongBits(this.getHeight());
        result = result * 59 + (int)($height >>> 32 ^ $height);
        result = result * 59 + this.getOperation();
        result = result * 59 + (this.isPressed() ? 79 : 97);
        result = result * 59 + (this.isHovered() ? 79 : 97);
        long $normalU = Double.doubleToLongBits(this.getNormalU());
        result = result * 59 + (int)($normalU >>> 32 ^ $normalU);
        long $normalV = Double.doubleToLongBits(this.getNormalV());
        result = result * 59 + (int)($normalV >>> 32 ^ $normalV);
        long $normalWidth = Double.doubleToLongBits(this.getNormalWidth());
        result = result * 59 + (int)($normalWidth >>> 32 ^ $normalWidth);
        long $normalHeight = Double.doubleToLongBits(this.getNormalHeight());
        result = result * 59 + (int)($normalHeight >>> 32 ^ $normalHeight);
        long $hoverU = Double.doubleToLongBits(this.getHoverU());
        result = result * 59 + (int)($hoverU >>> 32 ^ $hoverU);
        long $hoverV = Double.doubleToLongBits(this.getHoverV());
        result = result * 59 + (int)($hoverV >>> 32 ^ $hoverV);
        long $hoverWidth = Double.doubleToLongBits(this.getHoverWidth());
        result = result * 59 + (int)($hoverWidth >>> 32 ^ $hoverWidth);
        long $hoverHeight = Double.doubleToLongBits(this.getHoverHeight());
        result = result * 59 + (int)($hoverHeight >>> 32 ^ $hoverHeight);
        long $tapU = Double.doubleToLongBits(this.getTapU());
        result = result * 59 + (int)($tapU >>> 32 ^ $tapU);
        long $tapV = Double.doubleToLongBits(this.getTapV());
        result = result * 59 + (int)($tapV >>> 32 ^ $tapV);
        long $tapWidth = Double.doubleToLongBits(this.getTapWidth());
        result = result * 59 + (int)($tapWidth >>> 32 ^ $tapWidth);
        long $tapHeight = Double.doubleToLongBits(this.getTapHeight());
        result = result * 59 + (int)($tapHeight >>> 32 ^ $tapHeight);
        result = result * 59 + this.getNormalBgColor();
        result = result * 59 + this.getHoverBgColor();
        result = result * 59 + this.getTapBgColor();
        result = result * 59 + this.getNormalFgColor();
        result = result * 59 + this.getHoverFgColor();
        result = result * 59 + this.getTapFgColor();
        result = result * 59 + (this.isFlipHorizontal() ? 79 : 97);
        result = result * 59 + (this.isFlipVertical() ? 79 : 97);
        long $rotatedAngle = Double.doubleToLongBits(this.getRotatedAngle());
        result = result * 59 + (int)($rotatedAngle >>> 32 ^ $rotatedAngle);
        long $tremblingAmplitude = Double.doubleToLongBits(this.getTremblingAmplitude());
        result = result * 59 + (int)($tremblingAmplitude >>> 32 ^ $tremblingAmplitude);
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Consumer<RenderContext> $customRenderFunction = this.getCustomRenderFunction();
        result = result * 59 + ($customRenderFunction == null ? 43 : $customRenderFunction.hashCode());
        Runnable $customPopupFunction = this.getCustomPopupFunction();
        result = result * 59 + ($customPopupFunction == null ? 43 : $customPopupFunction.hashCode());
        ResourceLocation $texture = this.getTexture();
        result = result * 59 + ($texture == null ? 43 : $texture.hashCode());
        Text $tooltip = this.getTooltip();
        result = result * 59 + ($tooltip == null ? 43 : $tooltip.hashCode());
        String $keyNames = this.getKeyNames();
        result = result * 59 + ($keyNames == null ? 43 : $keyNames.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "OperationButton(id=" + this.getId() + ", customRenderFunction=" + String.valueOf(this.getCustomRenderFunction()) + ", customPopupFunction=" + String.valueOf(this.getCustomPopupFunction()) + ", texture=" + String.valueOf(this.getTexture()) + ", transparentCheck=" + this.isTransparentCheck() + ", textureWidth=" + this.getTextureWidth() + ", textureHeight=" + this.getTextureHeight() + ", baseX=" + this.getBaseX() + ", baseY=" + this.getBaseY() + ", scale=" + this.getScale() + ", x=" + this.getX() + ", y=" + this.getY() + ", width=" + this.getWidth() + ", height=" + this.getHeight() + ", operation=" + this.getOperation() + ", pressed=" + this.isPressed() + ", hovered=" + this.isHovered() + ", normalU=" + this.getNormalU() + ", normalV=" + this.getNormalV() + ", normalWidth=" + this.getNormalWidth() + ", normalHeight=" + this.getNormalHeight() + ", hoverU=" + this.getHoverU() + ", hoverV=" + this.getHoverV() + ", hoverWidth=" + this.getHoverWidth() + ", hoverHeight=" + this.getHoverHeight() + ", tapU=" + this.getTapU() + ", tapV=" + this.getTapV() + ", tapWidth=" + this.getTapWidth() + ", tapHeight=" + this.getTapHeight() + ", normalBgColor=" + this.getNormalBgColor() + ", hoverBgColor=" + this.getHoverBgColor() + ", tapBgColor=" + this.getTapBgColor() + ", normalFgColor=" + this.getNormalFgColor() + ", hoverFgColor=" + this.getHoverFgColor() + ", tapFgColor=" + this.getTapFgColor() + ", flipHorizontal=" + this.isFlipHorizontal() + ", flipVertical=" + this.isFlipVertical() + ", rotatedAngle=" + this.getRotatedAngle() + ", tremblingAmplitude=" + this.getTremblingAmplitude() + ", tooltip=" + String.valueOf(this.getTooltip()) + ", keyNames=" + this.getKeyNames() + ")";
    }

    public record RenderContext(GuiGraphics graphics, KeyEventManager keyManager, OperationButton button) {
    }
}

