/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.api.client.screen.component;

import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FastColor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class SimpleScrollBar
extends AbstractWidget {
    private boolean scrolling = false;
    private double scrollTagSize = 4.0;
    private double scrolledOn = 0.0;
    private int scrollBarTagColor = FastColor.ARGB32.color((int)255, (int)77, (int)73, (int)77);
    private int scrollBarBackgroundColor = FastColor.ARGB32.color((int)255, (int)36, (int)30, (int)31);

    public SimpleScrollBar(int x, int y, int weight, int height, Component message) {
        super(x, y, weight, height, message);
        if (height < weight * 2) {
            this.setSize(weight, weight * 2);
        }
    }

    public SimpleScrollBar(int x, int y, int weight, int height) {
        this(x, y, weight, height, CommonComponents.EMPTY);
    }

    public void setPos(int x, int y) {
        this.setX(x);
        this.setY(y);
    }

    public void setSize(int weight, int height) {
        this.width = weight;
        this.height = height;
    }

    public void setScrolledOn(double scrolledOn) {
        this.scrolledOn = Math.max(0.0, Math.min(1.0, scrolledOn));
        this.draggedTo(this.scrolledOn);
    }

    public void setScrollTagSize(double scrollTagSize) {
        this.scrollTagSize = Math.max((double)this.width, Math.min((double)this.height, scrollTagSize));
    }

    public double getScrollOn() {
        return this.scrolledOn;
    }

    public boolean canScroll() {
        return this.scrollTagSize < (double)this.height;
    }

    public void onClick(double pMouseX, double pMouseY) {
        this.scrolling = true;
        this.onDragTo(pMouseY);
    }

    public void onRelease(double pMouseX, double pMouseY) {
        this.scrolling = false;
    }

    protected void onDrag(double mouseX, double mouseY, double pDragX, double pDragY) {
        this.onDragTo(mouseY);
    }

    public void onDragTo(double mouseY) {
        if (mouseY <= (double)this.getY()) {
            this.scrolledOn = 0.0;
        } else if (mouseY >= (double)(this.getY() + this.getHeight())) {
            this.scrolledOn = 1.0;
        } else {
            double v = (mouseY - (double)this.getY() - this.scrollTagSize / 2.0) / ((double)this.getHeight() - this.scrollTagSize);
            this.setScrolledOn(v);
        }
        this.draggedTo(this.scrolledOn);
    }

    public abstract void draggedTo(double var1);

    public abstract void beforeRender();

    @ParametersAreNonnullByDefault
    public void renderWidget(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.beforeRender();
        if (!this.visible) {
            return;
        }
        guiGraphics.fill(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, this.scrollBarBackgroundColor);
        double v = (double)this.getY() + ((double)this.getHeight() - this.scrollTagSize) * this.scrolledOn;
        guiGraphics.fill(this.getX(), (int)Math.floor(v), this.getX() + this.width, (int)Math.ceil(v + this.scrollTagSize), this.scrollBarTagColor);
    }

    @ParametersAreNonnullByDefault
    public void updateWidgetNarration(NarrationElementOutput pNarrationElementOutput) {
        this.defaultButtonNarrationText(pNarrationElementOutput);
    }

    @Generated
    public boolean isScrolling() {
        return this.scrolling;
    }

    @Generated
    public void setScrolling(boolean scrolling) {
        this.scrolling = scrolling;
    }

    @Generated
    public double getScrollTagSize() {
        return this.scrollTagSize;
    }

    @Generated
    public double getScrolledOn() {
        return this.scrolledOn;
    }

    @Generated
    public void setScrollBarTagColor(int scrollBarTagColor) {
        this.scrollBarTagColor = scrollBarTagColor;
    }

    @Generated
    public void setScrollBarBackgroundColor(int scrollBarBackgroundColor) {
        this.scrollBarBackgroundColor = scrollBarBackgroundColor;
    }
}

