/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.api.client.util;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import committee.nova.mods.avaritia.api.client.model.IVertexConsumer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.client.renderer.block.model.BakedQuad;
import org.apache.commons.lang3.tuple.Pair;

public class VertexUtils {
    private static final ConcurrentMap<Pair<VertexFormat, VertexFormat>, int[]> formatMaps = new ConcurrentHashMap<Pair<VertexFormat, VertexFormat>, int[]>();
    private static final int[] DEFAULT_MAPPING = VertexUtils.generateMapping(DefaultVertexFormat.BLOCK, DefaultVertexFormat.BLOCK);

    public static int[] mapFormats(VertexFormat from, VertexFormat to) {
        if (from.equals((Object)DefaultVertexFormat.BLOCK) && to.equals((Object)DefaultVertexFormat.BLOCK)) {
            return DEFAULT_MAPPING;
        }
        return formatMaps.computeIfAbsent((Pair<VertexFormat, VertexFormat>)Pair.of((Object)from, (Object)to), pair -> VertexUtils.generateMapping((VertexFormat)pair.getLeft(), (VertexFormat)pair.getRight()));
    }

    public static void putQuad(IVertexConsumer consumer, BakedQuad quad) {
        consumer.setTexture(quad.getSprite());
        consumer.setQuadOrientation(quad.getDirection());
        if (quad.isTinted()) {
            consumer.setQuadTint(quad.getTintIndex());
        }
        consumer.setApplyDiffuseLighting(quad.isShade());
        float[] data = new float[4];
        VertexFormat formatFrom = consumer.getVertexFormat();
        VertexFormat formatTo = DefaultVertexFormat.BLOCK;
        int countFrom = formatFrom.getElements().size();
        int countTo = formatTo.getElements().size();
        int[] eMap = VertexUtils.mapFormats(formatFrom, formatTo);
        for (int v = 0; v < 4; ++v) {
            for (int e = 0; e < countFrom; ++e) {
                if (eMap[e] != countTo) {
                    VertexUtils.unpack(quad.getVertices(), data, formatTo, v, eMap[e]);
                    consumer.put(e, data);
                    continue;
                }
                consumer.put(e, new float[0]);
            }
        }
    }

    public static void unpack(int[] from, float[] to, VertexFormat formatFrom, int v, int e) {
        int length = Math.min(4, to.length);
        VertexFormatElement element = (VertexFormatElement)formatFrom.getElements().get(e);
        int vertexStart = v * formatFrom.getVertexSize() + formatFrom.getOffset(e);
        int count = element.getElementCount();
        VertexFormatElement.Type type = element.getType();
        VertexFormatElement.Usage usage = element.getUsage();
        int size = type.getSize();
        int mask = (256 << 8 * (size - 1)) - 1;
        for (int i = 0; i < length; ++i) {
            if (i < count) {
                int pos = vertexStart + size * i;
                int index = pos >> 2;
                int offset = pos & 3;
                int bits = from[index];
                bits >>>= offset * 8;
                if ((pos + size - 1) / 4 != index) {
                    bits |= from[index + 1] << (4 - offset) * 8;
                }
                bits &= mask;
                if (type == VertexFormatElement.Type.FLOAT) {
                    to[i] = Float.intBitsToFloat(bits);
                    continue;
                }
                if (type == VertexFormatElement.Type.UBYTE || type == VertexFormatElement.Type.USHORT) {
                    to[i] = (float)bits / (float)mask;
                    continue;
                }
                if (type == VertexFormatElement.Type.UINT) {
                    to[i] = (float)((double)((long)bits & 0xFFFFFFFFL) / 4.294967295E9);
                    continue;
                }
                if (type == VertexFormatElement.Type.BYTE) {
                    to[i] = (float)((byte)bits) / (float)(mask >> 1);
                    continue;
                }
                if (type == VertexFormatElement.Type.SHORT) {
                    to[i] = (float)((short)bits) / (float)(mask >> 1);
                    continue;
                }
                if (type != VertexFormatElement.Type.INT) continue;
                to[i] = (float)((double)((long)bits & 0xFFFFFFFFL) / 2.147483647E9);
                continue;
            }
            to[i] = i == 3 && usage == VertexFormatElement.Usage.POSITION ? 1.0f : 0.0f;
        }
    }

    public static void pack(float[] from, int[] to, VertexFormat formatTo, int v, int e) {
        VertexFormatElement element = (VertexFormatElement)formatTo.getElements().get(e);
        int vertexStart = v * formatTo.getVertexSize() + formatTo.getOffset(e);
        int count = element.getElementCount();
        VertexFormatElement.Type type = element.getType();
        int size = type.getSize();
        int mask = (256 << 8 * (size - 1)) - 1;
        for (int i = 0; i < 4; ++i) {
            float f;
            if (i >= count) continue;
            int pos = vertexStart + size * i;
            int index = pos >> 2;
            int offset = pos & 3;
            int bits = 0;
            float f2 = f = i < from.length ? from[i] : 0.0f;
            bits = type == VertexFormatElement.Type.FLOAT ? Float.floatToRawIntBits(f) : (type == VertexFormatElement.Type.UBYTE || type == VertexFormatElement.Type.USHORT || type == VertexFormatElement.Type.UINT ? Math.round(f * (float)mask) : Math.round(f * (float)(mask >> 1)));
            int n = index;
            to[n] = to[n] & ~(mask << offset * 8);
            int n2 = index;
            to[n2] = to[n2] | (bits & mask) << offset * 8;
        }
    }

    private static int[] generateMapping(VertexFormat from, VertexFormat to) {
        int fromCount = from.getElements().size();
        int toCount = to.getElements().size();
        int[] eMap = new int[fromCount];
        for (int e = 0; e < fromCount; ++e) {
            int e2;
            VertexFormatElement expected = (VertexFormatElement)from.getElements().get(e);
            for (e2 = 0; e2 < toCount; ++e2) {
                VertexFormatElement current = (VertexFormatElement)to.getElements().get(e2);
                if (expected.getUsage() == current.getUsage() && expected.getIndex() == current.getIndex()) break;
            }
            eMap[e] = e2;
        }
        return eMap;
    }
}

