/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.api.common.tile;

import committee.nova.mods.avaritia.api.common.tile.BaseTileEntity;
import committee.nova.mods.avaritia.api.common.wrapper.BaseItemWrapper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.LockCode;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseInventoryTileEntity
extends BaseTileEntity {
    public LazyOptional<IItemHandler> capability = LazyOptional.of(this::getInventory);
    private LockCode lockKey = LockCode.NO_LOCK;

    public BaseInventoryTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public static boolean canUnlock(Player pPlayer, LockCode pCode, Component pDisplayName) {
        if (!pPlayer.isSpectator() && !pCode.unlocksWith(pPlayer.getMainHandItem())) {
            pPlayer.displayClientMessage((Component)Component.translatable((String)"container.isLocked", (Object[])new Object[]{pDisplayName}), true);
            pPlayer.playNotifySound(SoundEvents.CHEST_LOCKED, SoundSource.BLOCKS, 1.0f, 1.0f);
            return false;
        }
        return true;
    }

    @NotNull
    public abstract BaseItemWrapper getInventory();

    public void load(@NotNull CompoundTag tag) {
        super.load(tag);
        this.lockKey = LockCode.fromTag((CompoundTag)tag);
        this.getInventory().deserializeNBT((Tag)tag);
    }

    public void saveAdditional(@NotNull CompoundTag tag) {
        super.saveAdditional(tag);
        this.lockKey.addToTag(tag);
        tag.merge((CompoundTag)this.getInventory().serializeNBT());
    }

    public boolean canOpen(Player pPlayer) {
        return BaseInventoryTileEntity.canUnlock(pPlayer, this.lockKey, this.getDisplayName());
    }

    @Nullable
    public AbstractContainerMenu createMenu(int pContainerId, @NotNull Inventory pPlayerInventory, @NotNull Player pPlayer) {
        return this.canOpen(pPlayer) ? this.createMenu(pContainerId, pPlayerInventory) : null;
    }

    protected abstract AbstractContainerMenu createMenu(int var1, Inventory var2);

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, Direction side) {
        if (!this.isRemoved() && cap == ForgeCapabilities.ITEM_HANDLER) {
            return ForgeCapabilities.ITEM_HANDLER.orEmpty(cap, this.capability);
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.capability.invalidate();
    }

    public void reviveCaps() {
        super.reviveCaps();
        this.capability = LazyOptional.of(this::getInventory);
    }

    public boolean isUsableByPlayer(Player player) {
        BlockPos pos = this.getBlockPos();
        return player.distanceToSqr((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5) <= 64.0;
    }
}

