/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.api.util;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import committee.nova.mods.avaritia.Const;
import committee.nova.mods.avaritia.api.util.NBTUtils;
import committee.nova.mods.avaritia.api.util.vec.Vector3;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import lombok.NonNull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemUtils {
    public static String getId(Item item) {
        ResourceLocation resource = ForgeRegistries.ITEMS.getKey((Object)item);
        if (resource == null) {
            return "minecraft:air";
        }
        return resource.toString();
    }

    public static String getId(ItemStack itemStack) {
        return ItemUtils.getId(itemStack.getItem()) + ItemUtils.getNbtString(itemStack);
    }

    public static Item getItem(String id) {
        String resourceId = id;
        if (id.contains("{") && id.endsWith("}")) {
            resourceId = resourceId.substring(0, id.indexOf("{"));
        }
        return (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(resourceId));
    }

    public static ItemStack getItemStack(String id) {
        ItemStack result = new ItemStack((ItemLike)Items.AIR);
        try {
            result = ItemUtils.getItemStack(id, false);
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        return result;
    }

    public static ItemStack getItemStack(String id, boolean throwException) throws CommandSyntaxException {
        Item item = ItemUtils.getItem(id);
        if (item == null) {
            throw new RuntimeException("Unknown item ID: " + id);
        }
        ItemStack itemStack = new ItemStack((ItemLike)item);
        if (id.contains("{") && id.endsWith("}") && !id.endsWith("{}")) {
            try {
                String nbtString = id.substring(id.indexOf("{"));
                CompoundTag nbt = TagParser.parseTag((String)nbtString);
                itemStack.setTag(nbt);
            }
            catch (Exception e) {
                if (throwException) {
                    throw e;
                }
                Const.LOGGER.error("Failed to parse NBT data", (Throwable)e);
            }
        }
        return itemStack;
    }

    public static String getNbtString(ItemStack itemStack) {
        String json = "";
        if (itemStack.hasTag() && itemStack.getTag() != null) {
            json = itemStack.getTag().toString();
        }
        return json;
    }

    @NonNull
    public static ItemStack deserialize(JsonObject json) {
        ItemStack itemStack;
        block5: {
            try {
                String itemId = json.get("item").getAsString();
                int count = json.get("count").getAsInt();
                count = Math.max(count, 1);
                Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemId));
                if (item == null) {
                    throw new JsonParseException("Unknown item ID: " + itemId);
                }
                itemStack = new ItemStack((ItemLike)item, count);
                if (!json.has("nbt")) break block5;
                try {
                    CompoundTag nbt = TagParser.parseTag((String)json.get("nbt").getAsString());
                    itemStack.setTag(nbt);
                }
                catch (CommandSyntaxException e) {
                    throw new JsonParseException("Failed to parse NBT data", (Throwable)e);
                }
            }
            catch (Exception e) {
                Const.LOGGER.error("Failed to deserialize item reward", (Throwable)e);
                itemStack = new ItemStack((ItemLike)Items.AIR);
            }
        }
        return itemStack;
    }

    public static JsonObject serialize(ItemStack reward) {
        JsonObject json = new JsonObject();
        try {
            json.addProperty("item", ItemUtils.getId(reward.getItem()));
            json.addProperty("count", (Number)reward.getCount());
            if (reward.hasTag() && reward.getTag() != null) {
                json.addProperty("nbt", ItemUtils.getNbtString(reward));
            }
        }
        catch (Exception e) {
            Const.LOGGER.error("Failed to serialize item reward", (Throwable)e);
            json.addProperty("item", ItemUtils.getId(Items.AIR));
            json.addProperty("count", (Number)0);
        }
        return json;
    }

    public String getDisplayName(JsonObject json) {
        return ItemUtils.deserialize(json).getDisplayName().getString().replaceAll("\\[(.*)]", "$1");
    }

    public static String getDisplayName(ItemStack itemStack) {
        return itemStack.getDisplayName().getString().replaceAll("\\[(.*)]", "$1");
    }

    public static String getDisplayName(Item item) {
        return new ItemStack((ItemLike)item).getDisplayName().getString().replaceAll("\\[(.*)]", "$1");
    }

    public static ItemStack mapEquals(ItemStack stack, Map<ItemStack, Integer> map) {
        for (ItemStack itemStack : map.keySet()) {
            if (itemStack.getItem() != stack.getItem()) continue;
            return itemStack;
        }
        return ItemStack.EMPTY;
    }

    public static ItemStack withSize(ItemStack stack, int size, boolean container) {
        if (size <= 0) {
            return container && stack.hasCraftingRemainingItem() ? stack.getCraftingRemainingItem() : ItemStack.EMPTY;
        }
        stack = stack.copy();
        stack.setCount(size);
        return stack;
    }

    public static ItemStack grow(ItemStack stack, int amount) {
        return ItemUtils.withSize(stack, stack.getCount() + amount, false);
    }

    public static ItemStack shrink(ItemStack stack, int amount, boolean container) {
        return stack.isEmpty() ? ItemStack.EMPTY : ItemUtils.withSize(stack, stack.getCount() - amount, container);
    }

    public static ItemStack copyStack(@Nonnull ItemStack stack, int quantity) {
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        stack = stack.copy();
        stack.setCount(quantity);
        return stack;
    }

    public static boolean areStacksSameType(@Nonnull ItemStack stack1, @Nonnull ItemStack stack2) {
        return !stack1.isEmpty() && !stack2.isEmpty() && stack1.getItem() == stack2.getItem() && stack2.getDamageValue() == stack1.getDamageValue() && ItemStack.isSameItemSameTags((ItemStack)stack2, (ItemStack)stack1);
    }

    public static boolean canCombineStacks(ItemStack stack1, ItemStack stack2) {
        if (!stack1.isEmpty() && stack2.isEmpty()) {
            return true;
        }
        return ItemUtils.areStacksSameType(stack1, stack2) && stack1.getCount() + stack2.getCount() <= stack1.getMaxStackSize();
    }

    public static ItemStack combineStacks(ItemStack stack1, ItemStack stack2) {
        return stack1.isEmpty() ? stack2.copy() : ItemUtils.grow(stack1, stack2.getCount());
    }

    public static boolean compareTags(ItemStack stack1, ItemStack stack2) {
        String key;
        if (!stack1.hasTag()) {
            return true;
        }
        if (stack1.hasTag() && !stack2.hasTag()) {
            return false;
        }
        Set stack1Keys = NBTUtils.getTagCompound(stack1).getAllKeys();
        Set stack2Keys = NBTUtils.getTagCompound(stack2).getAllKeys();
        Iterator iterator = stack1Keys.iterator();
        do {
            if (!iterator.hasNext()) {
                return true;
            }
            key = (String)iterator.next();
            if (stack2Keys.contains(key)) continue;
            return false;
        } while (NbtUtils.compareNbt((Tag)NBTUtils.getTag(stack1, key), (Tag)NBTUtils.getTag(stack2, key), (boolean)true));
        return false;
    }

    public static void dropItem(ItemStack stack, Level level, Vector3 dropLocation) {
        ItemEntity item = new ItemEntity(level, dropLocation.x, dropLocation.y, dropLocation.z, stack);
        item.setDeltaMovement(level.random.nextGaussian() * 0.05, level.random.nextGaussian() * 0.05 + (double)0.2f, level.random.nextGaussian() * 0.05);
        level.addFreshEntity((Entity)item);
    }

    public static void dropItem(Level world, BlockPos pos, @Nonnull ItemStack stack, double velocity) {
        double xVelocity = (double)world.random.nextFloat() * velocity + (1.0 - velocity) * 0.5;
        double yVelocity = (double)world.random.nextFloat() * velocity + (1.0 - velocity) * 0.5;
        double zVelocity = (double)world.random.nextFloat() * velocity + (1.0 - velocity) * 0.5;
        ItemEntity entityItem = new ItemEntity(world, (double)pos.getX() + xVelocity, (double)pos.getY() + yVelocity, (double)pos.getZ() + zVelocity, stack);
        entityItem.setPickUpDelay(10);
        world.addFreshEntity((Entity)entityItem);
    }

    public static void dropItem(Level world, BlockPos pos, @Nonnull ItemStack stack) {
        ItemUtils.dropItem(world, pos, stack, 0.7);
    }

    public static void dropInventory(Level world, BlockPos pos, Container inventory) {
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            ItemStack stack = inventory.getItem(i);
            if (stack.isEmpty() || stack.getCount() <= 0) continue;
            ItemUtils.dropItem(world, pos, stack);
        }
    }

    public static void removeEnchant(ItemStack stack, Enchantment pEnchantment) {
        if (!stack.getOrCreateTag().contains("Enchantments", 9)) {
            stack.getOrCreateTag().put("Enchantments", (Tag)new ListTag());
        }
        ListTag listtag = stack.getOrCreateTag().getList("Enchantments", 10);
        listtag.stream().filter(tag -> {
            CompoundTag compoundtag = (CompoundTag)tag;
            return Enchantment.byId((int)compoundtag.getShort("id")) == pEnchantment;
        }).forEach(arg_0 -> listtag.remove(arg_0));
    }

    public static void clearEnchants(ItemStack stack) {
        if (stack.getOrCreateTag().contains("Enchantments", 9)) {
            stack.getOrCreateTag().remove("Enchantments");
        }
    }
}

