/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.api.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WorldUtils {
    public static int getEnvironmentBrightness(Player player) {
        int result = 0;
        if (player != null) {
            boolean isUnderground;
            Level world = player.level();
            BlockPos pos = player.blockPosition();
            int skyLight = world.getBrightness(LightLayer.SKY, pos);
            int blockLight = world.getBrightness(LightLayer.BLOCK, pos);
            boolean isDay = world.isDay();
            boolean isRaining = world.isRaining();
            boolean isThundering = world.isThundering();
            boolean bl = isUnderground = !world.canSeeSky(pos);
            if (world.dimension() == Level.OVERWORLD) {
                if (!isUnderground) {
                    if (isDay) {
                        result = isThundering ? 6 : (isRaining ? 9 : 15);
                    } else {
                        int moonPhase = world.getMoonPhase();
                        result = WorldUtils.getMoonBrightness(moonPhase, isThundering, isRaining);
                    }
                } else {
                    result = Math.max(Math.min(blockLight, 12), 0);
                }
            } else {
                result = world.dimension() == Level.NETHER ? Math.min(7 + blockLight / 2, 10) : (world.dimension() == Level.END ? Math.min(6 + blockLight / 2, 10) : Math.max(skyLight, blockLight));
            }
        }
        return result;
    }

    private static int getMoonBrightness(int moonPhase, boolean isThundering, boolean isRaining) {
        if (moonPhase == 0) {
            return isThundering ? 3 : (isRaining ? 5 : 9);
        }
        if (moonPhase == 4) {
            return isThundering ? 1 : 2;
        }
        int moonLight = 9 - moonPhase;
        return isThundering ? Math.max(moonLight - 3, 1) : (isRaining ? Math.max(moonLight - 2, 1) : moonLight);
    }

    public static List<BlockEntity> getBlockEntitiesWithinAABB(Level level, AABB bBox) {
        ArrayList<BlockEntity> list = new ArrayList<BlockEntity>();
        for (BlockPos pos : WorldUtils.getPositionsFromBox(bBox)) {
            BlockEntity blockEntity = WorldUtils.getBlockEntity((BlockGetter)level, pos);
            if (blockEntity == null) continue;
            list.add(blockEntity);
        }
        return list;
    }

    public static Iterable<BlockPos> getPositionsFromBox(AABB box) {
        return WorldUtils.getPositionsFromBox(BlockPos.containing((double)box.minX, (double)box.minY, (double)box.minZ), BlockPos.containing((double)box.maxX, (double)box.maxY, (double)box.maxZ));
    }

    public static Iterable<BlockPos> getPositionsFromBox(BlockPos corner1, BlockPos corner2) {
        return () -> BlockPos.betweenClosedStream((BlockPos)corner1, (BlockPos)corner2).iterator();
    }

    @Nullable
    public static BlockEntity getBlockEntity(@Nullable BlockGetter level, @NotNull BlockPos pos) {
        if (!WorldUtils.isBlockLoaded(level, pos)) {
            return null;
        }
        return level.getBlockEntity(pos);
    }

    public static boolean isBlockLoaded(@Nullable BlockGetter world, @NotNull BlockPos pos) {
        if (world == null) {
            return false;
        }
        if (world instanceof LevelReader) {
            Level level;
            LevelReader reader = (LevelReader)world;
            if (reader instanceof Level && !(level = (Level)reader).isInWorldBounds(pos)) {
                return false;
            }
            return reader.hasChunkAt(pos);
        }
        return true;
    }
}

