/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.api.util.math;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class RayTracer {
    public static Vec3 getCorrectedHeadVec(Player player) {
        return player.position().add(0.0, (double)player.getEyeHeight(), 0.0);
    }

    public static Vec3 getStartVec(Player player) {
        return RayTracer.getCorrectedHeadVec(player);
    }

    public static Vec3 getEndVec(Player player) {
        Vec3 headVec = RayTracer.getCorrectedHeadVec(player);
        Vec3 lookVec = player.getViewVector(2.0f);
        double reach = 5.0;
        return headVec.add(lookVec.x * reach, lookVec.y * reach, lookVec.z * reach);
    }

    public static Vec3 getEndVec(Player player, double reach) {
        Vec3 headVec = RayTracer.getCorrectedHeadVec(player);
        Vec3 lookVec = player.getViewVector(2.0f);
        return headVec.add(lookVec.x * reach, lookVec.y * reach, lookVec.z * reach);
    }

    public static BlockHitResult retrace(Player player, double reach) {
        Vec3 startVec = RayTracer.getStartVec(player);
        Vec3 endVec = RayTracer.getEndVec(player, reach);
        ClipContext rayTraceContext = new ClipContext(startVec, endVec, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player);
        return player.level().clip(rayTraceContext);
    }
}

