/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.client.model.loader;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import committee.nova.mods.avaritia.api.client.model.bakedmodels.WrappedItemModel;
import committee.nova.mods.avaritia.api.client.util.TransformUtils;
import committee.nova.mods.avaritia.client.AvaritiaForgeClient;
import committee.nova.mods.avaritia.client.shader.AvaritiaRenderTypes;
import committee.nova.mods.avaritia.client.shader.AvaritiaShaders;
import committee.nova.mods.avaritia.common.item.resources.MatterClusterItem;
import committee.nova.mods.avaritia.init.registry.ModItems;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemModelShaper;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class CosmicBakeModel
extends WrappedItemModel {
    private final List<ResourceLocation> maskSprite;

    public CosmicBakeModel(BakedModel wrapped, List<ResourceLocation> maskSprite) {
        super(wrapped);
        this.maskSprite = maskSprite;
        this.cosmic = true;
    }

    @Override
    public void renderItem(ItemStack stack, ItemDisplayContext transformType, PoseStack pStack, MultiBufferSource source, int packedLight, int packedOverlay, ItemModelShaper itemModelShaper, TextureManager textureManager) {
        this.parentState = stack.is((Item)ModItems.infinity_sword.get()) ? TransformUtils.DEFAULT_TOOL : (stack.is((Item)ModItems.infinity_bow.get()) || stack.is((Item)ModItems.infinity_crossbow.get()) ? TransformUtils.DEFAULT_BOW : TransformUtils.DEFAULT_ITEM);
        this.renderWrapped(stack, pStack, source, packedLight, packedOverlay, true);
        if (source instanceof MultiBufferSource.BufferSource) {
            MultiBufferSource.BufferSource bs = (MultiBufferSource.BufferSource)source;
            bs.endBatch();
        }
        Minecraft mc = Minecraft.getInstance();
        float yaw = 0.0f;
        float pitch = 0.0f;
        float scale = 1.0f;
        if (AvaritiaForgeClient.inventoryRender || transformType == ItemDisplayContext.GUI) {
            scale = 100.0f;
        } else {
            yaw = (float)((double)(mc.player.getYRot() * 2.0f) * Math.PI / 360.0);
            pitch = -((float)((double)(mc.player.getXRot() * 2.0f) * Math.PI / 360.0));
        }
        AvaritiaShaders.cosmicTime.set((float)(mc.level.getGameTime() % Integer.MAX_VALUE));
        AvaritiaShaders.cosmicYaw.set(yaw);
        AvaritiaShaders.cosmicPitch.set(pitch);
        AvaritiaShaders.cosmicExternalScale.set(scale);
        if (stack.getItem() == ModItems.matter_cluster.get()) {
            AvaritiaShaders.cosmicOpacity.set((float)MatterClusterItem.getClusterSize(stack) / (float)MatterClusterItem.CAPACITY);
        } else {
            AvaritiaShaders.cosmicOpacity.set(1.0f);
        }
        if (AvaritiaShaders.cosmicUVs != null) {
            AvaritiaShaders.cosmicUVs.set(AvaritiaShaders.COSMIC_UVS);
        }
        VertexConsumer cons = source.getBuffer(AvaritiaRenderTypes.COSMIC);
        ArrayList<TextureAtlasSprite> atlasSprite = new ArrayList<TextureAtlasSprite>();
        for (ResourceLocation res : this.maskSprite) {
            atlasSprite.add((TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(res));
        }
        mc.getItemRenderer().renderQuadList(pStack, cons, CosmicBakeModel.bakeItem(atlasSprite), stack, packedLight, packedOverlay);
    }
}

