/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.client.model.loader;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import committee.nova.mods.avaritia.api.client.model.bakedmodels.WrappedItemModel;
import committee.nova.mods.avaritia.api.client.render.buffer.AlphaOverrideVertexConsumer;
import committee.nova.mods.avaritia.api.client.util.TransformUtils;
import committee.nova.mods.avaritia.api.iface.IBowTransform;
import committee.nova.mods.avaritia.api.iface.IToolTransform;
import committee.nova.mods.avaritia.client.AvaritiaForgeClient;
import committee.nova.mods.avaritia.client.model.loader.base.HaloSetting;
import committee.nova.mods.avaritia.client.model.loader.base.HaloUtils;
import committee.nova.mods.avaritia.client.shader.AvaritiaRenderTypes;
import committee.nova.mods.avaritia.client.shader.AvaritiaShaders;
import committee.nova.mods.avaritia.common.item.resources.MatterClusterItem;
import committee.nova.mods.avaritia.init.registry.ModItems;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.ItemModelShaper;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class HaloEternalBakedModel
extends WrappedItemModel {
    private final Random random = new Random();
    private final BakedQuad haloQuad;
    private final HaloSetting setting;
    private final List<ResourceLocation> maskSprite;

    public HaloEternalBakedModel(BakedModel wrapped, TextureAtlasSprite sprite, HaloSetting setting, List<ResourceLocation> maskSprite) {
        super(wrapped);
        this.haloQuad = HaloUtils.generateHaloQuad(sprite, setting.size(), setting.color());
        this.setting = setting;
        this.maskSprite = maskSprite;
        this.cosmic = true;
    }

    @Override
    public void renderItem(ItemStack stack, ItemDisplayContext transformType, PoseStack pStack, MultiBufferSource source, int packedLight, int packedOverlay, ItemModelShaper itemModelShaper, TextureManager textureManager) {
        this.parentState = stack.getItem() instanceof IToolTransform ? TransformUtils.DEFAULT_TOOL : (stack.getItem() instanceof IBowTransform ? TransformUtils.DEFAULT_BOW : TransformUtils.DEFAULT_ITEM);
        if (transformType == ItemDisplayContext.GUI) {
            Minecraft.getInstance().getItemRenderer().renderQuadList(pStack, source.getBuffer(ItemBlockRenderTypes.getRenderType((ItemStack)stack, (boolean)true)), List.of(this.haloQuad), stack, packedLight, packedOverlay);
            if (this.setting.pulse()) {
                pStack.pushPose();
                double scale = this.random.nextDouble() * 0.15 + 0.95;
                double trans = (1.0 - scale) / 2.0;
                pStack.translate(trans, trans, 0.0);
                pStack.scale((float)scale, (float)scale, 1.0001f);
                this.renderWrapped(stack, pStack, source, packedLight, packedOverlay, true, e -> new AlphaOverrideVertexConsumer((VertexConsumer)e, 0.6f));
                pStack.popPose();
            }
        }
        this.renderWrapped(stack, pStack, source, packedLight, packedOverlay, true);
        if (source instanceof MultiBufferSource.BufferSource) {
            MultiBufferSource.BufferSource bs = (MultiBufferSource.BufferSource)source;
            bs.endBatch();
        }
        Minecraft mc = Minecraft.getInstance();
        float yaw = 0.0f;
        float pitch = 0.0f;
        float scale = 1.0f;
        if (AvaritiaForgeClient.inventoryRender || transformType == ItemDisplayContext.GUI) {
            scale = 100.0f;
        } else {
            yaw = (float)((double)(mc.player.getYRot() * 2.0f) * Math.PI / 360.0);
            pitch = -((float)((double)(mc.player.getXRot() * 2.0f) * Math.PI / 360.0));
        }
        AvaritiaShaders.eternalTime.set((float)(mc.level.getGameTime() % Integer.MAX_VALUE));
        AvaritiaShaders.eternalYaw.set(yaw);
        AvaritiaShaders.eternalPitch.set(pitch);
        AvaritiaShaders.eternalExternalScale.set(scale);
        if (stack.getItem() == ModItems.matter_cluster.get()) {
            AvaritiaShaders.eternalOpacity.set((float)MatterClusterItem.getClusterSize(stack) / (float)MatterClusterItem.CAPACITY);
        } else {
            AvaritiaShaders.eternalOpacity.set(1.5f);
        }
        if (AvaritiaShaders.eternalUVs != null) {
            AvaritiaShaders.eternalUVs.set(AvaritiaShaders.ETERNAL_UVS);
        }
        VertexConsumer cons = source.getBuffer(AvaritiaRenderTypes.ETERNAL);
        ArrayList<TextureAtlasSprite> atlasSprite = new ArrayList<TextureAtlasSprite>();
        for (ResourceLocation res : this.maskSprite) {
            atlasSprite.add((TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(res));
        }
        mc.getItemRenderer().renderQuadList(pStack, cons, HaloEternalBakedModel.bakeItem(atlasSprite), stack, packedLight, packedOverlay);
    }
}

