/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.client.model.loader;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import committee.nova.mods.avaritia.client.model.loader.HaloEternalBakedModel;
import committee.nova.mods.avaritia.client.model.loader.base.BaseGeometry;
import committee.nova.mods.avaritia.client.model.loader.base.BaseModelLoader;
import committee.nova.mods.avaritia.client.model.loader.base.HaloSetting;
import committee.nova.mods.avaritia.client.model.loader.base.HaloUtils;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;

public class HaloEternalModelLoader
extends BaseModelLoader<HaloEternalGeometry> {
    public static final HaloEternalModelLoader INSTANCE = new HaloEternalModelLoader();

    public HaloEternalGeometry read(JsonObject modelContents, JsonDeserializationContext deserializationContext) throws JsonParseException {
        BlockModel baseModel = (BlockModel)deserializationContext.deserialize((JsonElement)this.clear(modelContents, "halo", "eternal"), BlockModel.class);
        HaloSetting setting = this.getHalo(modelContents);
        List<ResourceLocation> eternalMaskTexture = this.getMasks(modelContents, "eternal");
        return new HaloEternalGeometry(baseModel, setting, eternalMaskTexture);
    }

    public static class HaloEternalGeometry
    extends BaseGeometry<HaloEternalGeometry> {
        private final BlockModel baseModel;
        private final HaloSetting setting;
        private final List<ResourceLocation> maskTextures;

        public HaloEternalGeometry(BlockModel baseModel, HaloSetting setting, List<ResourceLocation> maskTextures) {
            super(baseModel);
            this.baseModel = baseModel;
            this.setting = setting;
            this.maskTextures = maskTextures;
        }

        public BakedModel bake(IGeometryBakingContext context, ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelState, ItemOverrides overrides, ResourceLocation modelLocation) {
            BakedModel bakedBaseModel = this.baseModel.bake(baker, this.baseModel, spriteGetter, modelState, modelLocation, true);
            Material particleLocation = this.baseModel.getMaterial(this.setting.texture());
            TextureAtlasSprite particle = spriteGetter.apply(particleLocation);
            return new HaloEternalBakedModel(HaloUtils.tintLayers(bakedBaseModel, (IntList)this.setting.layerColors()), particle, this.setting, this.maskTextures);
        }
    }
}

