/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import committee.nova.mods.avaritia.Res;
import committee.nova.mods.avaritia.client.shader.AvaritiaRenderTypes;
import committee.nova.mods.avaritia.common.entity.BladeSlashEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class BladeSlashRender
extends EntityRenderer<BladeSlashEntity> {
    public BladeSlashRender(EntityRendererProvider.Context ctx) {
        super(ctx);
    }

    public void render(BladeSlashEntity entity, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource buffer, int packedLight) {
        matrixStackIn.pushPose();
        matrixStackIn.mulPose(Axis.YP.rotationDegrees(Mth.lerp((float)partialTicks, (float)entity.yRotO, (float)entity.getYRot()) - 90.0f));
        matrixStackIn.mulPose(Axis.ZP.rotationDegrees(Mth.lerp((float)partialTicks, (float)entity.xRotO, (float)entity.getXRot()) + 10.0f));
        matrixStackIn.mulPose(Axis.XP.rotationDegrees(entity.zRot));
        matrixStackIn.scale(0.6f, 0.6f, 1.8f);
        PoseStack.Pose matrixStackEntry = matrixStackIn.last();
        Matrix4f pose = matrixStackEntry.pose();
        Matrix3f normal = matrixStackEntry.normal();
        VertexConsumer builder = buffer.getBuffer(AvaritiaRenderTypes.BLADE_SLASH);
        packedLight = 0xF000F0;
        this.vertex(pose, normal, builder, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0, 1, 0, packedLight);
        this.vertex(pose, normal, builder, 1.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0, 1, 0, packedLight);
        this.vertex(pose, normal, builder, -1.0f, 0.0f, -1.0f, 0.0f, 1.0f, 0, 1, 0, packedLight);
        this.vertex(pose, normal, builder, -1.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0, 1, 0, packedLight);
        matrixStackIn.popPose();
        super.render((Entity)entity, entityYaw, partialTicks, matrixStackIn, buffer, packedLight);
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull BladeSlashEntity entity) {
        return Res.BLADE_SLASH;
    }

    public void vertex(Matrix4f pose, Matrix3f normal, VertexConsumer builder, float x, float y, float z, float u, float v, int nx, int nz, int ny, int packedLight) {
        builder.vertex(pose, x, y, z).color(255, 255, 255, 200).uv(u, v).overlayCoords(OverlayTexture.NO_OVERLAY).uv2(packedLight).normal(normal, (float)nx, (float)ny, (float)nz).endVertex();
    }
}

