/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import committee.nova.mods.avaritia.Res;
import committee.nova.mods.avaritia.common.entity.StormProEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class StormProRender
extends EntityRenderer<StormProEntity> {
    private static final RenderType RENDER_TYPE = RenderType.entityCutoutNoCull((ResourceLocation)Res.STORM_PRO_TEX);

    public StormProRender(EntityRendererProvider.Context pContext) {
        super(pContext);
    }

    private static void vertex(VertexConsumer pConsumer, Matrix4f pPose, Matrix3f pNormal, int pLightmapUV, float pX, int pY, int pU, int pV) {
        pConsumer.vertex(pPose, pX - 0.5f, (float)pY - 0.25f, 0.0f).color(255, 255, 255, 255).uv((float)pU, (float)pV).overlayCoords(OverlayTexture.NO_OVERLAY).uv2(pLightmapUV).normal(pNormal, 0.0f, 1.0f, 0.0f).endVertex();
    }

    protected int getBlockLightLevel(@NotNull StormProEntity pEntity, @NotNull BlockPos pPos) {
        return 15;
    }

    public void render(StormProEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.pushPose();
        poseStack.scale(1.0f, 1.0f, 1.0f);
        poseStack.mulPose(this.entityRenderDispatcher.cameraOrientation());
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
        PoseStack.Pose posestack$pose = poseStack.last();
        Matrix4f matrix4f = posestack$pose.pose();
        Matrix3f matrix3f = posestack$pose.normal();
        VertexConsumer vertexconsumer = buffer.getBuffer(RENDER_TYPE);
        StormProRender.vertex(vertexconsumer, matrix4f, matrix3f, packedLight, 0.0f, 0, 0, 1);
        StormProRender.vertex(vertexconsumer, matrix4f, matrix3f, packedLight, 1.0f, 0, 1, 1);
        StormProRender.vertex(vertexconsumer, matrix4f, matrix3f, packedLight, 1.0f, 1, 1, 0);
        StormProRender.vertex(vertexconsumer, matrix4f, matrix3f, packedLight, 0.0f, 1, 0, 0);
        poseStack.popPose();
        super.render((Entity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    public ResourceLocation getTextureLocation(StormProEntity rainProEntity) {
        return Res.STORM_PRO_TEX;
    }
}

