/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.client.render.tile;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import committee.nova.mods.avaritia.common.entity.AcceleratorDisplayEntity;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AcceleratorDisplayRender
extends EntityRenderer<AcceleratorDisplayEntity> {
    private final Font font;
    private static final float SCALE = 0.02f;

    public AcceleratorDisplayRender(EntityRendererProvider.Context context) {
        super(context);
        this.font = context.getFont();
    }

    public void render(AcceleratorDisplayEntity entity, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        String text = "x" + entity.getSpeedMultiplier();
        float textWidth = (float)this.font.width(text) * 0.02f / 2.0f;
        Direction face = entity.getFace();
        this.drawTextOnFace(poseStack, buffer, text, face, textWidth, packedLight);
    }

    private void drawTextOnFace(PoseStack poseStack, MultiBufferSource buffer, String text, Direction face, float textWidth, int light) {
        poseStack.pushPose();
        switch (face) {
            case UP: {
                poseStack.translate(0.0, 0.51, 0.0);
                poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
                break;
            }
            case DOWN: {
                poseStack.translate(0.0, -0.51, 0.0);
                poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
                break;
            }
            case NORTH: {
                poseStack.translate(0.0, 0.0, -0.51);
                poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
                break;
            }
            case SOUTH: {
                poseStack.translate(0.0, 0.0, 0.51);
                break;
            }
            case WEST: {
                poseStack.translate(-0.51, 0.0, 0.0);
                poseStack.mulPose(Axis.YP.rotationDegrees(-90.0f));
                break;
            }
            case EAST: {
                poseStack.translate(0.51, 0.0, 0.0);
                poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
            }
        }
        poseStack.scale(0.02f, -0.02f, 0.02f);
        float x = (float)(-this.font.width(text)) / 2.0f;
        Objects.requireNonNull(this.font);
        float y = (float)(-9) / 2.0f;
        this.font.drawInBatch(text, x, y, 0xFFFFFF, false, poseStack.last().pose(), buffer, Font.DisplayMode.NORMAL, 0, light);
        poseStack.popPose();
    }

    public ResourceLocation getTextureLocation(AcceleratorDisplayEntity entity) {
        return null;
    }
}

