/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.client.screen;

import committee.nova.mods.avaritia.Res;
import committee.nova.mods.avaritia.api.client.screen.BaseContainerScreen;
import committee.nova.mods.avaritia.client.screen.ConfigButton;
import committee.nova.mods.avaritia.common.menu.NeutronCollectorMenu;
import committee.nova.mods.avaritia.common.tile.NeutronCollectorTile;
import committee.nova.mods.avaritia.init.registry.ModTooltips;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import org.jetbrains.annotations.NotNull;

public class NeutronCollectorScreen
extends BaseContainerScreen<NeutronCollectorMenu> {
    private Button configButton;

    public NeutronCollectorScreen(NeutronCollectorMenu container, Inventory inventory, Component title) {
        super(container, inventory, title, Res.NEUTRON_COLLECTOR_TEX);
    }

    @Override
    protected void init() {
        super.init();
        int x = this.getGuiLeft();
        int y = this.getGuiTop();
        this.configButton = new ConfigButton(this, x - 20, y);
        this.addRenderableWidget((GuiEventListener)this.configButton);
    }

    @Override
    protected void renderFg(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        int x = this.getGuiLeft();
        int y = this.getGuiTop();
        if (pMouseX > x + 99 && pMouseX < x + 104 && pMouseY > y + 30 && pMouseY < y + 50) {
            ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
            if (this.getProgress() > 0) {
                double i = (double)this.getProgress() / (double)this.getTimeRequired();
                MutableComponent text = ModTooltips.PROGRESS.args(NeutronCollectorScreen.fraction(i)).build();
                tooltip.add(text);
            }
            pGuiGraphics.renderComponentTooltip(this.font, tooltip, pMouseX, pMouseY);
        }
    }

    protected void renderLabels(@NotNull GuiGraphics stack, int mouseX, int mouseY) {
        String title = this.getTitle().getString();
        stack.drawString(this.font, title, 88 - this.font.width(title) / 2, 6, 0x404040, false);
        stack.drawString(this.font, this.playerInventoryTitle, 8, 72, 0x404040, false);
    }

    @Override
    protected void renderBgs(GuiGraphics pGuiGraphics, float pPartialTick, int pX, int pY) {
        int i = this.getGuiLeft();
        int j = this.getGuiTop();
        if (this.getProgress() > 0) {
            int i2 = this.getProgressBarScaled(18);
            pGuiGraphics.blit(Res.NEUTRON_COLLECTOR_TEX, i + 99, j + 49 - i2, 176, 18 - i2, 4, i2);
        }
    }

    public int getProgress() {
        if (((NeutronCollectorMenu)this.menu).getTileEntity() == null) {
            return 0;
        }
        return ((NeutronCollectorMenu)this.menu).getProgress();
    }

    public int getTimeRequired() {
        if (((NeutronCollectorMenu)this.menu).getTileEntity() == null) {
            return 0;
        }
        return ((NeutronCollectorTile)((NeutronCollectorMenu)this.menu).getTileEntity()).getProductionTicks();
    }

    public int getProgressBarScaled(int pixels) {
        int i = Mth.clamp((int)this.getProgress(), (int)0, (int)this.getTimeRequired());
        int j = this.getTimeRequired();
        return (int)(j != 0 && i != 0 ? (long)i * (long)pixels / (long)j : 0L);
    }
}

