/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.client.screen;

import committee.nova.mods.avaritia.Res;
import committee.nova.mods.avaritia.api.client.screen.BaseContainerScreen;
import committee.nova.mods.avaritia.client.screen.ConfigButton;
import committee.nova.mods.avaritia.common.menu.CompressorMenu;
import committee.nova.mods.avaritia.common.tile.NeutronCompressorTile;
import committee.nova.mods.avaritia.init.handler.NetworkHandler;
import committee.nova.mods.avaritia.init.registry.ModTooltips;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class NeutronCompressorScreen
extends BaseContainerScreen<CompressorMenu> {
    private Button lockButton;
    private Button ejectButton;
    private Button configButton;

    public NeutronCompressorScreen(CompressorMenu container, Inventory inventory, Component title) {
        super(container, inventory, title, Res.NEUTRON_COMPRESSOR_TEX);
    }

    @Override
    protected void init() {
        super.init();
        int x = this.getGuiLeft();
        int y = this.getGuiTop();
        this.lockButton = new LockButton(x + 40, y + 55);
        this.ejectButton = new EjectButton(x + 40, y + 20);
        this.configButton = new ConfigButton(this, x - 20, y);
        this.addRenderableWidget((GuiEventListener)this.lockButton);
        this.addRenderableWidget((GuiEventListener)this.ejectButton);
        this.addRenderableWidget((GuiEventListener)this.configButton);
        this.lockButton.setMessage((Component)Component.literal((String)(this.isRecipeLocked() ? "\ud83d\udd12" : "\ud83d\udd13")));
    }

    private void lockRecipe() {
        if (this.minecraft != null && this.minecraft.player != null) {
            NetworkHandler.sendCompressorLockPacket(((CompressorMenu)this.menu).getBlockPos(), !this.isRecipeLocked());
            this.lockButton.setMessage((Component)Component.literal((String)(!this.isRecipeLocked() ? "\ud83d\udd12" : "\ud83d\udd13")));
        }
    }

    private void ejectMaterials() {
        if (this.minecraft != null && this.minecraft.player != null) {
            NetworkHandler.sendCompressorEjectPacket(((CompressorMenu)this.menu).getBlockPos());
        }
    }

    @Override
    protected void renderFg(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        int x = this.getGuiLeft();
        int y = this.getGuiTop();
        if (pMouseX > x + 63 && pMouseX < x + 79 && pMouseY > y + 35 && pMouseY < y + 51) {
            ArrayList<Object> tooltip = new ArrayList<Object>();
            if (this.getMaterialCount() < 1) {
                tooltip.add(ModTooltips.EMPTY.color(ChatFormatting.WHITE).build());
            } else {
                if (this.hasMaterialStack()) {
                    tooltip.add(this.getMaterialStackDisplayName());
                }
                MutableComponent text = Component.literal((String)(NeutronCompressorScreen.number(this.getMaterialCount()) + " / " + NeutronCompressorScreen.number(this.getMaterialsRequired())));
                tooltip.add(text);
            }
            pGuiGraphics.renderComponentTooltip(this.font, tooltip, pMouseX, pMouseY);
        }
    }

    protected void renderLabels(@NotNull GuiGraphics stack, int mouseX, int mouseY) {
        String title = this.getTitle().getString();
        stack.drawString(this.font, title, this.imageWidth / 2 - this.font.width(title) / 2, 6, 0x404040, false);
        stack.drawString(this.font, this.playerInventoryTitle, 8, this.imageHeight - 94, 0x404040, false);
    }

    @Override
    protected void renderBgs(GuiGraphics pGuiGraphics, float pPartialTick, int pX, int pY) {
        int x = this.getGuiLeft();
        int y = this.getGuiTop();
        if (this.hasRecipe()) {
            int i2;
            if (this.getMaterialCount() > 0 && this.getMaterialsRequired() > 0) {
                i2 = this.getMaterialBarScaled(16);
                pGuiGraphics.blit(Res.NEUTRON_COMPRESSOR_TEX, x + 63, y + 35, 176, 18, i2 + 1, 16);
            }
            if (this.getProgress() > 0 && this.getMaterialCount() >= this.getMaterialsRequired()) {
                i2 = this.getProgressBarScaled(22);
                pGuiGraphics.blit(Res.NEUTRON_COMPRESSOR_TEX, x + 89, y + 35, 176, 0, i2 + 1, 16);
            }
        }
    }

    private Component getMaterialStackDisplayName() {
        CompressorMenu container;
        BlockEntity tile;
        ClientLevel level = this.getMinecraft().level;
        if (level != null && (tile = level.getBlockEntity((container = (CompressorMenu)this.getMenu()).getBlockPos())) instanceof NeutronCompressorTile) {
            NeutronCompressorTile compressor = (NeutronCompressorTile)tile;
            ItemStack materialStack = compressor.getMaterialStack();
            return materialStack.getHoverName();
        }
        return Component.literal((String)"");
    }

    public boolean hasRecipe() {
        if (((CompressorMenu)this.menu).getTileEntity() == null) {
            return false;
        }
        return ((CompressorMenu)this.menu).getTileEntity().hasRecipe();
    }

    public boolean hasMaterialStack() {
        if (((CompressorMenu)this.menu).getTileEntity() == null) {
            return false;
        }
        return ((CompressorMenu)this.menu).getTileEntity().hasMaterialStack();
    }

    public int getProgress() {
        if (((CompressorMenu)this.menu).getTileEntity() == null) {
            return 0;
        }
        return ((CompressorMenu)this.menu).getProgress();
    }

    public int getMaterialCount() {
        if (((CompressorMenu)this.menu).getTileEntity() == null) {
            return 0;
        }
        return ((CompressorMenu)this.menu).getTileEntity().getMaterialCount();
    }

    public int getMaterialsRequired() {
        if (((CompressorMenu)this.menu).getTileEntity() == null) {
            return 0;
        }
        return ((CompressorMenu)this.menu).getTileEntity().getMaterialsRequired();
    }

    public int getTimeRequired() {
        if (((CompressorMenu)this.menu).getTileEntity() == null) {
            return 0;
        }
        return ((CompressorMenu)this.menu).getTileEntity().getTimeRequired();
    }

    public int getMaterialBarScaled(int pixels) {
        int i = Mth.clamp((int)this.getMaterialCount(), (int)0, (int)this.getMaterialsRequired());
        int j = this.getMaterialsRequired();
        return j != 0 && i != 0 ? i * pixels / j : 0;
    }

    public int getProgressBarScaled(int pixels) {
        int i = Mth.clamp((int)this.getProgress(), (int)0, (int)this.getTimeRequired());
        int j = this.getTimeRequired();
        return j != 0 && i != 0 ? i * pixels / j : 0;
    }

    public boolean isRecipeLocked() {
        if (((CompressorMenu)this.menu).getTileEntity() == null) {
            return false;
        }
        return ((CompressorMenu)this.menu).getTileEntity().isRecipeLocked();
    }

    public boolean canEjectMaterials() {
        if (((CompressorMenu)this.menu).getTileEntity() == null) {
            return false;
        }
        return ((CompressorMenu)this.menu).getTileEntity().getMaterialCount() > 0;
    }

    private class LockButton
    extends ImageButton {
        private final List<FormattedCharSequence> tips;

        public LockButton(int pX, int pY) {
            super(pX, pY, 14, 13, 177, 47, Res.NEUTRON_COMPRESSOR_TEX, pButton -> NeutronCompressorScreen.this.lockRecipe());
            this.tips = new ArrayList<FormattedCharSequence>();
            if (NeutronCompressorScreen.this.isRecipeLocked()) {
                this.tips.add(Component.literal((String)"\u5df2\u9501\u5b9a\u914d\u65b9").withStyle(ChatFormatting.GREEN).getVisualOrderText());
                this.tips.add(Component.literal((String)"\u70b9\u51fb\u89e3\u9501\u914d\u65b9").withStyle(ChatFormatting.GRAY).getVisualOrderText());
            } else {
                this.tips.add(Component.literal((String)"\u672a\u9501\u5b9a\u914d\u65b9").withStyle(ChatFormatting.YELLOW).getVisualOrderText());
                this.tips.add(Component.literal((String)"\u6709\u914d\u65b9\u65f6\u53ef\u70b9\u51fb\u9501\u5b9a").withStyle(ChatFormatting.GRAY).getVisualOrderText());
            }
        }

        @ParametersAreNonnullByDefault
        public void renderWidget(GuiGraphics pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
            if (this.isHovered) {
                if (NeutronCompressorScreen.this.isRecipeLocked()) {
                    pPoseStack.blit(this.resourceLocation, this.getX(), this.getY(), (float)(this.xTexStart + 14 + 1), (float)(this.yTexStart + 13 + 1), this.width, this.height, 256, 256);
                } else {
                    pPoseStack.blit(this.resourceLocation, this.getX(), this.getY(), (float)(this.xTexStart + 14 + 1), (float)this.yTexStart, this.width, this.height, 256, 256);
                }
                NeutronCompressorScreen.this.setTooltipForNextRenderPass(this.tips);
            } else if (NeutronCompressorScreen.this.isRecipeLocked()) {
                pPoseStack.blit(this.resourceLocation, this.getX(), this.getY(), (float)this.xTexStart, (float)(this.yTexStart + 13 + 1), this.width, this.height, 256, 256);
            } else {
                pPoseStack.blit(this.resourceLocation, this.getX(), this.getY(), (float)this.xTexStart, (float)this.yTexStart, this.width, this.height, 256, 256);
            }
        }
    }

    private class EjectButton
    extends ImageButton {
        private final List<FormattedCharSequence> tips;

        public EjectButton(int pX, int pY) {
            super(pX, pY, 14, 11, 177, 35, Res.NEUTRON_COMPRESSOR_TEX, pButton -> NeutronCompressorScreen.this.ejectMaterials());
            this.tips = new ArrayList<FormattedCharSequence>();
            this.tips.add(Component.literal((String)"\u5f39\u51fa\u6750\u6599").withStyle(ChatFormatting.AQUA).getVisualOrderText());
            this.tips.add(Component.literal((String)"\u70b9\u51fb\u5f39\u51fa\u6240\u6709\u6750\u6599\u5230\u7269\u54c1\u680f").withStyle(ChatFormatting.GRAY).getVisualOrderText());
        }

        @ParametersAreNonnullByDefault
        public void renderWidget(GuiGraphics pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
            if (this.isHovered) {
                NeutronCompressorScreen.this.setTooltipForNextRenderPass(this.tips);
                pPoseStack.blit(this.resourceLocation, this.getX(), this.getY(), (float)(this.xTexStart + 14 + 1), (float)this.yTexStart, this.width, this.height, 256, 256);
            } else {
                pPoseStack.blit(this.resourceLocation, this.getX(), this.getY(), (float)this.xTexStart, (float)this.yTexStart, this.width, this.height, 256, 256);
            }
        }
    }
}

