/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.client.screen;

import committee.nova.mods.avaritia.Res;
import committee.nova.mods.avaritia.core.io.SideConfiguration;
import committee.nova.mods.avaritia.init.handler.NetworkHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.NotNull;

public class SideConfigScreen
extends Screen {
    private SideConfiguration sideConfig;
    private final Screen parentScreen;
    private final BlockPos blockPos;
    private int guiLeft;
    private int guiTop;
    private int imageWidth = 156;
    private int imageHeight = 117;
    private SideButton northButton;
    private SideButton southButton;
    private SideButton eastButton;
    private SideButton westButton;
    private SideButton upButton;
    private SideButton downButton;

    public SideConfigScreen(Screen parentScreen, SideConfiguration sideConfig, BlockPos blockPos) {
        super((Component)Component.translatable((String)"screen.avaritia.side_config.title"));
        this.parentScreen = parentScreen;
        this.sideConfig = new SideConfiguration(sideConfig);
        this.blockPos = blockPos;
    }

    protected void init() {
        super.init();
        this.guiLeft = (this.width - this.imageWidth) / 2;
        this.guiTop = (this.height - this.imageHeight) / 2;
        int x = this.getGuiLeft();
        int y = this.getGuiTop();
        this.createSideButtons(x, y);
        this.addRenderableWidget((GuiEventListener)new ImageButton(x + 135, y + 93, 17, 18, 17, 164, 18, Res.SIDE_CONFIG_TEX, button -> this.setAllSides(SideConfiguration.SideMode.OFF)));
        this.addRenderableWidget((GuiEventListener)new ImageButton(x + 4, y + 4, 17, 18, 0, 164, 18, Res.SIDE_CONFIG_TEX, button -> this.onClose()));
    }

    private void createSideButtons(int x, int y) {
        int centerX = x + 67;
        int centerY = y + 50;
        this.upButton = new SideButton(centerX, centerY - 24, Direction.UP, this.sideConfig.getSideMode(Direction.UP));
        this.addRenderableWidget((GuiEventListener)this.upButton);
        this.downButton = new SideButton(centerX, centerY + 24, Direction.DOWN, this.sideConfig.getSideMode(Direction.DOWN));
        this.addRenderableWidget((GuiEventListener)this.downButton);
        this.northButton = new SideButton(centerX, centerY, Direction.NORTH, this.sideConfig.getSideMode(Direction.NORTH));
        this.addRenderableWidget((GuiEventListener)this.northButton);
        this.southButton = new SideButton(centerX - 23, centerY + 24, Direction.SOUTH, this.sideConfig.getSideMode(Direction.SOUTH));
        this.addRenderableWidget((GuiEventListener)this.southButton);
        this.westButton = new SideButton(centerX - 23, centerY, Direction.WEST, this.sideConfig.getSideMode(Direction.WEST));
        this.addRenderableWidget((GuiEventListener)this.westButton);
        this.eastButton = new SideButton(centerX + 23, centerY, Direction.EAST, this.sideConfig.getSideMode(Direction.EAST));
        this.addRenderableWidget((GuiEventListener)this.eastButton);
    }

    private void createQuickConfigButtons(int x, int y) {
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"\u00d7").withStyle(style -> style.withColor(0xFF5555)), button -> this.setAllSides(SideConfiguration.SideMode.OFF)).bounds(x + 5, y + 5, 20, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"\u2190").withStyle(style -> style.withColor(0x55FF55)), button -> this.setAllSides(SideConfiguration.SideMode.PASSIVE_INPUT)).bounds(x + 30, y + 5, 20, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"\u2192").withStyle(style -> style.withColor(0x5555FF)), button -> this.setAllSides(SideConfiguration.SideMode.PASSIVE_OUTPUT)).bounds(x + 55, y + 5, 20, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"\u21d0").withStyle(style -> style.withColor(0xFFFF55)), button -> this.setAllSides(SideConfiguration.SideMode.ACTIVE_INPUT)).bounds(x + 125, y + 5, 20, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"\u21d2").withStyle(style -> style.withColor(0xFF55FF)), button -> this.setAllSides(SideConfiguration.SideMode.ACTIVE_OUTPUT)).bounds(x + 150, y + 5, 20, 20).build());
    }

    private void cycleModeForDirection(Direction direction) {
        this.sideConfig.cycleSideMode(direction);
    }

    private void updateButtonTooltip(SideButton button) {
        button.tooltip.clear();
        String sideName = Component.translatable((String)("direction.avaritia." + button.direction.getName())).getString();
        String modeName = button.mode.getDisplayName().getString();
        button.tooltip.add(Component.literal((String)(sideName + ": " + modeName)).getVisualOrderText());
        button.tooltip.add(Component.translatable((String)"tooltip.avaritia.side.click_to_cycle").getVisualOrderText());
    }

    private void setAllSides(SideConfiguration.SideMode mode) {
        for (Direction direction : Direction.values()) {
            this.sideConfig.setSideMode(direction, mode);
        }
        this.updateAllButtons();
        this.sendConfigUpdate();
    }

    private void updateAllButtons() {
        this.northButton.updateMode(this.sideConfig.getSideMode(Direction.NORTH));
        this.southButton.updateMode(this.sideConfig.getSideMode(Direction.SOUTH));
        this.eastButton.updateMode(this.sideConfig.getSideMode(Direction.EAST));
        this.westButton.updateMode(this.sideConfig.getSideMode(Direction.WEST));
        this.upButton.updateMode(this.sideConfig.getSideMode(Direction.UP));
        this.downButton.updateMode(this.sideConfig.getSideMode(Direction.DOWN));
    }

    private void sendConfigUpdate() {
        NetworkHandler.sendSideConfigUpdate(this.blockPos, this.sideConfig);
    }

    public int getGuiLeft() {
        return this.guiLeft;
    }

    public int getGuiTop() {
        return this.guiTop;
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int x = this.getGuiLeft();
        int y = this.getGuiTop();
        guiGraphics.blit(Res.SIDE_CONFIG_TEX, x, y, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
    }

    public void onClose() {
        this.minecraft.setScreen(this.parentScreen);
    }

    private class SideButton
    extends ImageButton {
        private final Direction direction;
        private SideConfiguration.SideMode mode;
        private final List<FormattedCharSequence> tooltip;

        public SideButton(int x, int y, Direction direction, SideConfiguration.SideMode mode) {
            super(x, y, 22, 23, 0, 118, 23, Res.SIDE_CONFIG_TEX, button -> {
                SideConfigScreen.this.cycleModeForDirection(direction);
                SideConfigScreen.this.updateAllButtons();
                SideConfigScreen.this.sendConfigUpdate();
            });
            this.direction = direction;
            this.mode = mode;
            this.tooltip = new ArrayList<FormattedCharSequence>();
            SideConfigScreen.this.updateButtonTooltip(this);
        }

        private void cycleMode() {
            SideConfigScreen.this.sideConfig.cycleSideMode(this.direction);
            this.mode = SideConfigScreen.this.sideConfig.getSideMode(this.direction);
        }

        private void updateTooltip() {
            SideConfigScreen.this.updateButtonTooltip(this);
        }

        public void updateMode(SideConfiguration.SideMode newMode) {
            this.mode = newMode;
            this.updateTooltip();
        }

        public void renderWidget(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
            int texX = this.mode.ordinal() * 22;
            int texY = 118;
            if (this.isHovered) {
                texY += 23;
            }
            pGuiGraphics.blit(Res.SIDE_CONFIG_TEX, this.getX(), this.getY(), (float)texX, (float)texY, this.width, this.height, 256, 256);
            if (this.isHovered) {
                SideConfigScreen.this.setTooltipForNextRenderPass(this.tooltip);
            }
        }
    }
}

