/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.client.screen;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import committee.nova.mods.avaritia.Const;
import committee.nova.mods.avaritia.Res;
import committee.nova.mods.avaritia.api.client.render.FluidItemRender;
import committee.nova.mods.avaritia.api.client.screen.component.SimpleScrollBar;
import committee.nova.mods.avaritia.common.menu.TesseractMenu;
import committee.nova.mods.avaritia.common.net.channel.C2SChannelFilterPack;
import committee.nova.mods.avaritia.core.channel.ClientChannel;
import committee.nova.mods.avaritia.core.channel.ClientChannelManager;
import committee.nova.mods.avaritia.init.handler.NetworkHandler;
import committee.nova.mods.avaritia.util.StorageUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;

public class TesseractScreen
extends AbstractContainerScreen<TesseractMenu> {
    private int blitOffset;
    private static final ResourceLocation GUI_IMG = Res.BLACK_HOLE_CHANNEL_PANEL;
    private final String ownerName;
    private String[] lastHoveredObject = new String[2];
    private long lastCount = 0L;
    private String lastFormatCountTemp = "";
    private SortButton sortButton;
    private ViewTypeButton viewTypeButton;
    private ItemScrollBar scrollBar;
    private EditBox searchBox;
    private CraftToChannelButton craftToChannelButton;
    private CraftToInventoryButton craftToInventoryButton;
    private CraftAndDropButton craftAndDropButton;

    public TesseractScreen(TesseractMenu menu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)menu, inventory, title);
        this.imageWidth = 218;
        this.imageHeight = 256;
        this.ownerName = ClientChannelManager.getInstance().getUserName(((TesseractMenu)this.getMenu()).owner);
    }

    public void blit(GuiGraphics pPoseStack, int pX, int pY, int pUOffset, int pVOffset, int pUWidth, int pVHeight) {
        pPoseStack.blit(GUI_IMG, pX, pY, this.blitOffset, (float)pUOffset, (float)pVOffset, pUWidth, pVHeight, 256, 256);
    }

    @ParametersAreNonnullByDefault
    protected void renderLabels(GuiGraphics stack, int i, int j) {
    }

    protected void init() {
        super.init();
        this.leftPos = (this.width - this.imageWidth + 4) / 2;
        this.topPos = (this.height - this.imageHeight) / 2;
        this.scrollBar = new ItemScrollBar(this.leftPos + 198, this.topPos + 17, 16, ((TesseractMenu)this.menu).craftingMode ? 118 : 152);
        this.scrollBar.setScrolledOn(((TesseractMenu)this.menu).dummyChannelContainer.getScrollOn());
        this.addRenderableWidget((GuiEventListener)this.scrollBar);
        this.addRenderableWidget((GuiEventListener)new ToggleCraftingButton(this.leftPos + 198, this.topPos + 195));
        this.addRenderableWidget((GuiEventListener)new ToggleLockButton(this.leftPos + 198, this.topPos + 211));
        this.addRenderableWidget((GuiEventListener)new ChannelButton(this.leftPos + 198, this.topPos + 227));
        this.sortButton = new SortButton(this.leftPos + 198, this.topPos + 243);
        this.addRenderableWidget((GuiEventListener)this.sortButton);
        this.viewTypeButton = new ViewTypeButton(this.leftPos + 198, this.topPos + 259);
        this.addRenderableWidget((GuiEventListener)this.viewTypeButton);
        this.searchBox = new EditBox(this.font, this.leftPos + 104, this.topPos + 4, 90, 12, (Component)Component.translatable((String)"gui.avaritia.search"));
        this.searchBox.setMaxLength(64);
        this.searchBox.setBordered(false);
        this.searchBox.setValue(((TesseractMenu)this.menu).filter);
        this.addRenderableWidget((GuiEventListener)this.searchBox);
        this.craftToChannelButton = new CraftToChannelButton(this.leftPos + 179, this.topPos + 146);
        this.craftToInventoryButton = new CraftToInventoryButton(this.leftPos + 179, this.topPos + 159);
        this.craftAndDropButton = new CraftAndDropButton(this.leftPos + 179, this.topPos + 172);
        this.craftToChannelButton.active = ((TesseractMenu)this.menu).craftingMode;
        this.craftToChannelButton.visible = ((TesseractMenu)this.menu).craftingMode;
        this.craftToInventoryButton.active = ((TesseractMenu)this.menu).craftingMode;
        this.craftToInventoryButton.visible = ((TesseractMenu)this.menu).craftingMode;
        this.craftAndDropButton.active = ((TesseractMenu)this.menu).craftingMode;
        this.craftAndDropButton.visible = ((TesseractMenu)this.menu).craftingMode;
        this.addRenderableWidget((GuiEventListener)this.craftToChannelButton);
        this.addRenderableWidget((GuiEventListener)this.craftToInventoryButton);
        this.addRenderableWidget((GuiEventListener)this.craftAndDropButton);
        ((TesseractMenu)this.menu).dummyChannelContainer.refreshContainer(true);
        ((TesseractMenu)this.menu).craftModeSetter = () -> {
            if (!((TesseractMenu)this.menu).craftingMode) {
                this.toggleCraftingMode();
            }
        };
    }

    @ParametersAreNonnullByDefault
    public void render(GuiGraphics poseStack, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(poseStack);
        super.render(poseStack, mouseX, mouseY, partialTicks);
        this.renderFluids(poseStack);
        this.renderDummyCount(poseStack);
        this.renderTooltip(poseStack, mouseX, mouseY);
    }

    @ParametersAreNonnullByDefault
    protected void renderBg(GuiGraphics stack, float partialTick, int mouseX, int mouseY) {
        this.blit(stack, this.leftPos, this.topPos, 0, 0, this.imageWidth, 6);
        if (((TesseractMenu)this.menu).craftingMode) {
            this.blit(stack, this.leftPos, this.topPos, 0, 0, this.imageWidth, 68);
            this.blit(stack, this.leftPos, this.topPos + 68, 0, 17, this.imageWidth, 51);
            this.blit(stack, this.leftPos, this.topPos + 119, 0, 17, this.imageWidth, 17);
            this.blit(stack, this.leftPos, this.topPos + 136, 0, 69, this.imageWidth, 141);
        } else {
            this.blit(stack, this.leftPos, this.topPos, 0, 0, this.imageWidth, 68);
            this.blit(stack, this.leftPos, this.topPos + 68, 0, 17, this.imageWidth, 51);
            this.blit(stack, this.leftPos, this.topPos + 119, 0, 17, this.imageWidth, 51);
            this.blit(stack, this.leftPos, this.topPos + 170, 0, 122, this.imageWidth, 6);
            this.blit(stack, this.leftPos, this.topPos + 176, 0, 122, this.imageWidth, 6);
            this.blit(stack, this.leftPos, this.topPos + 182, 0, 122, this.imageWidth, 6);
            this.blit(stack, this.leftPos, this.topPos + 188, 0, 122, this.imageWidth, 4);
            this.blit(stack, this.leftPos, this.topPos + 192, 0, 125, this.imageWidth, 85);
        }
    }

    private void renderFluids(GuiGraphics guiGraphics) {
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.translate((double)this.leftPos, (double)this.topPos, 300.0);
        ((TesseractMenu)this.menu).dummyChannelContainer.fluidStacks.forEach((integer, fluidStack) -> {
            Slot slot = (Slot)((TesseractMenu)this.menu).slots.get(integer + 51);
            FluidItemRender.renderFluid(fluidStack, poseStack, slot.x, slot.y, 0);
        });
        poseStack.popPose();
    }

    public void renderDummyCount(GuiGraphics guiGraphics) {
        PoseStack poseStack = guiGraphics.pose();
        for (int i = 0; i < ((TesseractMenu)this.menu).dummyChannelContainer.formatCount.size(); ++i) {
            Slot slot = (Slot)((TesseractMenu)this.menu).slots.get(i + 51);
            String count = ((TesseractMenu)this.menu).dummyChannelContainer.formatCount.get(i);
            this.setBlitOffset(100);
            RenderSystem.enableDepthTest();
            float fontSize = 0.5f;
            poseStack.pushPose();
            poseStack.translate((double)(this.leftPos + slot.x), (double)(this.topPos + slot.y), 300.0);
            poseStack.scale(fontSize, fontSize, 1.0f);
            float f = (16.0f - (float)this.font.width(count) * fontSize) / fontSize;
            Objects.requireNonNull(this.font);
            guiGraphics.drawString(this.font, count, f, (16.0f - 9.0f * fontSize) / fontSize, 0xFFFFFF, false);
            poseStack.popPose();
            this.setBlitOffset(0);
        }
    }

    @ParametersAreNonnullByDefault
    protected void renderTooltip(GuiGraphics pPoseStack, int pX, int pY) {
        if (this.hoveredSlot != null) {
            if (this.hoveredSlot.index >= 51) {
                if (((TesseractMenu)this.menu).getCarried().getCount() == 1) {
                    this.renderObjectStorageTooltip(pPoseStack, pX, pY);
                } else {
                    this.renderCounterTooltip(pPoseStack, pX, pY);
                }
            } else if (!this.hoveredSlot.getItem().isEmpty() && ((TesseractMenu)this.menu).getCarried().isEmpty()) {
                pPoseStack.renderTooltip(this.font, this.hoveredSlot.getItem(), pX, pY);
            }
        } else if (this.isInsideEditBox(pX, pY)) {
            ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
            list.add(Component.translatable((String)"gui.avaritia.search.tip1"));
            list.add(Component.translatable((String)"gui.avaritia.search.tip2"));
            list.add(Component.translatable((String)"gui.avaritia.search.tip3"));
            pPoseStack.renderComponentTooltip(this.font, list, pX, pY);
        }
    }

    private void renderCounterTooltip(GuiGraphics pPoseStack, int pMouseX, int pMouseY) {
        long count;
        if (this.hoveredSlot.index - 51 >= ((TesseractMenu)this.menu).dummyChannelContainer.viewingObject.size()) {
            return;
        }
        Object[] hoveredObject = ((TesseractMenu)this.menu).dummyChannelContainer.viewingObject.get(this.hoveredSlot.index - 51);
        List<MutableComponent> components = Lists.newArrayList();
        if (hoveredObject[0].equals("item")) {
            components = TesseractScreen.getTooltipFromItem((Minecraft)this.minecraft, (ItemStack)this.hoveredSlot.getItem());
            count = ((TesseractMenu)this.menu).channel.getRealItemAmount(hoveredObject[1]);
        } else if (hoveredObject[0].equals("fluid")) {
            components.add(Component.translatable((String)("block." + hoveredObject[1].replace(':', '.'))));
            if (this.minecraft.options.advancedItemTooltips) {
                components.add(Component.literal((String)hoveredObject[1]).withStyle(ChatFormatting.DARK_GRAY));
            }
            count = ((TesseractMenu)this.menu).channel.getRealFluidAmount((String)hoveredObject[1]);
        } else {
            components.add((MutableComponent)this.hoveredSlot.getItem().getHoverName());
            count = ((TesseractMenu)this.menu).channel.getRealEnergyAmount(hoveredObject[1]);
        }
        if (!Arrays.equals(hoveredObject, this.lastHoveredObject)) {
            String formatCount = StorageUtils.DECIMAL_FORMAT.format(count);
            components.add(Component.literal((String)formatCount));
            this.lastHoveredObject = hoveredObject;
            this.lastCount = count;
            this.lastFormatCountTemp = formatCount;
        } else if (count == this.lastCount) {
            components.add(Component.literal((String)this.lastFormatCountTemp));
        } else {
            Object formatCount = StorageUtils.DECIMAL_FORMAT.format(count);
            long count2 = count - this.lastCount;
            String formatCount2 = StorageUtils.DECIMAL_FORMAT.format(count2);
            formatCount = count2 >= 0L ? (String)formatCount + "  |  +\u00a7a" + formatCount2 : (String)formatCount + "  |  \u00a7c" + formatCount2;
            components.add(Component.literal((String)formatCount));
            this.lastCount = count;
            this.lastFormatCountTemp = formatCount;
        }
        pPoseStack.renderTooltip(this.font, components, this.hoveredSlot.getItem().getTooltipImage(), pMouseX, pMouseY);
    }

    private void renderObjectStorageTooltip(GuiGraphics pPoseStack, int pMouseX, int pMouseY) {
        boolean hasCapability;
        ItemStack carried = ((TesseractMenu)this.menu).getCarried();
        boolean bl = hasCapability = carried.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).isPresent() || carried.getCapability(ForgeCapabilities.ENERGY).isPresent() || carried.getCapability(ForgeCapabilities.ITEM_HANDLER).isPresent();
        if (hasCapability) {
            ArrayList components = Lists.newArrayList();
            if (this.hoveredSlot.index - 51 < ((TesseractMenu)this.menu).dummyChannelContainer.viewingObject.size()) {
                String[] hoveredObject = ((TesseractMenu)this.menu).dummyChannelContainer.viewingObject.get(this.hoveredSlot.index - 51);
                if (hoveredObject[0].equals("fluid")) {
                    components.add(Component.translatable((String)"gui.avaritia.capability.tip1", (Object[])new Object[]{Component.translatable((String)("block." + hoveredObject[1].replace(':', '.'))).getString()}));
                } else {
                    components.add(Component.translatable((String)"gui.avaritia.capability.tip1", (Object[])new Object[]{this.hoveredSlot.getItem().getHoverName()}));
                }
            }
            components.add(Component.translatable((String)"gui.avaritia.capability.tip2"));
            components.add(Component.translatable((String)"gui.avaritia.capability.tip3"));
            pPoseStack.renderTooltip(this.font, (List)components, ItemStack.EMPTY.getTooltipImage(), pMouseX, pMouseY);
        } else {
            this.renderCounterTooltip(pPoseStack, pMouseX, pMouseY);
        }
    }

    public void containerTick() {
        super.containerTick();
        if (this.searchBox.isFocused()) {
            this.searchBox.tick();
        }
    }

    public void onClose() {
        NetworkHandler.CHANNEL.sendToServer((Object)new C2SChannelFilterPack(((TesseractMenu)this.menu).containerId, ((TesseractMenu)this.menu).filter));
        ((ClientChannel)((TesseractMenu)this.menu).channel).removeListener();
        super.onClose();
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        boolean lshift = InputConstants.isKeyDown((long)this.getMinecraft().getWindow().getWindow(), (int)340);
        if (pButton == 1) {
            if (this.searchBox.isMouseOver(pMouseX, pMouseY)) {
                ((TesseractMenu)this.menu).filter = "";
                this.searchBox.setValue("");
                ((TesseractMenu)this.menu).dummyChannelContainer.refreshContainer(true);
                this.searchBox.setFocused(true);
                this.searchBox.setEditable(true);
            } else if (this.craftToChannelButton.isMouseOver(pMouseX, pMouseY)) {
                if (lshift) {
                    this.minecraft.gameMode.handleInventoryButtonClick(((TesseractMenu)this.menu).containerId, 6);
                } else {
                    this.minecraft.gameMode.handleInventoryButtonClick(((TesseractMenu)this.menu).containerId, 7);
                }
            } else if (this.craftToInventoryButton.isMouseOver(pMouseX, pMouseY)) {
                if (lshift) {
                    this.minecraft.gameMode.handleInventoryButtonClick(((TesseractMenu)this.menu).containerId, 10);
                } else {
                    this.minecraft.gameMode.handleInventoryButtonClick(((TesseractMenu)this.menu).containerId, 11);
                }
            } else if (this.craftAndDropButton.isMouseOver(pMouseX, pMouseY)) {
                if (lshift) {
                    this.minecraft.gameMode.handleInventoryButtonClick(((TesseractMenu)this.menu).containerId, 14);
                } else {
                    this.minecraft.gameMode.handleInventoryButtonClick(((TesseractMenu)this.menu).containerId, 15);
                }
            }
        } else if (this.craftToChannelButton.isMouseOver(pMouseX, pMouseY)) {
            if (lshift) {
                this.minecraft.gameMode.handleInventoryButtonClick(((TesseractMenu)this.menu).containerId, 9);
            } else {
                this.minecraft.gameMode.handleInventoryButtonClick(((TesseractMenu)this.menu).containerId, 8);
            }
        } else if (this.craftToInventoryButton.isMouseOver(pMouseX, pMouseY)) {
            if (lshift) {
                this.minecraft.gameMode.handleInventoryButtonClick(((TesseractMenu)this.menu).containerId, 13);
            } else {
                this.minecraft.gameMode.handleInventoryButtonClick(((TesseractMenu)this.menu).containerId, 12);
            }
        } else if (this.craftAndDropButton.isMouseOver(pMouseX, pMouseY)) {
            if (lshift) {
                this.minecraft.gameMode.handleInventoryButtonClick(((TesseractMenu)this.menu).containerId, 17);
            } else {
                this.minecraft.gameMode.handleInventoryButtonClick(((TesseractMenu)this.menu).containerId, 16);
            }
        }
        return super.mouseClicked(pMouseX, pMouseY, pButton);
    }

    public boolean mouseDragged(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (this.scrollBar.isScrolling()) {
            this.scrollBar.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY);
        }
        return super.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public boolean mouseReleased(double pMouseX, double pMouseY, int pButton) {
        this.scrollBar.mouseReleased(pMouseX, pMouseY, pButton);
        return super.mouseReleased(pMouseX, pMouseY, pButton);
    }

    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        if (this.searchBox.isFocused() && pKeyCode >= 48 && pKeyCode <= 90) {
            return true;
        }
        if (pKeyCode == 340) {
            ((TesseractMenu)this.menu).LShifting = true;
        }
        return super.keyPressed(pKeyCode, pScanCode, pModifiers);
    }

    public boolean keyReleased(int pKeyCode, int pScanCode, int pModifiers) {
        String s;
        if (this.searchBox.isFocused() && !(s = this.searchBox.getValue().toLowerCase()).equals(((TesseractMenu)this.menu).filter)) {
            ((TesseractMenu)this.menu).filter = s;
            ((TesseractMenu)this.menu).dummyChannelContainer.refreshContainer(true);
        }
        if (pKeyCode == 340) {
            ((TesseractMenu)this.menu).LShifting = false;
            ((TesseractMenu)this.menu).dummyChannelContainer.refreshContainer(true);
        }
        return super.keyReleased(pKeyCode, pScanCode, pModifiers);
    }

    public boolean mouseScrolled(double pMouseX, double pMouseY, double pDelta) {
        if (pMouseX >= (double)(this.leftPos + 5) && pMouseX <= (double)(this.leftPos + 214) && pMouseY >= (double)(this.topPos + 17)) {
            int n = ((TesseractMenu)this.menu).craftingMode ? 119 : 153;
            if (pMouseY <= (double)(this.topPos + 18 + n) && this.scrollBar.canScroll()) {
                if (pDelta <= 0.0) {
                    this.scrollBar.setScrolledOn(((TesseractMenu)this.menu).dummyChannelContainer.onMouseScrolled(false));
                } else {
                    this.scrollBar.setScrolledOn(((TesseractMenu)this.menu).dummyChannelContainer.onMouseScrolled(true));
                }
                return true;
            }
        }
        return super.mouseScrolled(pMouseX, pMouseY, pDelta);
    }

    protected boolean isHovering(int pX, int pY, int pWidth, int pHeight, double pMouseX, double pMouseY) {
        int i = this.leftPos;
        int j = this.topPos;
        return (pMouseX -= (double)i) >= (double)pX && pMouseX < (double)(pX + pWidth) && (pMouseY -= (double)j) >= (double)pY && pMouseY < (double)(pY + pHeight);
    }

    private boolean isInsideEditBox(double pMouseX, double pMouseY) {
        return pMouseX >= (double)(this.leftPos + 104) && pMouseX <= (double)(this.leftPos + 194) && pMouseY >= (double)(this.topPos + 4) && pMouseY <= (double)(this.topPos + 16);
    }

    private void toggleLock() {
        if (((TesseractMenu)this.menu).owner.equals(((TesseractMenu)this.menu).player.getUUID()) || ((TesseractMenu)this.menu).owner.equals(Const.AVARITIA_FAKE_PLAYER.getId())) {
            ((TesseractMenu)this.menu).locked = !((TesseractMenu)this.menu).locked;
            this.searchBox.setFocused(false);
            NetworkHandler.CHANNEL.sendToServer((Object)new C2SChannelFilterPack(((TesseractMenu)this.menu).containerId, ((TesseractMenu)this.menu).filter));
            this.minecraft.gameMode.handleInventoryButtonClick(((TesseractMenu)this.menu).containerId, 0);
        }
    }

    protected void toggleCraftingMode() {
        ((TesseractMenu)this.menu).craftingMode = !((TesseractMenu)this.menu).craftingMode;
        ((TesseractMenu)this.menu).dummyChannelContainer.refreshContainer(true);
        this.searchBox.setFocused(false);
        this.craftToChannelButton.active = ((TesseractMenu)this.menu).craftingMode;
        this.craftToChannelButton.visible = ((TesseractMenu)this.menu).craftingMode;
        this.craftToInventoryButton.active = ((TesseractMenu)this.menu).craftingMode;
        this.craftToInventoryButton.visible = ((TesseractMenu)this.menu).craftingMode;
        this.craftAndDropButton.active = ((TesseractMenu)this.menu).craftingMode;
        this.craftAndDropButton.visible = ((TesseractMenu)this.menu).craftingMode;
        this.minecraft.gameMode.handleInventoryButtonClick(((TesseractMenu)this.menu).containerId, 1);
        this.scrollBar.setHeight(((TesseractMenu)this.menu).craftingMode ? 118 : 152);
        this.scrollBar.setScrollTagSize();
    }

    private void cycleSort() {
        if (InputConstants.isKeyDown((long)this.getMinecraft().getWindow().getWindow(), (int)340)) {
            ((TesseractMenu)this.menu).reverseSort();
            this.minecraft.gameMode.handleInventoryButtonClick(((TesseractMenu)this.menu).containerId, 3);
        } else {
            ((TesseractMenu)this.menu).nextSort();
            this.minecraft.gameMode.handleInventoryButtonClick(((TesseractMenu)this.menu).containerId, 2);
        }
    }

    private void changeViewType() {
        ((TesseractMenu)this.menu).changeViewType();
        this.minecraft.gameMode.handleInventoryButtonClick(((TesseractMenu)this.menu).containerId, 4);
    }

    private String getSortKey(int sortType) {
        return switch (sortType) {
            case 0, 1 -> "gui.avaritia.sort.id";
            case 2, 3 -> "gui.avaritia.sort.nid";
            case 4, 5 -> "gui.avaritia.sort.mirror_id";
            case 6, 7 -> "gui.avaritia.sort.count";
            default -> "";
        };
    }

    private void channelButtonPress() {
        this.minecraft.gameMode.handleInventoryButtonClick(((TesseractMenu)this.menu).containerId, 5);
    }

    @Generated
    public void setBlitOffset(int blitOffset) {
        this.blitOffset = blitOffset;
    }

    @Generated
    public int getBlitOffset() {
        return this.blitOffset;
    }

    private class ItemScrollBar
    extends SimpleScrollBar {
        private int lastObjectListSize;

        public ItemScrollBar(int x, int y, int weight, int height) {
            super(x, y, weight, height);
            this.setScrollTagSize();
            this.lastObjectListSize = ((TesseractMenu)((TesseractScreen)TesseractScreen.this).menu).dummyChannelContainer.sortedObject.size();
        }

        public void setScrollTagSize() {
            double v = (double)this.height * ((((TesseractMenu)((TesseractScreen)TesseractScreen.this).menu).craftingMode ? 7.0 : 9.0) / Math.ceil((double)((TesseractMenu)((TesseractScreen)TesseractScreen.this).menu).dummyChannelContainer.sortedObject.size() / 11.0));
            this.setScrollTagSize(v);
        }

        @Override
        public void draggedTo(double scrolledOn) {
            ((TesseractMenu)((TesseractScreen)TesseractScreen.this).menu).dummyChannelContainer.onScrollTo(scrolledOn);
        }

        @Override
        public void beforeRender() {
            if (((TesseractMenu)((TesseractScreen)TesseractScreen.this).menu).dummyChannelContainer.sortedObject.size() != this.lastObjectListSize) {
                this.setScrollTagSize();
                this.lastObjectListSize = ((TesseractMenu)((TesseractScreen)TesseractScreen.this).menu).dummyChannelContainer.sortedObject.size();
            }
        }
    }

    private class ToggleCraftingButton
    extends ImageButton {
        public ToggleCraftingButton(int pX, int pY) {
            super(pX, pY, 16, 16, 219, 27, GUI_IMG, pButton -> TesseractScreen.this.toggleCraftingMode());
        }

        @ParametersAreNonnullByDefault
        public void renderWidget(GuiGraphics pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
            int uOffset = ((TesseractMenu)((TesseractScreen)TesseractScreen.this).menu).craftingMode ? 235 : 219;
            pPoseStack.blit(GUI_IMG, this.getX(), this.getY(), (float)uOffset, (float)this.yTexStart, this.width, this.height, 256, 256);
        }
    }

    private class ToggleLockButton
    extends ImageButton {
        public ToggleLockButton(int pX, int pY) {
            super(pX, pY, 16, 16, 219, 43, GUI_IMG, pButton -> TesseractScreen.this.toggleLock());
            MutableComponent componentA = Component.translatable((String)"gui.avaritia.owner", (Object[])new Object[]{"\u00a7a" + ((TesseractMenu)((TesseractScreen)TesseractScreen.this).menu).player.getGameProfile().getName()});
            MutableComponent componentB = Component.translatable((String)"gui.avaritia.owner", (Object[])new Object[]{"\u00a7c" + TesseractScreen.this.ownerName});
            MutableComponent componentC = Component.translatable((String)"gui.avaritia.owner", (Object[])new Object[]{TesseractScreen.this.ownerName});
            if (((TesseractMenu)((TesseractScreen)TesseractScreen.this).menu).owner.equals(((TesseractMenu)((TesseractScreen)TesseractScreen.this).menu).player.getUUID())) {
                this.setTooltip(Tooltip.create((Component)componentA));
            } else if (((TesseractMenu)((TesseractScreen)TesseractScreen.this).menu).locked) {
                this.setTooltip(Tooltip.create((Component)componentB));
            } else {
                this.setTooltip(Tooltip.create((Component)componentC));
            }
        }

        @ParametersAreNonnullByDefault
        public void renderWidget(GuiGraphics pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
            int uOffset = ((TesseractMenu)((TesseractScreen)TesseractScreen.this).menu).locked ? 235 : 219;
            pPoseStack.blit(GUI_IMG, this.getX(), this.getY(), (float)uOffset, (float)this.yTexStart, this.width, this.height, 256, 256);
        }
    }

    private class ChannelButton
    extends ImageButton {
        private final List<FormattedCharSequence> tips;

        public ChannelButton(int pX, int pY) {
            super(pX, pY, 16, 16, 219, 59, GUI_IMG, pButton -> TesseractScreen.this.channelButtonPress());
            this.tips = new ArrayList<FormattedCharSequence>();
            if (((TesseractMenu)((TesseractScreen)TesseractScreen.this).menu).channelOwner.equals(((TesseractMenu)((TesseractScreen)TesseractScreen.this).menu).player.getUUID())) {
                this.tips.add(Component.translatable((String)"gui.avaritia.channel.tip1", (Object[])new Object[]{"\u00a7a" + ((TesseractMenu)((TesseractScreen)TesseractScreen.this).menu).channel.getName()}).getVisualOrderText());
                this.tips.add(Component.translatable((String)"gui.avaritia.channel.tip2", (Object[])new Object[]{"\u00a7a" + ClientChannelManager.getInstance().getUserName(((TesseractMenu)((TesseractScreen)TesseractScreen.this).menu).channelOwner)}).getVisualOrderText());
            } else if (!((TesseractMenu)((TesseractScreen)TesseractScreen.this).menu).channelOwner.equals(Const.AVARITIA_FAKE_PLAYER.getId())) {
                this.tips.add(Component.translatable((String)"gui.avaritia.channel.tip1", (Object[])new Object[]{"\u00a7c" + ((TesseractMenu)((TesseractScreen)TesseractScreen.this).menu).channel.getName()}).getVisualOrderText());
                this.tips.add(Component.translatable((String)"gui.avaritia.channel.tip2", (Object[])new Object[]{"\u00a7c" + ClientChannelManager.getInstance().getUserName(((TesseractMenu)((TesseractScreen)TesseractScreen.this).menu).channelOwner)}).getVisualOrderText());
            } else {
                this.tips.add(Component.translatable((String)"gui.avaritia.channel.tip1", (Object[])new Object[]{((TesseractMenu)((TesseractScreen)TesseractScreen.this).menu).channel.getName()}).getVisualOrderText());
                this.tips.add(Component.translatable((String)"gui.avaritia.channel.tip2", (Object[])new Object[]{ClientChannelManager.getInstance().getUserName(((TesseractMenu)((TesseractScreen)TesseractScreen.this).menu).channelOwner)}).getVisualOrderText());
            }
        }

        @ParametersAreNonnullByDefault
        public void renderWidget(GuiGraphics pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
            pPoseStack.blit(GUI_IMG, this.getX(), this.getY(), (float)this.xTexStart, (float)this.yTexStart, this.width, this.height, 256, 256);
            if (this.isHovered) {
                TesseractScreen.this.setTooltipForNextRenderPass(this.tips);
            }
        }
    }

    private class SortButton
    extends ImageButton {
        public SortButton(int pX, int pY) {
            super(pX, pY, 16, 16, 219, 75, GUI_IMG, pButton -> TesseractScreen.this.cycleSort());
        }

        @ParametersAreNonnullByDefault
        public void renderWidget(GuiGraphics pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
            ArrayList<FormattedCharSequence> list = new ArrayList<FormattedCharSequence>();
            int vOffset = ((TesseractMenu)((TesseractScreen)TesseractScreen.this).menu).sortType * 16 + this.yTexStart;
            pPoseStack.blit(GUI_IMG, this.getX(), this.getY(), (float)this.xTexStart, (float)vOffset, this.width, this.height, 256, 256);
            list.add(Component.translatable((String)TesseractScreen.this.getSortKey(((TesseractMenu)((TesseractScreen)TesseractScreen.this).menu).sortType)).getVisualOrderText());
            if (((TesseractMenu)((TesseractScreen)TesseractScreen.this).menu).sortType % 2 == 0) {
                list.add(Component.translatable((String)"gui.avaritia.sort.ascending").getVisualOrderText());
            } else {
                list.add(Component.translatable((String)"gui.avaritia.sort.descending").getVisualOrderText());
            }
            list.add(Component.translatable((String)"gui.avaritia.line").getVisualOrderText());
            list.add(Component.translatable((String)"gui.avaritia.sort.tip1").getVisualOrderText());
            list.add(Component.translatable((String)"gui.avaritia.sort.tip2").getVisualOrderText());
            if (TesseractScreen.this.sortButton.isHovered) {
                TesseractScreen.this.setTooltipForNextRenderPass(list);
            }
        }
    }

    private class ViewTypeButton
    extends ImageButton {
        public ViewTypeButton(int pX, int pY) {
            super(pX, pY, 16, 16, 219, 203, GUI_IMG, pButton -> TesseractScreen.this.changeViewType());
        }

        @ParametersAreNonnullByDefault
        public void renderWidget(GuiGraphics pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
            ArrayList<FormattedCharSequence> list = new ArrayList<FormattedCharSequence>();
            int vOffset = 16 * ((TesseractMenu)((TesseractScreen)TesseractScreen.this).menu).viewType + this.yTexStart;
            pPoseStack.blit(GUI_IMG, this.getX(), this.getY(), (float)this.xTexStart, (float)vOffset, this.width, this.height, 256, 256);
            if (((TesseractMenu)((TesseractScreen)TesseractScreen.this).menu).viewType == 0) {
                list.add(Component.translatable((String)"gui.avaritia.view.all").getVisualOrderText());
            } else if (((TesseractMenu)((TesseractScreen)TesseractScreen.this).menu).viewType == 1) {
                list.add(Component.translatable((String)"gui.avaritia.view.item").getVisualOrderText());
            } else {
                list.add(Component.translatable((String)"gui.avaritia.view.fluid").getVisualOrderText());
            }
            if (TesseractScreen.this.viewTypeButton.isHovered) {
                TesseractScreen.this.setTooltipForNextRenderPass(list);
            }
        }
    }

    private class CraftToChannelButton
    extends ImageButton {
        public CraftToChannelButton(int x, int y) {
            super(x, y, 16, 9, 219, 0, GUI_IMG, pButton -> {});
        }

        @ParametersAreNonnullByDefault
        public void renderWidget(GuiGraphics pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
            ArrayList<FormattedCharSequence> list = new ArrayList<FormattedCharSequence>();
            pPoseStack.blit(GUI_IMG, this.getX(), this.getY(), (float)this.xTexStart, (float)this.yTexStart, this.width, this.height, 256, 256);
            list.add(Component.translatable((String)"gui.avaritia.craft.channel").getVisualOrderText());
            list.add(Component.translatable((String)"gui.avaritia.craft.tip1").getVisualOrderText());
            list.add(Component.translatable((String)"gui.avaritia.craft.tip2").getVisualOrderText());
            list.add(Component.translatable((String)"gui.avaritia.craft.tip3").getVisualOrderText());
            list.add(Component.translatable((String)"gui.avaritia.craft.tip4").getVisualOrderText());
            if (this.isHovered) {
                TesseractScreen.this.setTooltipForNextRenderPass(list);
            }
        }
    }

    private class CraftToInventoryButton
    extends ImageButton {
        public CraftToInventoryButton(int x, int y) {
            super(x, y, 16, 9, 219, 18, GUI_IMG, pButton -> {});
        }

        @ParametersAreNonnullByDefault
        public void renderWidget(GuiGraphics pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
            ArrayList<FormattedCharSequence> list = new ArrayList<FormattedCharSequence>();
            pPoseStack.blit(GUI_IMG, this.getX(), this.getY(), (float)this.xTexStart, (float)this.yTexStart, this.width, this.height, 256, 256);
            list.add(Component.translatable((String)"gui.avaritia.craft.inv").getVisualOrderText());
            list.add(Component.translatable((String)"gui.avaritia.craft.tip1").getVisualOrderText());
            list.add(Component.translatable((String)"gui.avaritia.craft.tip2").getVisualOrderText());
            list.add(Component.translatable((String)"gui.avaritia.craft.tip3").getVisualOrderText());
            list.add(Component.translatable((String)"gui.avaritia.craft.tip4").getVisualOrderText());
            if (this.isHovered) {
                TesseractScreen.this.setTooltipForNextRenderPass(list);
            }
        }
    }

    private class CraftAndDropButton
    extends ImageButton {
        public CraftAndDropButton(int x, int y) {
            super(x, y, 16, 9, 219, 9, GUI_IMG, pButton -> {});
        }

        @ParametersAreNonnullByDefault
        public void renderWidget(GuiGraphics pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
            ArrayList<FormattedCharSequence> list = new ArrayList<FormattedCharSequence>();
            pPoseStack.blit(GUI_IMG, this.getX(), this.getY(), (float)this.xTexStart, (float)this.yTexStart, this.width, this.height, 256, 256);
            list.add(Component.translatable((String)"gui.avaritia.craft.drop").getVisualOrderText());
            list.add(Component.translatable((String)"gui.avaritia.craft.tip1").getVisualOrderText());
            list.add(Component.translatable((String)"gui.avaritia.craft.tip2").getVisualOrderText());
            list.add(Component.translatable((String)"gui.avaritia.craft.tip3").getVisualOrderText());
            list.add(Component.translatable((String)"gui.avaritia.craft.tip4").getVisualOrderText());
            if (this.isHovered) {
                TesseractScreen.this.setTooltipForNextRenderPass(list);
            }
        }
    }
}

