/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.entity;

import committee.nova.mods.avaritia.common.item.misc.InfinityClockItem;
import committee.nova.mods.avaritia.init.registry.ModEntities;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkHooks;

public class AcceleratorDisplayEntity
extends Entity {
    private static final EntityDataAccessor<Integer> SPEED_MULTIPLIER = SynchedEntityData.defineId(AcceleratorDisplayEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> FACE = SynchedEntityData.defineId(AcceleratorDisplayEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private BlockPos targetPos;
    private int particleTimer = 0;

    public AcceleratorDisplayEntity(EntityType<?> type, Level level) {
        super(type, level);
        this.noPhysics = true;
        this.setInvisible(true);
    }

    public AcceleratorDisplayEntity(Level level, BlockPos targetPos, int speed, Direction face) {
        this((EntityType)ModEntities.acceleratorDisplayEntity.get(), level);
        this.targetPos = targetPos;
        this.entityData.set(SPEED_MULTIPLIER, (Object)speed);
        this.entityData.set(FACE, (Object)face.get3DDataValue());
        this.setPositionByFace(targetPos, face);
    }

    protected void defineSynchedData() {
        this.entityData.define(SPEED_MULTIPLIER, (Object)1);
        this.entityData.define(FACE, (Object)Direction.NORTH.get3DDataValue());
    }

    public int getSpeedMultiplier() {
        return (Integer)this.entityData.get(SPEED_MULTIPLIER);
    }

    public void setSpeedMultiplier(int speed) {
        this.entityData.set(SPEED_MULTIPLIER, (Object)speed);
    }

    public Direction getFace() {
        return Direction.from3DDataValue((int)((Integer)this.entityData.get(FACE)));
    }

    public void setFace(Direction face) {
        this.entityData.set(FACE, (Object)face.get3DDataValue());
    }

    private void setPositionByFace(BlockPos pos, Direction face) {
        double x = (double)pos.getX() + 0.5;
        double y = (double)pos.getY() + 0.5;
        double z = (double)pos.getZ() + 0.5;
        double offset = 0.51;
        switch (face) {
            case UP: {
                y = (double)pos.getY() + offset;
                break;
            }
            case DOWN: {
                y = (double)pos.getY() - offset + 1.0;
                break;
            }
            case NORTH: {
                z = (double)pos.getZ() - offset + 1.0;
                break;
            }
            case SOUTH: {
                z = (double)pos.getZ() + offset;
                break;
            }
            case WEST: {
                x = (double)pos.getX() - offset + 1.0;
                break;
            }
            case EAST: {
                x = (double)pos.getX() + offset;
            }
        }
        this.setPos(x, y, z);
    }

    public void tick() {
        super.tick();
        if (!(this.level().isClientSide || this.targetPos != null && ((Map)InfinityClockItem.acceleratedBlocks.getOrDefault(this.level().dimension(), new HashMap())).containsKey(this.targetPos))) {
            this.remove(Entity.RemovalReason.KILLED);
        }
        if (this.level().isClientSide && this.targetPos != null) {
            this.renderEffects();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void renderEffects() {
        if (this.targetPos == null) {
            return;
        }
        ++this.particleTimer;
        Level level = this.level();
        long gameTime = level.getGameTime();
        if (this.particleTimer % 2 == 0) {
            for (int i = 0; i < 10; ++i) {
                double hAngle = ((double)gameTime * 0.5 + (double)(i * 40)) % 360.0;
                double hRadius = 0.6;
                double hX = (double)this.targetPos.getX() + 0.5 + Math.cos(Math.toRadians(hAngle)) * hRadius;
                double hZ = (double)this.targetPos.getZ() + 0.5 + Math.sin(Math.toRadians(hAngle)) * hRadius;
                double hY = (double)this.targetPos.getY() + 0.5 + (double)(i % 3 - 1) * 0.2;
                level.addParticle((ParticleOptions)ParticleTypes.ENCHANT, hX, hY, hZ, 0.0, 0.0, 0.0);
                double vAngle = ((double)gameTime * 0.7 + (double)(i * 60)) % 360.0;
                double vRadius = 0.6;
                double vX = (double)this.targetPos.getX() + 0.5 + Math.cos(Math.toRadians(vAngle)) * vRadius;
                double vY = (double)this.targetPos.getY() + 0.5 + Math.sin(Math.toRadians(vAngle)) * vRadius;
                double vZ = (double)this.targetPos.getZ() + 0.5 + ((double)(i % 2) - 0.5) * 0.2;
                level.addParticle((ParticleOptions)ParticleTypes.ENCHANT, vX, vY, vZ, 0.0, 0.0, 0.0);
            }
        }
    }

    protected void readAdditionalSaveData(CompoundTag nbt) {
        this.targetPos = BlockPos.of((long)nbt.getLong("TargetPos"));
        this.entityData.set(SPEED_MULTIPLIER, (Object)nbt.getInt("Speed"));
        this.entityData.set(FACE, (Object)nbt.getInt("Face"));
    }

    protected void addAdditionalSaveData(CompoundTag nbt) {
        nbt.putLong("TargetPos", this.targetPos.asLong());
        nbt.putInt("Speed", this.getSpeedMultiplier());
        nbt.putInt("Face", this.getFace().get3DDataValue());
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

