/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.entity;

import com.google.common.base.Predicate;
import com.mojang.authlib.GameProfile;
import committee.nova.mods.avaritia.Const;
import committee.nova.mods.avaritia.common.entity.ImmortalItemEntity;
import committee.nova.mods.avaritia.init.registry.ModDamageTypes;
import committee.nova.mods.avaritia.init.registry.ModEntities;
import committee.nova.mods.avaritia.init.registry.ModSounds;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.network.NetworkHooks;

public class GapingVoidEntity
extends Entity {
    public static final EntityDataAccessor<Integer> AGE_PARAMETER = SynchedEntityData.defineId(GapingVoidEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final int maxLifetime = 186;
    public static final Predicate<Entity> SUCK_PREDICATE = input -> {
        if (input instanceof Player) {
            Player p = (Player)input;
            return !p.isCreative() || !p.isFallFlying();
        }
        return true;
    };
    public static final Predicate<Entity> COMNOM_PREDICATE = input -> {
        if (!(input instanceof LivingEntity)) {
            return false;
        }
        if (input instanceof Player) {
            Player p = (Player)input;
            return !p.isCreative();
        }
        return !(input instanceof ImmortalItemEntity);
    };
    public static double collapse = 0.95;
    public static double suckRange = 20.0;
    private FakePlayer fakePlayer;
    private LivingEntity user;

    public GapingVoidEntity(EntityType<?> p_19870_, Level p_19871_) {
        super(p_19870_, p_19871_);
        this.noCulling = true;
        if (this.level() instanceof ServerLevel) {
            this.fakePlayer = FakePlayerFactory.get((ServerLevel)((ServerLevel)this.level()), (GameProfile)Const.AVARITIA_FAKE_PLAYER);
        }
    }

    public GapingVoidEntity(Level level) {
        this((EntityType)ModEntities.GAPING_VOID.get(), level);
    }

    public GapingVoidEntity(Level level, LivingEntity shooter) {
        this((EntityType)ModEntities.GAPING_VOID.get(), level);
        this.setUser(shooter);
    }

    public static double getVoidScale(double age) {
        double life = age / 186.0;
        double curve = life < collapse ? 0.005 + GapingVoidEntity.ease(1.0 - (collapse - life) / collapse) * 0.995 : GapingVoidEntity.ease(1.0 - (life - collapse) / (1.0 - collapse));
        return 10.0 * curve;
    }

    private static double ease(double in) {
        double t = in - 1.0;
        return Math.sqrt(1.0 - t * t);
    }

    public void setUser(LivingEntity user) {
        this.user = user;
    }

    public int getAge() {
        return (Integer)this.entityData.get(AGE_PARAMETER);
    }

    private void setAge(int age) {
        this.entityData.set(AGE_PARAMETER, (Object)age);
    }

    protected void defineSynchedData() {
        this.entityData.define(AGE_PARAMETER, (Object)0);
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        this.setAge(tag.getInt("age"));
        if (this.level() instanceof ServerLevel) {
            this.fakePlayer = FakePlayerFactory.get((ServerLevel)((ServerLevel)this.level()), (GameProfile)Const.AVARITIA_FAKE_PLAYER);
        }
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        tag.putInt("age", this.getAge());
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void tick() {
        double posX = this.getX();
        double posY = this.getY();
        double posZ = this.getZ();
        BlockPos position = this.getOnPos();
        int age = this.getAge();
        if (age >= 186 && !this.level().isClientSide) {
            this.level().explode((Entity)this, posX, posY, posZ, 6.0f, Level.ExplosionInteraction.BLOCK);
            int range = 4;
            AABB axisAlignedBB = new AABB(position.offset(-range, -range, -range), position.offset(range, range, range));
            List nommed = this.level().getEntitiesOfClass(Entity.class, axisAlignedBB, COMNOM_PREDICATE);
            nommed.stream().filter(entity -> entity != this).forEach(entity -> {
                if (entity instanceof EnderDragon) {
                    EnderDragon dragon = (EnderDragon)entity;
                    dragon.hurt(dragon.head, ModDamageTypes.causeRandomDamage(this.level(), (Entity)this.user), 1000.0f);
                    dragon.setHealth(0.0f);
                } else if (entity instanceof WitherBoss) {
                    WitherBoss wither = (WitherBoss)entity;
                    wither.setInvulnerableTicks(0);
                    wither.hurt(ModDamageTypes.causeRandomDamage(this.level(), (Entity)this.user), 1000.0f);
                } else {
                    entity.hurt(ModDamageTypes.causeRandomDamage(this.level(), (Entity)this.user), 1000.0f);
                }
            });
            this.remove(Entity.RemovalReason.KILLED);
        } else {
            if (age == 0) {
                this.level().playSound((Player)this.fakePlayer, this.getX(), this.getY(), this.getZ(), ModSounds.GAPING_VOID, SoundSource.HOSTILE, 8.0f, 1.0f);
            }
            this.setAge(age + 1);
        }
        if (this.level().isClientSide) {
            return;
        }
        if (this.fakePlayer == null) {
            this.remove(Entity.RemovalReason.KILLED);
            return;
        }
        for (int i = 0; i < 50; ++i) {
            this.level().addParticle((ParticleOptions)ParticleTypes.PORTAL, (double)position.getX(), (double)position.getY(), (double)position.getZ(), this.random.nextGaussian() * 3.0, this.random.nextGaussian() * 3.0, this.random.nextGaussian() * 3.0);
        }
        double particlespeed = 4.5;
        double size = GapingVoidEntity.getVoidScale(age) * 0.5 - 0.2;
        int range = (int)(size * suckRange);
        AABB axisAlignedBB = new AABB(position.offset(-range, -range, -range), position.offset(range, range, range));
        List sucked = this.level().getEntitiesOfClass(Entity.class, axisAlignedBB, SUCK_PREDICATE);
        double radius = GapingVoidEntity.getVoidScale(age) * 0.5;
        for (Entity suckee : sucked) {
            if (suckee == this) continue;
            double dx = posX - suckee.getX();
            double dy = posY - suckee.getY();
            double dz = posZ - suckee.getZ();
            double lensquared = dx * dx + dy * dy + dz * dz;
            double len = Math.sqrt(lensquared);
            double lenn = len / suckRange;
            if (!(len <= suckRange)) continue;
            double strength = (1.0 - lenn) * (1.0 - lenn);
            double power = 0.075 * radius;
            Vec3 motion = suckee.getDeltaMovement();
            double motionX = motion.x + dx / len * strength * power;
            double motionY = motion.y + dy / len * strength * power;
            double motionZ = motion.z + dz / len * strength * power;
            suckee.setDeltaMovement(motionX, motionY, motionZ);
        }
        int nomrange = (int)(radius * 0.95);
        AABB alignedBB = new AABB(position.offset(-nomrange, -nomrange, -nomrange), position.offset(nomrange, nomrange, nomrange));
        List nommed = this.level().getEntitiesOfClass(Entity.class, alignedBB, COMNOM_PREDICATE);
        for (Entity nommee : nommed) {
            if (nommee == this) continue;
            Vec3 nomedPos = nommee.getLookAngle();
            Vec3 diff = this.getLookAngle().subtract(nomedPos);
            double len = diff.length();
            if (!(len <= (double)nomrange)) continue;
            if (nommee instanceof EnderDragon) {
                EnderDragon dragon = (EnderDragon)nommee;
                dragon.hurt(dragon.head, this.damageSources().fellOutOfWorld(), 5.0f);
            }
            nommee.hurt(this.damageSources().fellOutOfWorld(), 5.0f);
        }
        if (age % 10 == 0) {
            Vec3 posFloor = this.position();
            int blockrange = Math.round(nomrange);
            for (int y = -blockrange; y <= blockrange; ++y) {
                for (int z = -blockrange; z <= blockrange; ++z) {
                    for (int x = -blockrange; x <= blockrange; ++x) {
                        float resist;
                        double dist;
                        Vec3 pos2 = new Vec3((double)x, (double)y, (double)z);
                        Vec3 rPos = posFloor.add(pos2);
                        BlockPos blockPos = BlockPos.containing((double)rPos.x, (double)rPos.y, (double)rPos.z);
                        if (blockPos.getY() < 0 || blockPos.getY() > 255 || !((dist = pos2.lengthSqr()) <= (double)nomrange) || this.level().getBlockState(blockPos).isAir()) continue;
                        BlockState state = this.level().getBlockState(blockPos);
                        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(this.level(), blockPos, state, (Player)this.fakePlayer);
                        MinecraftForge.EVENT_BUS.post((Event)event);
                        if (event.isCanceled() || !((double)(resist = state.getBlock().getExplosionResistance()) <= 10.0)) continue;
                        state.getBlock().canDropFromExplosion(state, (BlockGetter)this.level(), blockPos, new Explosion(this.level(), null, (double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ(), 6.0f, false, Explosion.BlockInteraction.DESTROY));
                        this.level().setBlock(blockPos, Blocks.AIR.defaultBlockState(), 2);
                    }
                }
            }
        }
    }

    public boolean canBeCollidedWith() {
        return false;
    }

    public boolean shouldRenderAtSqrDistance(double p_19883_) {
        return true;
    }
}

