/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.entity;

import committee.nova.mods.avaritia.init.config.ModConfig;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class ImmortalItemEntity
extends ItemEntity {
    public ImmortalItemEntity(EntityType<? extends ItemEntity> type, Level level) {
        super(type, level);
        this.pickupDelay = 5;
        this.lifespan = 3600;
        this.setUnlimitedLifetime();
    }

    public static ImmortalItemEntity create(EntityType<ImmortalItemEntity> type, Level level, double x, double y, double z, ItemStack itemStack) {
        ImmortalItemEntity entity = (ImmortalItemEntity)type.create(level);
        if (entity != null) {
            entity.setPos(x, y, z);
            entity.setItem(itemStack);
        }
        return entity;
    }

    public boolean hurt(@NotNull DamageSource source, float amount) {
        return source == this.damageSources().fellOutOfWorld();
    }

    public void tick() {
        Player targetPlayer;
        super.tick();
        if (!this.level().isClientSide && (targetPlayer = this.level().getNearestPlayer((Entity)this, ((Double)ModConfig.immortalItemEntityRange.get()).doubleValue())) != null) {
            Vec3 direction = new Vec3(targetPlayer.getX() - this.getX(), targetPlayer.getY() + (double)targetPlayer.getEyeHeight() - this.getY(), targetPlayer.getZ() - this.getZ()).normalize();
            this.setDeltaMovement(direction.scale(((Double)ModConfig.immortalItemEntitySpeed.get()).doubleValue()));
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.02, 0.0));
        }
    }

    public void remove(@NotNull Entity.RemovalReason pReason) {
        super.remove(pReason);
    }

    public boolean fireImmune() {
        return true;
    }

    public boolean ignoreExplosion() {
        return true;
    }
}

