/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.entity;

import committee.nova.mods.avaritia.common.item.tools.infinity.InfinityTridentItem;
import committee.nova.mods.avaritia.init.registry.ModEntities;
import committee.nova.mods.avaritia.init.registry.ModItems;
import committee.nova.mods.avaritia.util.ToolUtils;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public class InfinityThrownTrident
extends AbstractArrow
implements IEntityAdditionalSpawnData {
    private static final EntityDataAccessor<Boolean> CHANNELING = SynchedEntityData.defineId(InfinityThrownTrident.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> SHOCKWAVE = SynchedEntityData.defineId(InfinityThrownTrident.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> RADIUS = SynchedEntityData.defineId(InfinityThrownTrident.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private ItemStack tridentItem = new ItemStack((ItemLike)ModItems.infinity_trident.get());
    private boolean dealtDamage;
    private boolean noReturn;
    private int loyaltyLevel = 3;
    public int returningTicks;

    public InfinityThrownTrident(EntityType<? extends InfinityThrownTrident> type, Level worldIn) {
        super(type, worldIn);
    }

    public InfinityThrownTrident(Level world, LivingEntity thrower, ItemStack thrownStackIn) {
        super((EntityType)ModEntities.infinity_thrown_trident.get(), thrower, world);
        this.setStackAndLoyalty(thrownStackIn.copy());
        this.entityData.set(SHOCKWAVE, (Object)((InfinityTridentItem)ModItems.infinity_trident.get()).getCurrentShockwave(this.tridentItem));
        this.entityData.set(CHANNELING, (Object)((InfinityTridentItem)ModItems.infinity_trident.get()).getCurrentChanneling(this.tridentItem));
    }

    private void setStackAndLoyalty(@NotNull ItemStack stack) {
        Item item;
        if (!stack.isEmpty() && (item = stack.getItem()) instanceof InfinityTridentItem) {
            InfinityTridentItem trident = (InfinityTridentItem)item;
            this.tridentItem = stack;
        }
    }

    protected void defineSynchedData() {
        super.defineSynchedData();
        this.entityData.define(SHOCKWAVE, (Object)false);
        this.entityData.define(CHANNELING, (Object)false);
        this.entityData.define(RADIUS, (Object)1);
    }

    public void tick() {
        if (this.inGroundTime > 4) {
            this.dealtDamage = true;
            this.noReturn = !this.isAcceptableReturnOwner();
        }
        Entity entity = this.getOwner();
        if (!this.noReturn && (this.dealtDamage || this.isNoPhysics()) && entity != null) {
            if (!this.isAcceptableReturnOwner()) {
                if (!this.level().isClientSide && this.pickup == AbstractArrow.Pickup.ALLOWED) {
                    this.spawnAtLocation(this.getPickupItem(), 0.1f);
                }
            } else if (this.loyaltyLevel > 0) {
                this.onClientRemoval();
                this.setNoPhysics(true);
                Vec3 returnVector = entity.getEyePosition().subtract(this.position());
                this.setPosRaw(this.getX(), this.getY() + returnVector.y * 0.015 * (double)this.loyaltyLevel, this.getZ());
                if (this.level().isClientSide) {
                    this.yOld = this.getY();
                }
                this.setDeltaMovement(this.getDeltaMovement().scale(0.95).add(returnVector.normalize().scale(0.05 * (double)this.loyaltyLevel)));
                if (this.returningTicks == 0) {
                    this.playSound(SoundEvents.TRIDENT_RETURN, 10.0f, 1.0f);
                }
                ++this.returningTicks;
            }
        }
        super.tick();
    }

    private boolean isAcceptableReturnOwner() {
        Entity entity = this.getOwner();
        if (entity != null && entity.isAlive()) {
            return !(entity instanceof ServerPlayer) || !entity.isSpectator();
        }
        return false;
    }

    @NotNull
    protected ItemStack getPickupItem() {
        return this.tridentItem.copy();
    }

    protected void onHitEntity(EntityHitResult result) {
        List mobs;
        Entity hitEntity = result.getEntity();
        float damage = Float.MAX_VALUE;
        Entity thrower = this.getOwner();
        DamageSource damagesource = this.damageSources().trident((Entity)this, (Entity)(thrower == null ? this : thrower));
        this.dealtDamage = true;
        if (hitEntity.hurt(damagesource, damage) && hitEntity instanceof LivingEntity) {
            LivingEntity livingHit = (LivingEntity)hitEntity;
            if (thrower instanceof LivingEntity) {
                EnchantmentHelper.doPostHurtEffects((LivingEntity)livingHit, (Entity)thrower);
                EnchantmentHelper.doPostDamageEffects((LivingEntity)((LivingEntity)thrower), (Entity)livingHit);
            }
            this.doPostHurtEffects(livingHit);
        }
        this.setDeltaMovement(this.getDeltaMovement().multiply(-0.01, -0.1, -0.01));
        float volume = 1.0f;
        SoundEvent sound = SoundEvents.TRIDENT_HIT;
        AABB area = new AABB(hitEntity.getX(), hitEntity.getY(), hitEntity.getZ(), hitEntity.getX(), hitEntity.getY(), hitEntity.getZ()).inflate((double)((Integer)this.entityData.get(RADIUS)).intValue());
        List list = mobs = (Boolean)this.entityData.get(SHOCKWAVE) != false ? this.getCommandSenderWorld().getEntitiesOfClass(Mob.class, area) : Collections.emptyList();
        if (thrower instanceof Player && ((Boolean)this.entityData.get(SHOCKWAVE)).booleanValue()) {
            mobs.forEach(mobEntity -> mobEntity.hurt(mobEntity.damageSources().playerAttack((Player)thrower), damage));
            this.getCommandSenderWorld().getEntitiesOfClass(ItemEntity.class, area.inflate(1.0)).forEach(itemEntity -> {
                itemEntity.setNoPickUpDelay();
                itemEntity.teleportTo((double)thrower.blockPosition().getX(), (double)(thrower.blockPosition().getY() + 1), (double)thrower.blockPosition().getZ());
            });
            this.getCommandSenderWorld().getEntitiesOfClass(ExperienceOrb.class, area.inflate(1.0)).forEach(entityXPOrb -> entityXPOrb.teleportTo((double)thrower.blockPosition().getX(), (double)thrower.blockPosition().getY(), (double)thrower.blockPosition().getZ()));
        }
        if (this.level() instanceof ServerLevel && ((Boolean)this.entityData.get(CHANNELING)).booleanValue()) {
            BlockPos blockpos = hitEntity.blockPosition();
            if (this.level().canSeeSky(blockpos)) {
                ToolUtils.trySummonLightning(this.level(), 1, blockpos, thrower instanceof ServerPlayer ? (ServerPlayer)thrower : null);
                sound = SoundEvents.TRIDENT_THUNDER;
                volume = 5.0f;
                mobs.forEach(mobEntity -> {
                    if (this.level().canSeeSky(mobEntity.blockPosition())) {
                        ToolUtils.trySummonLightning(this.level(), 1, mobEntity.blockPosition(), thrower instanceof ServerPlayer ? (ServerPlayer)thrower : null);
                    }
                });
            }
        }
        this.playSound(sound, volume, 1.0f);
    }

    public void readAdditionalSaveData(@NotNull CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Trident", 10)) {
            this.setStackAndLoyalty(ItemStack.of((CompoundTag)compound.getCompound("Trident")));
        }
        this.dealtDamage = compound.getBoolean("DealtDamage");
        this.noReturn = compound.getBoolean("NoReturn");
        this.entityData.set(SHOCKWAVE, (Object)((InfinityTridentItem)ModItems.infinity_trident.get()).getCurrentShockwave(this.tridentItem));
        this.entityData.set(CHANNELING, (Object)((InfinityTridentItem)ModItems.infinity_trident.get()).getCurrentChanneling(this.tridentItem));
    }

    public void addAdditionalSaveData(@NotNull CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.put("Trident", (Tag)this.tridentItem.serializeNBT());
        compound.putBoolean("DealtDamage", this.dealtDamage);
        compound.putBoolean("NoReturn", this.noReturn);
    }

    protected void tickDespawn() {
    }

    protected float getWaterInertia() {
        return 1.49f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isFoil() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldRender(double x, double y, double z) {
        return true;
    }

    @NotNull
    protected SoundEvent getDefaultHitGroundSoundEvent() {
        return SoundEvents.TRIDENT_HIT_GROUND;
    }

    @NotNull
    public Packet<ClientGamePacketListener> getAddEntityPacket() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.writeItem(this.tridentItem);
    }

    public void readSpawnData(FriendlyByteBuf buffer) {
        this.setStackAndLoyalty(buffer.readItem());
    }

    public ItemStack getPickedResult(HitResult target) {
        return this.tridentItem.copy();
    }

    @Generated
    public void setLoyaltyLevel(int loyaltyLevel) {
        this.loyaltyLevel = loyaltyLevel;
    }
}

