/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.item.misc;

import committee.nova.mods.avaritia.api.iface.IInfinityClockSwitchable;
import committee.nova.mods.avaritia.common.entity.AcceleratorDisplayEntity;
import committee.nova.mods.avaritia.common.item.resources.ResourceItem;
import committee.nova.mods.avaritia.common.menu.InfinityClockMenu;
import committee.nova.mods.avaritia.init.registry.ModRarities;
import committee.nova.mods.avaritia.util.ToolUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public class InfinityClockItem
extends ResourceItem
implements IInfinityClockSwitchable {
    public static final Map<ResourceKey<Level>, Map<BlockPos, Integer>> acceleratedBlocks = new HashMap<ResourceKey<Level>, Map<BlockPos, Integer>>();
    private static final Map<ResourceKey<Level>, Map<BlockPos, AcceleratorDisplayEntity>> displayEntities = new HashMap<ResourceKey<Level>, Map<BlockPos, AcceleratorDisplayEntity>>();

    public InfinityClockItem() {
        super(ModRarities.COSMIC, true, new Item.Properties().stacksTo(1));
    }

    public boolean isFoil(@NotNull ItemStack pStack) {
        return false;
    }

    public boolean isDamageable(ItemStack stack) {
        return false;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (level.isClientSide) {
            return InteractionResultHolder.pass((Object)stack);
        }
        boolean upMode = this.isActive(stack, "infinity_clock_up");
        if (player.isShiftKeyDown()) {
            this.switchClockMode(level, player, hand, "infinity_clock_up");
            return InteractionResultHolder.success((Object)stack);
        }
        if (upMode) {
            int current = stack.getOrCreateTag().getInt("SpeedMultiplier");
            int next = switch (current) {
                case 1 -> 4;
                case 4 -> 16;
                case 16 -> 64;
                case 64 -> 256;
                case 256 -> 512;
                default -> 1;
            };
            stack.getOrCreateTag().putInt("SpeedMultiplier", next);
            player.displayClientMessage((Component)Component.literal((String)(next + "x")), true);
            return InteractionResultHolder.success((Object)stack);
        }
        NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)new SimpleMenuProvider((id, inv, buf) -> new InfinityClockMenu(id, inv), (Component)Component.translatable((String)"item.avaritia.infinity_clock")));
        return InteractionResultHolder.success((Object)stack);
    }

    public InteractionResult useOn(UseOnContext ctx) {
        ItemStack stack = ctx.getItemInHand();
        Level level = ctx.getLevel();
        BlockPos pos = ctx.getClickedPos();
        Direction face = ctx.getClickedFace();
        if (!this.isActive(stack, "infinity_clock_up")) {
            this.removeAcceleration(level, pos);
            return InteractionResult.CONSUME;
        }
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        CompoundTag tag = stack.getOrCreateTag();
        int multiplier = tag.getInt("SpeedMultiplier");
        if (multiplier == 0) {
            multiplier = 1;
            tag.putInt("SpeedMultiplier", multiplier);
        }
        if (multiplier == 1) {
            this.removeAcceleration(level, pos);
            return InteractionResult.CONSUME;
        }
        acceleratedBlocks.computeIfAbsent((ResourceKey<Level>)level.dimension(), k -> new HashMap()).put(pos.immutable(), multiplier);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.removeDisplayEntity(level, pos);
            AcceleratorDisplayEntity entity = new AcceleratorDisplayEntity(level, pos, multiplier, face);
            serverLevel.addFreshEntity((Entity)entity);
            displayEntities.computeIfAbsent((ResourceKey<Level>)level.dimension(), k -> new HashMap()).put(pos.immutable(), entity);
        }
        return InteractionResult.CONSUME;
    }

    private void removeAcceleration(Level level, BlockPos pos) {
        ResourceKey dimension = level.dimension();
        if (acceleratedBlocks.containsKey(dimension)) {
            acceleratedBlocks.get(dimension).remove(pos);
            if (acceleratedBlocks.get(dimension).isEmpty()) {
                acceleratedBlocks.remove(dimension);
            }
        }
        this.removeDisplayEntity(level, pos);
    }

    private void removeDisplayEntity(Level level, BlockPos pos) {
        ResourceKey dimension = level.dimension();
        if (displayEntities.containsKey(dimension)) {
            AcceleratorDisplayEntity entity = displayEntities.get(dimension).get(pos);
            if (entity != null && !entity.isRemoved()) {
                entity.remove(Entity.RemovalReason.DISCARDED);
            }
            displayEntities.get(dimension).remove(pos);
            if (displayEntities.get(dimension).isEmpty()) {
                displayEntities.remove(dimension);
            }
        }
    }

    public static AcceleratedBlocksSavedData getSavedData(ServerLevel level) {
        return (AcceleratedBlocksSavedData)level.getDataStorage().computeIfAbsent(AcceleratedBlocksSavedData::new, AcceleratedBlocksSavedData::new, "avaritia_accelerated_blocks");
    }

    public static void loadAcceleratedBlocksFromSavedData(ServerLevel level) {
        AcceleratedBlocksSavedData savedData = InfinityClockItem.getSavedData(level);
        acceleratedBlocks.clear();
        acceleratedBlocks.putAll(savedData.getAcceleratedBlocks());
        for (Map.Entry<ResourceKey<Level>, Map<BlockPos, Integer>> dimensionEntry : acceleratedBlocks.entrySet()) {
            ResourceKey<Level> dimension = dimensionEntry.getKey();
            Map<BlockPos, Integer> blocks = dimensionEntry.getValue();
            for (Map.Entry<BlockPos, Integer> blockEntry : blocks.entrySet()) {
                BlockPos pos = blockEntry.getKey();
                int multiplier = blockEntry.getValue();
                if (!level.isLoaded(pos) || multiplier <= 1) continue;
                AcceleratorDisplayEntity entity = new AcceleratorDisplayEntity((Level)level, pos, multiplier, Direction.NORTH);
                level.addFreshEntity((Entity)entity);
                displayEntities.computeIfAbsent(dimension, k -> new HashMap()).put(pos.immutable(), entity);
            }
        }
    }

    public static void saveAcceleratedBlocksToSavedData(ServerLevel level) {
        AcceleratedBlocksSavedData savedData = InfinityClockItem.getSavedData(level);
        savedData.setAcceleratedBlocks(acceleratedBlocks);
    }

    public static class AcceleratedBlocksSavedData
    extends SavedData {
        public static final String NAME = "avaritia_accelerated_blocks";
        private final Map<ResourceKey<Level>, Map<BlockPos, Integer>> acceleratedBlocks = new HashMap<ResourceKey<Level>, Map<BlockPos, Integer>>();

        public AcceleratedBlocksSavedData() {
        }

        public AcceleratedBlocksSavedData(CompoundTag nbt) {
            ListTag dimensionsList = nbt.getList("Dimensions", 10);
            for (int i = 0; i < dimensionsList.size(); ++i) {
                CompoundTag dimensionTag = dimensionsList.getCompound(i);
                ResourceLocation dimensionLocation = new ResourceLocation(dimensionTag.getString("Dimension"));
                ResourceKey dimensionKey = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)dimensionLocation);
                HashMap<BlockPos, Integer> blocksMap = new HashMap<BlockPos, Integer>();
                ListTag blocksList = dimensionTag.getList("Blocks", 10);
                for (int j = 0; j < blocksList.size(); ++j) {
                    CompoundTag blockTag = blocksList.getCompound(j);
                    BlockPos pos = BlockPos.of((long)blockTag.getLong("Pos"));
                    int multiplier = blockTag.getInt("Multiplier");
                    blocksMap.put(pos, multiplier);
                }
                this.acceleratedBlocks.put((ResourceKey<Level>)dimensionKey, blocksMap);
            }
        }

        public CompoundTag save(CompoundTag compound) {
            ListTag dimensionsList = new ListTag();
            for (Map.Entry<ResourceKey<Level>, Map<BlockPos, Integer>> dimensionEntry : this.acceleratedBlocks.entrySet()) {
                CompoundTag dimensionTag = new CompoundTag();
                dimensionTag.putString("Dimension", dimensionEntry.getKey().location().toString());
                ListTag blocksList = new ListTag();
                for (Map.Entry<BlockPos, Integer> blockEntry : dimensionEntry.getValue().entrySet()) {
                    CompoundTag blockTag = new CompoundTag();
                    blockTag.putLong("Pos", blockEntry.getKey().asLong());
                    blockTag.putInt("Multiplier", blockEntry.getValue().intValue());
                    blocksList.add((Object)blockTag);
                }
                dimensionTag.put("Blocks", (Tag)blocksList);
                dimensionsList.add((Object)dimensionTag);
            }
            compound.put("Dimensions", (Tag)dimensionsList);
            return compound;
        }

        public Map<ResourceKey<Level>, Map<BlockPos, Integer>> getAcceleratedBlocks() {
            return this.acceleratedBlocks;
        }

        public void setAcceleratedBlocks(Map<ResourceKey<Level>, Map<BlockPos, Integer>> blocks) {
            this.acceleratedBlocks.clear();
            this.acceleratedBlocks.putAll(blocks);
            this.setDirty();
        }
    }

    @Mod.EventBusSubscriber
    public static class TickHandler {
        @SubscribeEvent
        public static void onServerTick(TickEvent.LevelTickEvent event) {
            if (event.phase != TickEvent.Phase.END) {
                return;
            }
            Level level = event.level;
            if (!(level instanceof ServerLevel)) {
                return;
            }
            ServerLevel level2 = (ServerLevel)level;
            Map<BlockPos, Integer> map = acceleratedBlocks.get(level2.dimension());
            if (map == null || map.isEmpty()) {
                return;
            }
            Iterator<Map.Entry<BlockPos, Integer>> it = map.entrySet().iterator();
            while (it.hasNext()) {
                AcceleratorDisplayEntity entity;
                Map.Entry<BlockPos, Integer> entry = it.next();
                BlockPos pos = entry.getKey();
                int times = entry.getValue();
                if (times == 1) {
                    it.remove();
                    TickHandler.removeDisplayEntity((Level)level2, pos);
                    continue;
                }
                if (!level2.isLoaded(pos)) continue;
                BlockState state = level2.getBlockState(pos);
                Block block = state.getBlock();
                if (block instanceof BonemealableBlock) {
                    BonemealableBlock growable = (BonemealableBlock)block;
                    RandomSource random = level2.getRandom();
                    for (int i = 0; i < times && growable.isValidBonemealTarget((LevelReader)level2, pos, state, false); ++i) {
                        if (!growable.isBonemealSuccess((Level)level2, random, pos, state)) continue;
                        try {
                            growable.performBonemeal(level2, random, pos, state);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            break;
                        }
                        state = level2.getBlockState(pos);
                    }
                    if (level2.getGameTime() % 5L != 0L) continue;
                    TickHandler.addAccelerationParticles(level2, pos, times);
                    continue;
                }
                BlockEntity be = level2.getBlockEntity(pos);
                if (be != null) {
                    ToolUtils.accelerateBlockEntity(level2, pos, be, times);
                    if (level2.getGameTime() % 5L == 0L) {
                        TickHandler.addAccelerationParticles(level2, pos, times);
                    }
                } else {
                    it.remove();
                    TickHandler.removeDisplayEntity((Level)level2, pos);
                }
                if ((entity = (AcceleratorDisplayEntity)((Object)((Map)displayEntities.getOrDefault(level2.dimension(), new HashMap())).get(pos))) != null) {
                    if (entity.getSpeedMultiplier() == times) continue;
                    entity.setSpeedMultiplier(times);
                    continue;
                }
                if (times <= 1) continue;
                AcceleratorDisplayEntity newEntity = new AcceleratorDisplayEntity((Level)level2, pos, times, Direction.NORTH);
                level2.addFreshEntity((Entity)newEntity);
                displayEntities.computeIfAbsent((ResourceKey<Level>)level2.dimension(), k -> new HashMap()).put(pos.immutable(), newEntity);
            }
        }

        private static void addAccelerationParticles(ServerLevel level, BlockPos pos, int times) {
            long gameTime = level.getGameTime();
            for (int i = 0; i < 10; ++i) {
                double hAngle = ((double)gameTime * 0.5 + (double)(i * 40)) % 360.0;
                double hRadius = 0.6;
                double hX = (double)pos.getX() + 0.5 + Math.cos(Math.toRadians(hAngle)) * hRadius;
                double hZ = (double)pos.getZ() + 0.5 + Math.sin(Math.toRadians(hAngle)) * hRadius;
                double hY = (double)pos.getY() + 0.5 + (double)(i % 3 - 1) * 0.2;
                level.sendParticles((ParticleOptions)ParticleTypes.ENCHANT, hX, hY, hZ, 1, 0.0, 0.0, 0.0, 0.0);
                double vAngle = ((double)gameTime * 0.7 + (double)(i * 60)) % 360.0;
                double vRadius = 0.6;
                double vX = (double)pos.getX() + 0.5 + Math.cos(Math.toRadians(vAngle)) * vRadius;
                double vY = (double)pos.getY() + 0.5 + Math.sin(Math.toRadians(vAngle)) * vRadius;
                double vZ = (double)pos.getZ() + 0.5 + ((double)(i % 2) - 0.5) * 0.2;
                level.sendParticles((ParticleOptions)ParticleTypes.ENCHANT, vX, vY, vZ, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }

        private static void removeDisplayEntity(Level level, BlockPos pos) {
            ResourceKey dimension = level.dimension();
            if (displayEntities.containsKey(dimension)) {
                AcceleratorDisplayEntity entity = displayEntities.get(dimension).get(pos);
                if (entity != null && !entity.isRemoved()) {
                    entity.remove(Entity.RemovalReason.DISCARDED);
                }
                displayEntities.get(dimension).remove(pos);
                if (displayEntities.get(dimension).isEmpty()) {
                    displayEntities.remove(dimension);
                }
            }
        }
    }
}

