/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.item.resources;

import committee.nova.mods.avaritia.api.common.container.NoMenuContainer;
import committee.nova.mods.avaritia.api.util.ContainerUtils;
import committee.nova.mods.avaritia.api.util.ItemUtils;
import committee.nova.mods.avaritia.api.util.NBTUtils;
import committee.nova.mods.avaritia.init.registry.ModItems;
import committee.nova.mods.avaritia.init.registry.ModRarities;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class MatterClusterItem
extends Item {
    public static int CAPACITY = 4096;

    public MatterClusterItem() {
        super(new Item.Properties().rarity(ModRarities.RARE).stacksTo(1));
    }

    public static int getClusterSize(ItemStack cluster) {
        if (cluster.hasTag() || !cluster.getOrCreateTag().contains("items", 9)) {
            return Arrays.stream(MatterClusterItem.readClusterInventory((ItemStack)cluster).items).mapToInt(ItemStack::getCount).sum();
        }
        return 0;
    }

    public static List<ItemStack> makeClusters(Collection<ItemStack> input) {
        LinkedList<ItemStack> clusters = new LinkedList<ItemStack>();
        LinkedList<ItemStack> stacks = new LinkedList<ItemStack>(input);
        while (!stacks.isEmpty()) {
            int totalInserted;
            int remainder;
            ItemStack cluster;
            NoMenuContainer clusterInventory = new NoMenuContainer(CAPACITY);
            for (totalInserted = 0; !stacks.isEmpty() && totalInserted < CAPACITY; totalInserted += cluster.getCount() - remainder) {
                cluster = stacks.poll();
                remainder = ContainerUtils.insertItem(clusterInventory, cluster, false);
                if (remainder <= 0) continue;
                cluster.setCount(remainder);
                stacks.add(cluster);
                break;
            }
            if (totalInserted <= 0) continue;
            cluster = new ItemStack((ItemLike)ModItems.matter_cluster.get());
            MatterClusterItem.writeClusterInventory(cluster, clusterInventory);
            clusters.add(cluster);
        }
        return clusters;
    }

    public static boolean mergeClusters(ItemStack spawnCluster, ItemStack slotCluster) {
        NoMenuContainer receivingInv = MatterClusterItem.readClusterInventory(slotCluster);
        int recipientCount = Arrays.stream(receivingInv.items).mapToInt(ItemStack::getCount).sum();
        if (recipientCount >= CAPACITY) {
            return false;
        }
        boolean mergedAny = false;
        NoMenuContainer spawnClusterInv = MatterClusterItem.readClusterInventory(spawnCluster);
        int remainingCapacity = CAPACITY - recipientCount;
        for (ItemStack stack : spawnClusterInv.items) {
            if (stack.isEmpty() || remainingCapacity <= 0) break;
            int insertCount = Math.min(stack.getCount(), remainingCapacity);
            ItemStack insertStack = stack.copy();
            insertStack.setCount(insertCount);
            int remainder = ContainerUtils.insertItem(receivingInv, insertStack, false);
            int actualInserted = insertCount - remainder;
            if (actualInserted <= 0) continue;
            mergedAny = true;
            recipientCount += actualInserted;
            remainingCapacity -= actualInserted;
            stack.setCount(stack.getCount() - actualInserted);
        }
        MatterClusterItem.writeClusterInventory(slotCluster, receivingInv);
        int spawnClusterRemaining = Arrays.stream(spawnClusterInv.items).mapToInt(ItemStack::getCount).sum();
        if (spawnClusterRemaining == 0) {
            spawnCluster.setTag(null);
            spawnCluster.setCount(0);
        } else {
            MatterClusterItem.writeClusterInventory(spawnCluster, spawnClusterInv);
        }
        return mergedAny;
    }

    private static void writeClusterInventory(ItemStack cluster, NoMenuContainer clusterContents) {
        CompoundTag nbt = cluster.getOrCreateTag();
        nbt.put("items", (Tag)NBTUtils.writeToTag(clusterContents.items));
    }

    private static NoMenuContainer readClusterInventory(ItemStack cluster) {
        NoMenuContainer clusterInventory = new NoMenuContainer(CAPACITY);
        if (cluster.hasTag()) {
            NBTUtils.readFromTag(clusterInventory.items, cluster.getOrCreateTag().getList("items", 10));
        }
        return clusterInventory;
    }

    public void appendHoverText(ItemStack stack, Level worldIn, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        if (stack.hasTag() || !stack.getOrCreateTag().contains("items", 9)) {
            int total = MatterClusterItem.getClusterSize(stack);
            tooltip.add((Component)Component.translatable((String)"tooltip.avaritia.matter_cluster.counter", (Object[])new Object[]{total, Math.max(total, CAPACITY)}));
            tooltip.add((Component)Component.literal((String)""));
            if (Screen.hasShiftDown()) {
                Object2IntOpenHashMap itemCounts = new Object2IntOpenHashMap();
                for (ItemStack item : MatterClusterItem.readClusterInventory((ItemStack)stack).items) {
                    if (item.isEmpty()) break;
                    itemCounts.put((Object)item.getItem(), item.getCount() + itemCounts.getOrDefault((Object)item.getItem(), 0));
                }
                itemCounts.forEach((itemx, count) -> tooltip.add((Component)Component.translatable((String)itemx.getDescriptionId()).withStyle(itemx.getRarity(new ItemStack((ItemLike)itemx)).getStyleModifier()).append((Component)Component.literal((String)(" x " + count)).withStyle(ChatFormatting.GRAY))));
            } else {
                tooltip.add((Component)Component.translatable((String)"tooltip.avaritia.matter_cluster.desc").withStyle(ChatFormatting.DARK_GRAY));
                tooltip.add((Component)Component.translatable((String)"tooltip.avaritia.matter_cluster.desc2").withStyle(ChatFormatting.DARK_GRAY).withStyle(ChatFormatting.ITALIC));
            }
        }
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!level.isClientSide) {
            ItemUtils.dropInventory(level, player.blockPosition(), MatterClusterItem.readClusterInventory(stack));
        }
        player.setItemInHand(hand, ItemStack.EMPTY);
        return InteractionResultHolder.success((Object)ItemStack.EMPTY);
    }
}

