/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.item.tools.crystal;

import committee.nova.mods.avaritia.common.entity.BladeSlashEntity;
import committee.nova.mods.avaritia.init.registry.ModRarities;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.Nullable;

public class CrystalBowItem
extends BowItem {
    public CrystalBowItem() {
        super(new Item.Properties().rarity(ModRarities.EPIC).stacksTo(1).fireResistant());
    }

    public void releaseUsing(ItemStack pStack, Level pLevel, LivingEntity pEntityLiving, int pTimeLeft) {
        if (pEntityLiving instanceof Player) {
            Player player = (Player)pEntityLiving;
            boolean hasInfinity = player.getAbilities().instabuild || EnchantmentHelper.getItemEnchantmentLevel((Enchantment)Enchantments.INFINITY_ARROWS, (ItemStack)pStack) > 0;
            ItemStack ammo = player.getProjectile(pStack);
            int chargeTime = this.getUseDuration(pStack) - pTimeLeft;
            if ((chargeTime = ForgeEventFactory.onArrowLoose((ItemStack)pStack, (Level)pLevel, (Player)player, (int)chargeTime, (!ammo.isEmpty() || hasInfinity ? 1 : 0) != 0)) < 0) {
                return;
            }
            if (!ammo.isEmpty() || hasInfinity) {
                float power;
                if (ammo.isEmpty()) {
                    ammo = new ItemStack((ItemLike)Items.ARROW);
                }
                if ((double)(power = CrystalBowItem.getPowerForTime((int)chargeTime)) >= 0.1) {
                    int projectileCount;
                    boolean isInfinite = player.getAbilities().instabuild || hasInfinity;
                    int multishotLevel = EnchantmentHelper.getItemEnchantmentLevel((Enchantment)Enchantments.MULTISHOT, (ItemStack)pStack);
                    int n = projectileCount = multishotLevel > 0 ? 3 : 1;
                    if (!pLevel.isClientSide) {
                        for (int i = 0; i < projectileCount; ++i) {
                            BladeSlashEntity bladeSlash = new BladeSlashEntity(pLevel, (LivingEntity)player);
                            float speed = BladeSlashEntity.defaultSpeed * (1.0f + power * 2.0f);
                            float inaccuracy = 0.5f - power * 0.4f;
                            float yawOffset = 0.0f;
                            if (multishotLevel > 0) {
                                yawOffset = i == 0 ? -10.0f : (i == 1 ? 10.0f : 0.0f);
                            }
                            bladeSlash.shootFromRotation((Entity)player, player.getXRot(), player.getYRot() + yawOffset, 0.0f, speed, inaccuracy);
                            int powerLevel = EnchantmentHelper.getItemEnchantmentLevel((Enchantment)Enchantments.POWER_ARROWS, (ItemStack)pStack);
                            float damageBoost = (float)powerLevel * 1.2f + power * 5.0f;
                            bladeSlash.damage += damageBoost;
                            bladeSlash.duration += (int)(power * 20.0f);
                            if (EnchantmentHelper.getItemEnchantmentLevel((Enchantment)Enchantments.FLAMING_ARROWS, (ItemStack)pStack) > 0) {
                                bladeSlash.setSecondsOnFire(100);
                            }
                            pLevel.addFreshEntity((Entity)bladeSlash);
                        }
                        pStack.hurtAndBreak(1, (LivingEntity)player, user -> user.broadcastBreakEvent(player.getUsedItemHand()));
                    }
                    pLevel.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.PLAYER_ATTACK_SWEEP, SoundSource.PLAYERS, 1.0f, 0.8f + power * 0.4f);
                    if (!isInfinite && !player.getAbilities().instabuild) {
                        ammo.shrink(1);
                        if (ammo.isEmpty()) {
                            player.getInventory().removeItem(ammo);
                        }
                    }
                    player.awardStat(Stats.ITEM_USED.get((Object)this));
                }
            }
        }
    }

    public void onCraftedBy(ItemStack stack, Level level, Player player) {
        stack.enchant(Enchantments.INFINITY_ARROWS, 1);
        stack.enchant(Enchantments.MULTISHOT, 1);
        super.onCraftedBy(stack, level, player);
    }

    public void appendHoverText(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        pTooltipComponents.add((Component)Component.translatable((String)"tooltip.crystal_bow"));
        super.appendHoverText(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }
}

