/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.item.tools.crystal;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import committee.nova.mods.avaritia.api.iface.ISwitchable;
import committee.nova.mods.avaritia.api.iface.ITooltip;
import committee.nova.mods.avaritia.init.registry.ModRarities;
import committee.nova.mods.avaritia.init.registry.ModToolTiers;
import committee.nova.mods.avaritia.util.ToolUtils;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class CrystalSwordItem
extends SwordItem
implements ITooltip,
ISwitchable {
    public CrystalSwordItem() {
        super(ModToolTiers.CRYSTAL, 0, 0.0f, new Item.Properties().rarity(ModRarities.EPIC).stacksTo(1).fireResistant());
    }

    @Override
    public boolean hasDescTooltip() {
        return true;
    }

    public boolean isFoil(@NotNull ItemStack pStack) {
        return false;
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.resetAttackStrengthTicker();
        }
        entity.setInvulnerable(false);
        return super.onLeftClickEntity(stack, player, entity);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level world, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player.isShiftKeyDown()) {
            this.switchMode(world, player, hand, "blade_slash");
            return InteractionResultHolder.success((Object)stack);
        }
        if (this.isActive(stack, "blade_slash")) {
            ToolUtils.shootBladeSlash(stack, player);
        }
        return super.use(world, player, hand);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (slot == EquipmentSlot.MAINHAND) {
            multimap.put((Object)Attributes.ATTACK_DAMAGE, (Object)new AttributeModifier(BASE_ATTACK_DAMAGE_UUID, "Weapon modifier", (double)this.getTier().getAttackDamageBonus(), AttributeModifier.Operation.ADDITION));
            multimap.put((Object)Attributes.ATTACK_SPEED, (Object)new AttributeModifier(BASE_ATTACK_SPEED_UUID, "Weapon modifier", (double)this.getTier().getSpeed(), AttributeModifier.Operation.ADDITION));
        }
        return multimap;
    }
}

