/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.item.tools.infinity;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import committee.nova.mods.avaritia.api.iface.ISwitchable;
import committee.nova.mods.avaritia.api.iface.IUndamageable;
import committee.nova.mods.avaritia.common.entity.ImmortalItemEntity;
import committee.nova.mods.avaritia.init.registry.ModEntities;
import committee.nova.mods.avaritia.init.registry.ModItems;
import committee.nova.mods.avaritia.init.registry.ModRarities;
import committee.nova.mods.avaritia.init.registry.ModToolTiers;
import committee.nova.mods.avaritia.util.ToolUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ToolActions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InfinityAxeItem
extends AxeItem
implements ISwitchable,
IUndamageable {
    public InfinityAxeItem() {
        super(ModToolTiers.INFINITY, 100.0f, -50.0f, new Item.Properties().rarity(ModRarities.COSMIC).stacksTo(1).fireResistant());
    }

    public boolean isFoil(@NotNull ItemStack pStack) {
        return false;
    }

    public boolean isDamageable(ItemStack stack) {
        return false;
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    @Nullable
    public Entity createEntity(Level level, Entity location, ItemStack stack) {
        return ImmortalItemEntity.create((EntityType<ImmortalItemEntity>)((EntityType)ModEntities.IMMORTAL.get()), level, location.getX(), location.getY(), location.getZ(), stack);
    }

    public int getEnchantmentValue(ItemStack stack) {
        return 0;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level pLevel, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player.isShiftKeyDown()) {
            this.switchMode(pLevel, player, hand, "infinity_axe_range");
            return InteractionResultHolder.success((Object)stack);
        }
        return super.use(pLevel, player, hand);
    }

    public boolean mineBlock(@NotNull ItemStack stack, @NotNull Level level, @NotNull BlockState state, @NotNull BlockPos pos, @NotNull LivingEntity miningEntity) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.isActive(stack, "infinity_axe_range") && ToolUtils.canHarvest(pos, (Level)serverLevel) && miningEntity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)miningEntity;
                ToolUtils.destroyTree((Player)player, serverLevel, pos, state);
            }
        }
        return false;
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        ServerPlayer livingEntity;
        Level level;
        if (entity instanceof ServerPlayer && !(level = (livingEntity = (ServerPlayer)entity).level()).isClientSide() && livingEntity.isUsingItem() && livingEntity.getUseItem().canPerformAction(ToolActions.SHIELD_BLOCK)) {
            ItemStack shieldStack = livingEntity.getUseItem();
            ShieldItem shieldItem = (ShieldItem)shieldStack.getItem();
            boolean isInfinityShield = shieldStack.is((Item)ModItems.infinity_shield.get());
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.EXPLOSION, livingEntity.getX(), livingEntity.getY() + (double)(livingEntity.getBbHeight() / 2.0f), livingEntity.getZ(), 1, 0.0, 0.0, 0.0, 0.0);
                serverLevel.playSound(null, livingEntity.getX(), livingEntity.getY(), livingEntity.getZ(), SoundEvents.GENERIC_EXPLODE, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            if (isInfinityShield) {
                return true;
            }
            livingEntity.stopUsingItem();
            if (shieldStack.getDamageValue() >= shieldStack.getMaxDamage() - 1) {
                livingEntity.setItemSlot(EquipmentSlot.OFFHAND, ItemStack.EMPTY);
            } else {
                shieldStack.setDamageValue(shieldStack.getMaxDamage() - 1);
            }
            livingEntity.getCooldowns().addCooldown((Item)shieldItem, 1200);
        }
        return super.onLeftClickEntity(stack, player, entity);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (slot == EquipmentSlot.MAINHAND) {
            multimap.put((Object)Attributes.ATTACK_DAMAGE, (Object)new AttributeModifier(BASE_ATTACK_DAMAGE_UUID, "Weapon modifier", (double)this.getTier().getAttackDamageBonus(), AttributeModifier.Operation.ADDITION));
            multimap.put((Object)Attributes.ATTACK_SPEED, (Object)new AttributeModifier(BASE_ATTACK_SPEED_UUID, "Weapon modifier", (double)this.getTier().getSpeed(), AttributeModifier.Operation.ADDITION));
        }
        return multimap;
    }
}

