/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.item.tools.infinity;

import committee.nova.mods.avaritia.api.iface.IBowTransform;
import committee.nova.mods.avaritia.api.iface.ISwitchable;
import committee.nova.mods.avaritia.api.iface.IUndamageable;
import committee.nova.mods.avaritia.api.iface.InitEnchantItem;
import committee.nova.mods.avaritia.common.entity.ImmortalItemEntity;
import committee.nova.mods.avaritia.common.entity.arrow.HeavenArrowEntity;
import committee.nova.mods.avaritia.common.entity.arrow.TraceArrowEntity;
import committee.nova.mods.avaritia.init.registry.ModEntities;
import committee.nova.mods.avaritia.init.registry.ModRarities;
import committee.nova.mods.avaritia.init.registry.ModTooltips;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InfinityBowItem
extends BowItem
implements ISwitchable,
InitEnchantItem,
IUndamageable,
IBowTransform {
    public InfinityBowItem() {
        super(new Item.Properties().stacksTo(1).rarity(ModRarities.COSMIC).fireResistant());
    }

    public boolean isFoil(@NotNull ItemStack pStack) {
        return false;
    }

    public boolean isDamageable(ItemStack stack) {
        return false;
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        if (entity.getAge() >= 0) {
            entity.setExtendedLifetime();
        }
        return super.onEntityItemUpdate(stack, entity);
    }

    public boolean isEnchantable(@NotNull ItemStack pStack) {
        return true;
    }

    public int getEnchantmentValue(ItemStack stack) {
        return 99;
    }

    public int getUseDuration(@NotNull ItemStack stack) {
        return 1200;
    }

    @NotNull
    public UseAnim getUseAnimation(@NotNull ItemStack pStack) {
        return UseAnim.BOW;
    }

    @Nullable
    public Entity createEntity(Level level, Entity location, ItemStack stack) {
        return ImmortalItemEntity.create((EntityType<ImmortalItemEntity>)((EntityType)ModEntities.IMMORTAL.get()), level, location.getX(), location.getY(), location.getZ(), stack);
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    @Override
    public int getInitEnchantLevel(ItemStack stack, Enchantment enchantment) {
        return enchantment == Enchantments.INFINITY_ARROWS ? 10 : 0;
    }

    public void appendHoverText(@NotNull ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, @NotNull TooltipFlag isAdvanced) {
        tooltipComponents.add((Component)ModTooltips.INIT_ENCHANT.args(Enchantments.INFINITY_ARROWS.getFullname(10)).build());
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        InteractionResultHolder ret = ForgeEventFactory.onArrowNock((ItemStack)itemstack, (Level)level, (Player)player, (InteractionHand)hand, (boolean)true);
        if (ret != null) {
            return ret;
        }
        if (player.isShiftKeyDown()) {
            this.switchMode(level, player, hand, "infinity_bow_tracer");
            return InteractionResultHolder.success((Object)itemstack);
        }
        player.startUsingItem(hand);
        return InteractionResultHolder.success((Object)itemstack);
    }

    public void releaseUsing(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity entity, int timeLeft) {
        if (!level.isClientSide && entity instanceof Player) {
            Player player = (Player)entity;
            int drawTime = this.getUseDuration(stack) - timeLeft;
            if ((drawTime = ForgeEventFactory.onArrowLoose((ItemStack)stack, (Level)level, (Player)player, (int)drawTime, (boolean)true)) < 0) {
                return;
            }
            float VELOCITY_MULTIPLIER = 1.2f;
            float DAMAGE_MULTIPLIER = 5000.0f;
            float draw = InfinityBowItem.getPowerForTime((int)drawTime);
            float powerForTime = draw * VELOCITY_MULTIPLIER;
            AbstractArrow arrowEntity = this.customArrow((AbstractArrow)new HeavenArrowEntity((Entity)player));
            if (this.isActive(stack, "infinity_bow_tracer") && (double)powerForTime >= 0.1) {
                arrowEntity = this.customArrow((AbstractArrow)new TraceArrowEntity((Entity)player));
            }
            arrowEntity.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, powerForTime * 3.0f, 0.01f);
            if (draw == 1.0f) {
                arrowEntity.setCritArrow(true);
            }
            arrowEntity.setBaseDamage(arrowEntity.getBaseDamage() * (double)DAMAGE_MULTIPLIER);
            this.addEnchant(stack, level, (LivingEntity)player, arrowEntity, powerForTime);
            level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ARROW_SHOOT, SoundSource.PLAYERS, 1.0f, 1.0f / (level.random.nextFloat() * 0.4f + 1.2f) + powerForTime * 0.5f);
            player.awardStat(Stats.ITEM_USED.get((Object)this));
        }
    }

    private void addEnchant(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity player, AbstractArrow arrowEntity, float powerForTime) {
        int k;
        int j = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.POWER_ARROWS, (ItemStack)stack);
        if (j > 0) {
            arrowEntity.setBaseDamage(arrowEntity.getBaseDamage() + (double)j * 0.5 + 0.5);
        }
        if ((k = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.PUNCH_ARROWS, (ItemStack)stack)) > 0) {
            arrowEntity.setKnockback(k);
        }
        if (EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.FLAMING_ARROWS, (ItemStack)stack) > 0) {
            arrowEntity.setSecondsOnFire(100);
        }
        stack.hurtAndBreak(1, player, livingEntity -> livingEntity.broadcastBreakEvent(player.getUsedItemHand()));
        arrowEntity.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
        level.addFreshEntity((Entity)arrowEntity);
    }
}

