/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.item.tools.infinity;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import committee.nova.mods.avaritia.api.iface.IUndamageable;
import committee.nova.mods.avaritia.common.entity.ImmortalItemEntity;
import committee.nova.mods.avaritia.init.registry.ModBlocks;
import committee.nova.mods.avaritia.init.registry.ModEntities;
import committee.nova.mods.avaritia.init.registry.ModRarities;
import committee.nova.mods.avaritia.init.registry.ModToolTiers;
import committee.nova.mods.avaritia.util.ToolUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.SoulSandBlock;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InfinityHoeItem
extends HoeItem
implements IUndamageable {
    public InfinityHoeItem() {
        super(ModToolTiers.INFINITY, -50, 0.0f, new Item.Properties().rarity(ModRarities.COSMIC).stacksTo(1).fireResistant());
    }

    public boolean isFoil(@NotNull ItemStack pStack) {
        return false;
    }

    public boolean isDamageable(ItemStack stack) {
        return false;
    }

    public int getEnchantmentValue(ItemStack stack) {
        return 0;
    }

    public float getDestroySpeed(@NotNull ItemStack stack, @NotNull BlockState state) {
        return Math.max(super.getDestroySpeed(stack, state), 6.0f);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level world, @NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player.isShiftKeyDown()) {
            CompoundTag tags;
            tags.putBoolean("sow", !(tags = stack.getOrCreateTag()).getBoolean("sow"));
            player.swing(hand);
            if (!world.isClientSide && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.sendSystemMessage((Component)Component.translatable((String)(tags.getBoolean("sow") ? "tooltip.avaritia.tool.infinity_hoe.type_2" : "tooltip.avaritia.tool.infinity_hoe.type_1")), true);
            }
            return InteractionResultHolder.success((Object)stack);
        }
        if (!world.isClientSide && world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            if (stack.getOrCreateTag().getBoolean("sow")) {
                player.swing(hand);
                BlockPos blockPos = player.getOnPos();
                int rang = 7;
                int height = 2;
                ToolUtils.rangeHarvest(serverLevel, player, stack, blockPos, rang, height);
                ToolUtils.rangeBonemealable(serverLevel, blockPos, rang, height, 3);
                player.getCooldowns().addCooldown(stack.getItem(), 10);
                world.playSound(player, player.getOnPos(), SoundEvents.PLAYER_LEVELUP, SoundSource.PLAYERS, 1.0f, 5.0f);
            }
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        ItemStack stack = context.getItemInHand();
        Level world = context.getLevel();
        BlockPos blockpos = context.getClickedPos();
        Block targetBlock = world.getBlockState(blockpos).getBlock();
        Player player = context.getPlayer();
        BlockState blockstate = (BlockState)Blocks.FARMLAND.defaultBlockState().setValue((Property)FarmBlock.MOISTURE, (Comparable)Integer.valueOf(7));
        BlockState soulFarmState = ((Block)ModBlocks.soul_farmland.get()).defaultBlockState();
        int rang = 5;
        BlockPos minPos = blockpos.offset(-rang, 0, -rang);
        BlockPos maxPos = blockpos.offset(rang, 0, rang);
        if (context.getClickedFace() != Direction.DOWN && world.isEmptyBlock(blockpos.above()) && (targetBlock instanceof GrassBlock || targetBlock.equals(Blocks.DIRT) || targetBlock.equals(Blocks.COARSE_DIRT))) {
            if (player != null && !world.isClientSide) {
                if (player.isShiftKeyDown() && stack.getOrCreateTag().getBoolean("sow")) {
                    Iterable boxMutable = BlockPos.betweenClosed((BlockPos)minPos, (BlockPos)maxPos);
                    for (BlockPos pos : boxMutable) {
                        BlockState state = world.getBlockState(pos);
                        Block block = state.getBlock();
                        if (!world.isEmptyBlock(pos.above())) {
                            for (int i = 1; i <= 3; ++i) {
                                this.harvest(world, pos.above(i));
                            }
                        }
                        if (world.isEmptyBlock(pos.above()) && (block instanceof GrassBlock || block.equals(Blocks.DIRT) || block.equals(Blocks.COARSE_DIRT) || block instanceof FarmBlock)) {
                            world.setBlock(pos, blockstate, 11);
                        }
                        if (world.isEmptyBlock(pos) && !world.isEmptyBlock(pos.below())) {
                            world.setBlock(pos, blockstate, 11);
                        }
                        if (state.getMapColor((BlockGetter)world, pos) != MapColor.WATER && !(state.getBlock() instanceof LiquidBlockContainer)) continue;
                        world.setBlock(pos, blockstate, 11);
                    }
                    Iterable inBoxMutable = BlockPos.betweenClosed((BlockPos)minPos, (BlockPos)maxPos.offset(0, 3, 0));
                    Iterable allInBoxMutable = BlockPos.betweenClosed((BlockPos)minPos.offset(-1, 0, -1), (BlockPos)maxPos.offset(1, 4, 1));
                    for (BlockPos pos : allInBoxMutable) {
                        BlockState state;
                        if (this.hasBox(pos, inBoxMutable) || (state = world.getBlockState(pos)).getMapColor((BlockGetter)world, pos) != MapColor.WATER && !(state.getBlock() instanceof LiquidBlockContainer)) continue;
                        world.setBlockAndUpdate(pos, Blocks.STONE.defaultBlockState());
                    }
                } else {
                    world.setBlock(blockpos, blockstate, 11);
                }
            }
            world.playSound(player, blockpos, SoundEvents.HOE_TILL, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.sidedSuccess((boolean)world.isClientSide);
        }
        if (context.getClickedFace() != Direction.DOWN && world.isEmptyBlock(blockpos.above()) && (targetBlock instanceof SoulSandBlock || targetBlock.equals(Blocks.SOUL_SOIL))) {
            if (player != null && !world.isClientSide) {
                if (player.isShiftKeyDown() && stack.getOrCreateTag().getBoolean("sow")) {
                    Iterable boxMutable = BlockPos.betweenClosed((BlockPos)minPos, (BlockPos)maxPos);
                    for (BlockPos pos : boxMutable) {
                        BlockState state = world.getBlockState(pos);
                        Block block = state.getBlock();
                        if (!world.isEmptyBlock(pos.above())) {
                            for (int i = 1; i <= 3; ++i) {
                                this.harvest(world, pos.above(i));
                            }
                        }
                        if (world.isEmptyBlock(pos.above()) && (block instanceof SoulSandBlock || block.equals(Blocks.SOUL_SOIL))) {
                            world.setBlock(pos, soulFarmState, 11);
                        }
                        if (world.isEmptyBlock(pos) && !world.isEmptyBlock(pos.below())) {
                            world.setBlock(pos, soulFarmState, 11);
                        }
                        if (state.getMapColor((BlockGetter)world, pos) != MapColor.WATER && !(state.getBlock() instanceof LiquidBlockContainer)) continue;
                        world.setBlock(pos, soulFarmState, 11);
                    }
                    Iterable inBoxMutable = BlockPos.betweenClosed((BlockPos)minPos, (BlockPos)maxPos.offset(0, 3, 0));
                    Iterable allInBoxMutable = BlockPos.betweenClosed((BlockPos)minPos.offset(-1, 0, -1), (BlockPos)maxPos.offset(1, 4, 1));
                    for (BlockPos pos : allInBoxMutable) {
                        BlockState state;
                        if (this.hasBox(pos, inBoxMutable) || (state = world.getBlockState(pos)).getMapColor((BlockGetter)world, pos) != MapColor.WATER && !(state.getBlock() instanceof LiquidBlockContainer)) continue;
                        world.setBlockAndUpdate(pos, Blocks.SOUL_SOIL.defaultBlockState());
                    }
                } else {
                    world.setBlock(blockpos, soulFarmState, 11);
                }
            }
            world.playSound(player, blockpos, SoundEvents.HOE_TILL, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.sidedSuccess((boolean)world.isClientSide);
        }
        return InteractionResult.PASS;
    }

    private boolean hasBox(BlockPos pos, Iterable<BlockPos> box) {
        for (BlockPos pos1 : box) {
            if (pos1.getX() != pos.getX() || pos1.getY() != pos.getY() || pos1.getZ() != pos.getZ()) continue;
            return true;
        }
        return false;
    }

    private void harvest(Level world, BlockPos pos) {
        BlockState state = world.getBlockState(pos);
        Block block = state.getBlock();
        if (world.isEmptyBlock(pos) || block instanceof CropBlock || block instanceof StemBlock || block instanceof CocoaBlock || block instanceof SweetBerryBushBlock) {
            return;
        }
        world.destroyBlock(pos, false);
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    @Nullable
    public Entity createEntity(Level level, Entity location, ItemStack stack) {
        return ImmortalItemEntity.create((EntityType<ImmortalItemEntity>)((EntityType)ModEntities.IMMORTAL.get()), level, location.getX(), location.getY(), location.getZ(), stack);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (slot == EquipmentSlot.MAINHAND) {
            multimap.put((Object)Attributes.ATTACK_DAMAGE, (Object)new AttributeModifier(BASE_ATTACK_DAMAGE_UUID, "Weapon modifier", (double)this.getTier().getAttackDamageBonus(), AttributeModifier.Operation.ADDITION));
            multimap.put((Object)Attributes.ATTACK_SPEED, (Object)new AttributeModifier(BASE_ATTACK_SPEED_UUID, "Weapon modifier", (double)this.getTier().getSpeed(), AttributeModifier.Operation.ADDITION));
        }
        return multimap;
    }
}

