/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.item.tools.infinity;

import committee.nova.mods.avaritia.api.iface.ISwitchable;
import committee.nova.mods.avaritia.api.iface.IUndamageable;
import committee.nova.mods.avaritia.common.entity.InfinityThrownTrident;
import committee.nova.mods.avaritia.init.registry.ModRarities;
import java.util.Arrays;
import java.util.List;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class InfinityTridentItem
extends TridentItem
implements IUndamageable,
ISwitchable {
    public static final List<String> FUNC_MODES = Arrays.asList("infinity_trident_normal", "infinity_trident_loyalty", "infinity_trident_riptide");
    public static final byte MODE_NORMAL = 0;
    public static final byte MODE_LOYALTY = 1;
    public static final byte MODE_RIPTIDE = 2;
    private static final String CHANNELING_NBT = "Channeling";
    private static final String SHOCKWAVE_NBT = "Shockwave";

    public InfinityTridentItem() {
        super(new Item.Properties().rarity(ModRarities.COSMIC).stacksTo(1).fireResistant());
    }

    public boolean getCurrentChanneling(ItemStack stack) {
        return stack.getOrCreateTag().getBoolean(CHANNELING_NBT);
    }

    public void setChanneling(ItemStack stack, boolean enabled) {
        stack.getOrCreateTag().putBoolean(CHANNELING_NBT, enabled);
    }

    public boolean getCurrentShockwave(ItemStack stack) {
        return stack.getOrCreateTag().getBoolean(SHOCKWAVE_NBT);
    }

    public void setShockwave(ItemStack stack, boolean enabled) {
        stack.getOrCreateTag().putBoolean(SHOCKWAVE_NBT, enabled);
    }

    public boolean isEnchantable(@NotNull ItemStack stack) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }

    @NotNull
    public UseAnim getUseAnimation(@NotNull ItemStack stack) {
        return UseAnim.SPEAR;
    }

    public int getUseDuration(@NotNull ItemStack stack) {
        return 18000;
    }

    public void releaseUsing(@NotNull ItemStack itemStack, @NotNull Level level, @NotNull LivingEntity livingEntity, int timeLeft) {
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            int i = this.getUseDuration(itemStack) - timeLeft;
            int currentMode = ISwitchable.getCurrentMode(itemStack, FUNC_MODES);
            if (i >= 10) {
                switch (currentMode) {
                    case 0: {
                        this.shootTrident(itemStack, level, player, true);
                        break;
                    }
                    case 1: {
                        player.awardStat(Stats.ITEM_USED.get((Object)this));
                        this.shootTrident(itemStack, level, player, false);
                        break;
                    }
                    case 2: {
                        player.awardStat(Stats.ITEM_USED.get((Object)this));
                        int riptideLevel = 5;
                        float toRadians = (float)Math.PI / 180;
                        float yaw = player.getYRot() * toRadians;
                        float pitch = player.getXRot() * toRadians;
                        float xVelocity = -Mth.sin((float)yaw) * Mth.cos((float)pitch);
                        float yVelocity = -Mth.sin((float)pitch);
                        float zVelocity = Mth.cos((float)yaw) * Mth.cos((float)pitch);
                        float velocity = Mth.sqrt((float)(xVelocity * xVelocity + yVelocity * yVelocity + zVelocity * zVelocity));
                        float velocityModifier = (0.75f + 0.75f * (float)riptideLevel) / velocity;
                        player.push((double)(xVelocity * velocityModifier), (double)(yVelocity * velocityModifier), (double)(zVelocity * velocityModifier));
                        player.startAutoSpinAttack(20);
                        if (player.onGround()) {
                            player.move(MoverType.SELF, new Vec3(0.0, 1.1999999284744263, 0.0));
                        }
                        level.playSound(null, (Entity)player, SoundEvents.TRIDENT_RIPTIDE_3, SoundSource.PLAYERS, 1.0f, 1.0f);
                    }
                }
            }
        }
    }

    private void shootTrident(@NotNull ItemStack itemStack, @NotNull Level level, Player player, boolean noReturn) {
        if (!level.isClientSide) {
            InfinityThrownTrident throwntrident = new InfinityThrownTrident(level, (LivingEntity)player, itemStack);
            throwntrident.setLoyaltyLevel(noReturn ? 0 : 3);
            throwntrident.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 2.5f, 1.0f);
            if (player.getAbilities().instabuild) {
                throwntrident.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
            }
            level.addFreshEntity((Entity)throwntrident);
            level.playSound(null, (Entity)throwntrident, SoundEvents.TRIDENT_THROW, SoundSource.PLAYERS, 1.0f, 1.0f);
            if (!player.getAbilities().instabuild) {
                player.getInventory().removeItem(itemStack);
            }
        }
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level world, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player.isShiftKeyDown()) {
            this.cycleMode(world, player, hand, FUNC_MODES);
            return InteractionResultHolder.success((Object)stack);
        }
        player.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)stack);
    }
}

