/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.menu;

import committee.nova.mods.avaritia.common.crafting.recipe.ExtremeSmithingRecipe;
import committee.nova.mods.avaritia.init.registry.ModBlocks;
import committee.nova.mods.avaritia.init.registry.ModMenus;
import committee.nova.mods.avaritia.init.registry.ModRecipeTypes;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.ItemCombinerMenu;
import net.minecraft.world.inventory.ItemCombinerMenuSlotDefinition;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtremeSmithingMenu
extends ItemCombinerMenu {
    @Nullable
    private SmithingRecipe selectedRecipe;
    private final Level level;
    private final List<ExtremeSmithingRecipe> recipes;

    public ExtremeSmithingMenu(int id, Inventory playerInventory, FriendlyByteBuf buffer) {
        this(id, playerInventory, ContainerLevelAccess.NULL);
    }

    public ExtremeSmithingMenu(int pContainerId, Inventory pPlayerInventory, ContainerLevelAccess access) {
        super((MenuType)ModMenus.extreme_smithing_table.get(), pContainerId, pPlayerInventory, access);
        this.level = pPlayerInventory.player.level();
        this.recipes = this.level.getRecipeManager().getAllRecipesFor((RecipeType)ModRecipeTypes.EXTREME_SMITHING_RECIPE.get());
    }

    protected boolean mayPickup(@NotNull Player pPlayer, boolean pHasStack) {
        return this.selectedRecipe != null && this.selectedRecipe.matches(this.inputSlots, this.level);
    }

    protected void onTake(@NotNull Player pPlayer, @NotNull ItemStack pStack) {
        pStack.onCraftedBy(pPlayer.level(), pPlayer, pStack.getCount());
        this.resultSlots.awardUsedRecipes(pPlayer, this.getRelevantItems());
        this.shrinkStackInSlot(0);
        this.shrinkStackInSlot(1);
        this.shrinkStackInSlot(2);
        this.shrinkStackInSlot(3);
        this.shrinkStackInSlot(4);
        this.access.execute((level, pos) -> level.levelEvent(1044, pos, 0));
    }

    protected boolean isValidBlock(@NotNull BlockState pState) {
        return pState.is((Block)ModBlocks.extreme_smithing_table.get());
    }

    public boolean stillValid(@NotNull Player pPlayer) {
        return true;
    }

    public void createResult() {
        List list = this.level.getRecipeManager().getRecipesFor((RecipeType)ModRecipeTypes.EXTREME_SMITHING_RECIPE.get(), this.inputSlots, this.level);
        if (list.isEmpty()) {
            this.resultSlots.setItem(0, ItemStack.EMPTY);
        } else {
            ExtremeSmithingRecipe smithingrecipe = (ExtremeSmithingRecipe)list.get(0);
            ItemStack itemstack = smithingrecipe.assemble(this.inputSlots, this.level.registryAccess());
            if (itemstack.isItemEnabled(this.level.enabledFeatures())) {
                this.selectedRecipe = smithingrecipe;
                this.resultSlots.setRecipeUsed((Recipe)smithingrecipe);
                this.resultSlots.setItem(0, itemstack);
            }
        }
    }

    @NotNull
    protected ItemCombinerMenuSlotDefinition createInputSlotDefinitions() {
        return ItemCombinerMenuSlotDefinition.create().withSlot(0, 31, 35, stack -> this.recipes.stream().anyMatch(recipe -> recipe.isTemplateIngredient((ItemStack)stack))).withSlot(1, 49, 35, stack -> this.recipes.stream().anyMatch(recipe -> recipe.isBaseIngredient((ItemStack)stack))).withSlot(2, 67, 35, stack -> this.recipes.stream().anyMatch(recipe -> recipe.isAdditionIngredient((ItemStack)stack))).withSlot(3, 49, 17, stack -> this.recipes.stream().anyMatch(recipe -> recipe.isAdditionIngredient((ItemStack)stack))).withSlot(4, 49, 53, stack -> this.recipes.stream().anyMatch(recipe -> recipe.isAdditionIngredient((ItemStack)stack))).withResultSlot(5, 121, 35).build();
    }

    private List<ItemStack> getRelevantItems() {
        return List.of(this.inputSlots.getItem(0), this.inputSlots.getItem(1), this.inputSlots.getItem(2), this.inputSlots.getItem(3), this.inputSlots.getItem(4));
    }

    private void shrinkStackInSlot(int pIndex) {
        ItemStack itemstack = this.inputSlots.getItem(pIndex);
        if (!itemstack.isEmpty()) {
            itemstack.shrink(1);
            this.inputSlots.setItem(pIndex, itemstack);
        }
    }

    public int getSlotToQuickMoveTo(@NotNull ItemStack pStack) {
        return this.recipes.stream().map(smithingRecipe -> ExtremeSmithingMenu.findSlotMatchingIngredient(smithingRecipe, pStack)).filter(Optional::isPresent).findFirst().orElse(Optional.of(List.of(Integer.valueOf(0)))).get().get(0);
    }

    private static Optional<List<Integer>> findSlotMatchingIngredient(SmithingRecipe pRecipe, ItemStack pStack) {
        if (pRecipe.isTemplateIngredient(pStack)) {
            return Optional.of(List.of(Integer.valueOf(0)));
        }
        if (pRecipe.isBaseIngredient(pStack)) {
            return Optional.of(List.of(Integer.valueOf(1)));
        }
        return pRecipe.isAdditionIngredient(pStack) ? Optional.of(List.of(Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4))) : Optional.empty();
    }

    public boolean canTakeItemForPickAll(@NotNull ItemStack pStack, Slot pSlot) {
        return pSlot.container != this.resultSlots && super.canTakeItemForPickAll(pStack, pSlot);
    }

    public boolean canMoveIntoInputSlots(@NotNull ItemStack pStack) {
        return this.recipes.stream().map(smithingRecipe -> ExtremeSmithingMenu.findSlotMatchingIngredient(smithingRecipe, pStack)).anyMatch(Optional::isPresent);
    }
}

