/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.menu;

import committee.nova.mods.avaritia.Const;
import committee.nova.mods.avaritia.api.common.slot.FakeSlot;
import committee.nova.mods.avaritia.api.util.game.CraftingRecipeGridIndexGetter;
import committee.nova.mods.avaritia.api.util.math.InvItemCounter;
import committee.nova.mods.avaritia.common.net.chest.C2SInfinityChestActionPack;
import committee.nova.mods.avaritia.common.tile.InfinityChestTile;
import committee.nova.mods.avaritia.core.chest.ChestHandler;
import committee.nova.mods.avaritia.core.chest.ClientChestManager;
import committee.nova.mods.avaritia.core.chest.InfinityChestContainer;
import committee.nova.mods.avaritia.core.chest.ServerChestHandler;
import committee.nova.mods.avaritia.init.handler.NetworkHandler;
import committee.nova.mods.avaritia.init.registry.ModMenus;
import committee.nova.mods.avaritia.util.StorageUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;

public class InfinityChestMenu
extends AbstractContainerMenu {
    public final ChestHandler channel;
    public final Player player;
    public final Level level;
    public final BlockPos blockPos;
    private final TransientCraftingContainer craftSlots = new TransientCraftingContainer((AbstractContainerMenu)this, 3, 3);
    private final ResultContainer resultSlots = new ResultContainer();
    public InfinityChestTile chestTile;
    public InfinityChestContainer chestContainer = new InfinityChestContainer(this);
    public boolean LShifting = false;
    private CraftingRecipe lastCraftingRecipe = null;
    public final UUID owner;
    public boolean locked;
    public String filter;
    public byte sortType;
    public UUID channelID;

    public InfinityChestMenu(int containerId, Inventory playerInv, FriendlyByteBuf extraData) {
        super((MenuType)ModMenus.infinity_chest.get(), containerId);
        this.player = playerInv.player;
        this.level = playerInv.player.level();
        this.blockPos = extraData.readBlockPos();
        this.owner = extraData.readUUID();
        this.locked = extraData.readBoolean();
        this.filter = extraData.readUtf(64);
        this.sortType = extraData.readByte();
        this.channelID = extraData.readUUID();
        this.addSlots(playerInv.player, playerInv);
        this.chestContainer = new InfinityChestContainer(this);
        this.channel = ClientChestManager.getInstance().getChannel(this.chestContainer);
        for (int i = 0; i < 7; ++i) {
            for (int j = 0; j < 11; ++j) {
                this.addSlot(new FakeSlot((Container)this.chestContainer, i * 11 + j, 7 + j * 17, 17 + i * 17));
            }
        }
    }

    public InfinityChestMenu(int containerId, Player player, InfinityChestTile blockEntity) {
        super((MenuType)ModMenus.infinity_chest.get(), containerId);
        this.player = player;
        this.level = player.level();
        this.blockPos = blockEntity.getBlockPos();
        this.chestTile = blockEntity;
        this.owner = blockEntity.getOwner() == null ? player.getUUID() : blockEntity.getOwner();
        this.locked = blockEntity.isLocked();
        this.filter = blockEntity.getFilter();
        this.sortType = blockEntity.getSortType();
        this.channelID = blockEntity.getChannelID();
        this.channel = blockEntity.getChannel();
        if (!this.channel.isRemoved()) {
            ((ServerChestHandler)this.channel).addListener((ServerPlayer)player);
        }
        this.addSlots(player, player.getInventory());
    }

    @ParametersAreNonnullByDefault
    public boolean clickMenuButton(Player pPlayer, int pId) {
        switch (pId) {
            case 0: {
                if (!this.owner.equals(this.player.getUUID())) break;
                this.locked = !this.locked;
                this.chestTile.setLocked(this.locked);
                if (!this.locked) break;
                this.saveBlock();
                break;
            }
            case 2: {
                this.nextSort();
                break;
            }
            case 3: {
                this.reverseSort();
                break;
            }
            case 6: {
                this.craftToChannel(1);
                break;
            }
            case 7: {
                this.craftToChannel(8);
                break;
            }
            case 8: {
                this.craftToChannel(64);
                break;
            }
            case 9: {
                this.craftToChannel(512);
                break;
            }
            case 10: {
                this.craftToInventory(1);
                break;
            }
            case 11: {
                this.craftToInventory(8);
                break;
            }
            case 12: {
                this.craftToInventory(64);
                break;
            }
            case 13: {
                this.craftToInventory(512);
            }
        }
        return pId < 18;
    }

    public void action(int actionId, String id) {
        switch (actionId) {
            case 0: {
                this.onLeftClickDummySlot(id);
                break;
            }
            case 1: {
                this.onRightClickDummySlot(id);
                break;
            }
            case 2: {
                this.onLeftShiftDummySlot(id);
                break;
            }
            case 3: {
                this.onRightShiftDummySlot(id);
                break;
            }
            case 4: {
                this.tryThrowOneFromDummySlot(id);
                break;
            }
            case 5: {
                this.tryThrowStickFromDummySlot(id);
                break;
            }
            case 6: {
                this.onLeftDragDummySlot(id);
                break;
            }
            case 7: {
                this.onRightDragDummySlot(id);
                break;
            }
            case 8: {
                this.onCloneFormDummySlot(id);
                break;
            }
            case 9: {
                this.onDragCloneDummySlot(id);
            }
        }
    }

    public void onLeftClickDummySlot(String id) {
        ItemStack carried = this.getCarried();
        if (carried.isEmpty()) {
            if (id.equals("minecraft:air")) {
                return;
            }
            this.setCarried(this.channel.saveTakeItem(id, false));
        } else {
            if (carried.getCount() > 1) {
                this.channel.addItem(carried);
                return;
            }
            AtomicBoolean canal = new AtomicBoolean(false);
            carried.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(iItemHandler -> {
                if (!this.channel.storageItems.containsKey(id)) {
                    return;
                }
                int slots = iItemHandler.getSlots();
                for (int i = 0; i < slots; ++i) {
                    ItemStack remainingItem;
                    int remainingSlotSpace;
                    ItemStack tryInsertItem = new ItemStack((ItemLike)StorageUtils.getItem(id));
                    if (!ItemStack.isSameItemSameTags((ItemStack)tryInsertItem, (ItemStack)iItemHandler.getStackInSlot(i)) && !iItemHandler.getStackInSlot(i).isEmpty() || (remainingSlotSpace = iItemHandler.getSlotLimit(i) - iItemHandler.getStackInSlot(i).getCount()) <= 0) continue;
                    int transmitAmount = (int)Math.min(Integer.MAX_VALUE, this.channel.storageItems.get(id) / 2L);
                    transmitAmount = Math.max(transmitAmount, 64000);
                    transmitAmount = (int)Math.min((long)transmitAmount, this.channel.storageItems.get(id));
                    int markAmount = transmitAmount = Math.min(transmitAmount, remainingSlotSpace);
                    tryInsertItem.setCount(transmitAmount);
                    for (int j = 0; j < 64 && (transmitAmount = (remainingItem = iItemHandler.insertItem(i, tryInsertItem, false)).getCount()) > 0; ++j) {
                        tryInsertItem.setCount(transmitAmount);
                    }
                    if ((markAmount -= transmitAmount) <= 0) continue;
                    this.channel.takeItem(id, markAmount);
                    canal.set(true);
                    return;
                }
            });
            if (canal.get()) {
                return;
            }
            this.channel.addItem(carried);
        }
    }

    public void onRightClickDummySlot(String id) {
        ItemStack carried = this.getCarried();
        if (carried.isEmpty()) {
            if (id.equals("minecraft:air")) {
                return;
            }
            this.setCarried(this.channel.saveTakeItem(id, true));
        } else {
            if (carried.getCount() > 1) {
                this.channel.fillItemStack(carried, -1);
                return;
            }
            AtomicBoolean canal = new AtomicBoolean(false);
            carried.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(iItemHandler -> {
                int slots = iItemHandler.getSlots();
                for (int i = 0; i < slots; ++i) {
                    int maxExtractAmount;
                    ItemStack itemStack = iItemHandler.getStackInSlot(i);
                    if (itemStack.isEmpty() || itemStack.hasTag() || (itemStack = iItemHandler.extractItem(i, maxExtractAmount = this.channel.canStorageAmount(itemStack), false)).isEmpty()) continue;
                    this.channel.addItem(itemStack);
                    canal.set(true);
                    break;
                }
            });
            if (canal.get()) {
                return;
            }
            this.channel.addItem(carried);
        }
    }

    public void onLeftShiftDummySlot(String id) {
        if (id.equals("minecraft:air")) {
            return;
        }
        ItemStack carried = this.getCarried();
        if (carried.isEmpty()) {
            if (!this.channel.storageItems.containsKey(id)) {
                return;
            }
            ItemStack itemStack = new ItemStack((ItemLike)StorageUtils.getItem(id));
            itemStack.setCount((int)Math.min((long)itemStack.getMaxStackSize(), this.channel.storageItems.get(id)));
            int i = itemStack.getCount();
            this.moveItemStackTo(itemStack, 41, 50, false);
            if ((i -= itemStack.getCount()) > 0) {
                itemStack.setCount(i);
                this.channel.removeItem(itemStack);
            }
        } else {
            if (carried.getCount() > 1) {
                this.channel.fillItemStack(carried, -1);
                return;
            }
            AtomicBoolean canal = new AtomicBoolean(false);
            carried.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(iItemHandler -> {
                if (!this.channel.storageItems.containsKey(id)) {
                    return;
                }
                int transmitAmount = (int)Math.min(Integer.MAX_VALUE, this.channel.storageItems.get(id) / 2L);
                transmitAmount = Math.max(transmitAmount, 64000);
                int markAmount = transmitAmount = (int)Math.min((long)transmitAmount, this.channel.storageItems.get(id));
                ItemStack tryInsertItem = new ItemStack((ItemLike)StorageUtils.getItem(id), transmitAmount);
                int slots = iItemHandler.getSlots();
                for (int i = 0; i < slots; ++i) {
                    ItemStack remainingItem;
                    for (int j = 0; j < 64 && (remainingItem = iItemHandler.insertItem(i, tryInsertItem, false)).getCount() != transmitAmount && (transmitAmount = remainingItem.getCount()) > 0; ++j) {
                        tryInsertItem.setCount(transmitAmount);
                    }
                }
                if ((markAmount -= transmitAmount) > 0) {
                    this.channel.takeItem(id, markAmount);
                    canal.set(true);
                }
            });
            if (canal.get()) {
                return;
            }
            this.channel.addItem(carried);
        }
    }

    public void onRightShiftDummySlot(String id) {
        ItemStack carried = this.getCarried();
        if (carried.isEmpty()) {
            if (id.equals("minecraft:air")) {
                return;
            }
            if (!this.channel.storageItems.containsKey(id)) {
                return;
            }
            ItemStack itemStack = new ItemStack((ItemLike)StorageUtils.getItem(id));
            this.moveItemStackTo(itemStack, 41, 50, false);
            if (itemStack.isEmpty()) {
                this.channel.takeItem(id, 1);
            }
        } else {
            if (carried.getCount() > 1) {
                this.channel.fillItemStack(carried, -1);
                return;
            }
            AtomicBoolean canal = new AtomicBoolean(false);
            carried.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(iItemHandler -> {
                int slots = iItemHandler.getSlots();
                for (int i = 0; i < slots; ++i) {
                    int maxExtractAmount;
                    ItemStack itemStack = iItemHandler.getStackInSlot(i);
                    if (itemStack.isEmpty() || itemStack.hasTag() || (itemStack = iItemHandler.extractItem(i, maxExtractAmount = this.channel.canStorageAmount(itemStack), false)).isEmpty()) continue;
                    this.channel.addItem(itemStack);
                    canal.set(true);
                }
            });
            if (canal.get()) {
                return;
            }
            this.channel.addItem(carried);
        }
    }

    public void tryThrowOneFromDummySlot(String id) {
        if (id.equals("minecraft:air")) {
            return;
        }
        if (!this.channel.storageItems.containsKey(id)) {
            return;
        }
        ItemStack itemStack = this.channel.takeItem(id, 1);
        this.player.drop(itemStack, false);
    }

    public void tryThrowStickFromDummySlot(String id) {
        if (id.equals("minecraft:air")) {
            return;
        }
        if (!this.channel.storageItems.containsKey(id)) {
            return;
        }
        ItemStack itemStack = this.channel.saveTakeItem(id, false);
        this.player.drop(itemStack, false);
    }

    public void onLeftDragDummySlot(String id) {
        ItemStack carried = this.getCarried();
        if (carried.isEmpty()) {
            return;
        }
        this.channel.addItem(carried);
    }

    public void onRightDragDummySlot(String id) {
        ItemStack carried = this.getCarried();
        if (carried.isEmpty()) {
            return;
        }
        this.channel.fillItemStack(carried, -1);
    }

    public void onCloneFormDummySlot(String id) {
        if (id.equals("minecraft:air") || !this.player.isCreative()) {
            return;
        }
        this.channel.addItem(id, Long.max(this.channel.getRealItemAmount(id), 64L));
    }

    public void onDragCloneDummySlot(String id) {
        ItemStack carried = this.getCarried();
        if (carried.isEmpty()) {
            return;
        }
        ItemStack itemStack = carried.copy();
        itemStack.setCount(itemStack.getMaxStackSize());
        this.channel.addItem(itemStack);
    }

    private void addSlots(Player player, Inventory playerInv) {
        for (int l = 0; l < 9; ++l) {
            this.addSlot(new Slot((Container)playerInv, l, 24 + l * 17, 258));
        }
        for (int k = 0; k < 3; ++k) {
            for (int i1 = 0; i1 < 9; ++i1) {
                this.addSlot(new Slot((Container)playerInv, i1 + k * 9 + 9, 24 + i1 * 17, 203 + k * 17));
            }
        }
        this.addSlot(this.getArmorSlot(player, playerInv, EquipmentSlot.HEAD, 39, 7, 139));
        this.addSlot(this.getArmorSlot(player, playerInv, EquipmentSlot.CHEST, 38, 7, 156));
        this.addSlot(this.getArmorSlot(player, playerInv, EquipmentSlot.LEGS, 37, 58, 139));
        this.addSlot(this.getArmorSlot(player, playerInv, EquipmentSlot.FEET, 36, 58, 156));
        this.addSlot(new Slot((Container)playerInv, 40, 7, 173));
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.addSlot(new Slot((Container)this.craftSlots, j + i * 3, 92 + j * 17, 139 + i * 17));
            }
        }
        this.addSlot((Slot)new ResultSlot(player, (CraftingContainer)this.craftSlots, (Container)this.resultSlots, 0, 161, 156));
    }

    private Slot getArmorSlot(final Player player, Inventory inventory, final EquipmentSlot equipmentslot, int slotId, int x, int y) {
        return new Slot((Container)inventory, slotId, x, y){

            @ParametersAreNonnullByDefault
            public void set(ItemStack itemStack) {
                ItemStack itemstack = this.getItem();
                super.set(itemStack);
                player.onEquipItem(equipmentslot, itemstack, itemStack);
            }

            public int getMaxStackSize() {
                return 1;
            }

            @ParametersAreNonnullByDefault
            public boolean mayPlace(ItemStack itemStack) {
                return itemStack.canEquip(equipmentslot, (Entity)player);
            }

            @ParametersAreNonnullByDefault
            public boolean mayPickup(Player player1) {
                ItemStack itemstack = this.getItem();
                return (itemstack.isEmpty() || player1.isCreative() || !EnchantmentHelper.hasBindingCurse((ItemStack)itemstack)) && super.mayPickup(player1);
            }
        };
    }

    protected void clearCraftSlots() {
        for (int j = 0; j < this.craftSlots.getContainerSize(); ++j) {
            ItemStack itemStack = this.craftSlots.removeItemNoUpdate(j);
            this.channel.addItem(itemStack);
            if (itemStack.isEmpty()) continue;
            this.pushToInventory(itemStack);
        }
    }

    public void nextSort() {
        this.sortType = (byte)(this.sortType + 2);
        if (this.sortType > 7) {
            this.sortType = (byte)(this.sortType % 8);
        }
        if (this.level.isClientSide) {
            this.chestContainer.refreshContainer(true);
        }
    }

    public void reverseSort() {
        this.sortType = this.sortType % 2 == 0 ? (byte)(this.sortType + 1) : (byte)(this.sortType - 1);
        if (this.level.isClientSide) {
            this.chestContainer.refreshContainer(true);
        }
    }

    private void saveBlock() {
        this.chestTile.setFilter(this.filter);
        this.chestTile.setSortType(this.sortType);
    }

    @ParametersAreNonnullByDefault
    public void clicked(int pSlotId, int pButton, ClickType pClickType, Player pPlayer) {
        if (pSlotId >= 51) {
            String object = pSlotId - 51 < this.chestContainer.viewingObject.size() ? this.chestContainer.viewingObject.get(pSlotId - 51) : "minecraft:air";
            block0 : switch (pButton) {
                case 0: {
                    switch (pClickType) {
                        case QUICK_MOVE: {
                            NetworkHandler.CHANNEL.send(PacketDistributor.SERVER.noArg(), (Object)new C2SInfinityChestActionPack(this.containerId, 2, object));
                            this.onLeftShiftDummySlot(object);
                            break block0;
                        }
                        case PICKUP: {
                            NetworkHandler.CHANNEL.send(PacketDistributor.SERVER.noArg(), (Object)new C2SInfinityChestActionPack(this.containerId, 0, object));
                            this.onLeftClickDummySlot(object);
                            break block0;
                        }
                        case THROW: {
                            NetworkHandler.CHANNEL.send(PacketDistributor.SERVER.noArg(), (Object)new C2SInfinityChestActionPack(this.containerId, 4, object));
                            this.tryThrowOneFromDummySlot(object);
                        }
                    }
                    break;
                }
                case 1: {
                    switch (pClickType) {
                        case PICKUP: {
                            NetworkHandler.CHANNEL.send(PacketDistributor.SERVER.noArg(), (Object)new C2SInfinityChestActionPack(this.containerId, 1, object));
                            this.onRightClickDummySlot(object);
                            break block0;
                        }
                        case QUICK_MOVE: {
                            NetworkHandler.CHANNEL.send(PacketDistributor.SERVER.noArg(), (Object)new C2SInfinityChestActionPack(this.containerId, 3, object));
                            this.onRightShiftDummySlot(object);
                            break block0;
                        }
                        case QUICK_CRAFT: {
                            NetworkHandler.CHANNEL.send(PacketDistributor.SERVER.noArg(), (Object)new C2SInfinityChestActionPack(this.containerId, 6, object));
                            this.onLeftDragDummySlot(object);
                            break block0;
                        }
                        case THROW: {
                            NetworkHandler.CHANNEL.send(PacketDistributor.SERVER.noArg(), (Object)new C2SInfinityChestActionPack(this.containerId, 5, object));
                            this.tryThrowStickFromDummySlot(object);
                        }
                    }
                    break;
                }
                case 4: {
                    if (pClickType != ClickType.CLONE) break;
                    if (object.equals("minecraft:air")) {
                        return;
                    }
                    NetworkHandler.CHANNEL.send(PacketDistributor.SERVER.noArg(), (Object)new C2SInfinityChestActionPack(this.containerId, 8, object));
                    this.onCloneFormDummySlot(object);
                    break;
                }
                case 5: {
                    if (pClickType != ClickType.QUICK_CRAFT) break;
                    NetworkHandler.CHANNEL.send(PacketDistributor.SERVER.noArg(), (Object)new C2SInfinityChestActionPack(this.containerId, 7, object));
                    this.onRightDragDummySlot(object);
                    break;
                }
                case 9: {
                    if (pClickType != ClickType.QUICK_CRAFT) break;
                    NetworkHandler.CHANNEL.send(PacketDistributor.SERVER.noArg(), (Object)new C2SInfinityChestActionPack(this.containerId, 9, object));
                    this.onDragCloneDummySlot(object);
                }
            }
        } else if (pSlotId >= 41 && pSlotId <= 49 && pClickType.equals((Object)ClickType.QUICK_MOVE)) {
            ItemStack itemStack = ((Slot)this.slots.get(pSlotId)).getItem();
            if (pButton == 0) {
                this.moveItemStackTo(itemStack, 9, 36, false);
                if (!itemStack.isEmpty()) {
                    this.moveItemStackTo(itemStack, 0, 9, false);
                }
                this.slotsChanged((Container)this.craftSlots);
            } else if (pButton == 1) {
                this.channel.addItem(itemStack);
                this.slotsChanged((Container)this.craftSlots);
            } else {
                super.clicked(pSlotId, pButton, pClickType, pPlayer);
            }
        } else {
            super.clicked(pSlotId, pButton, pClickType, pPlayer);
        }
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public ItemStack quickMoveStack(Player player, int slotId) {
        ItemStack itemStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(slotId);
        if (slot.hasItem()) {
            ItemStack movingStack = slot.getItem();
            itemStack = movingStack.copy();
            if (slotId >= 0 && slotId <= 35) {
                if (!this.moveItemStackTo(movingStack, 41, 50, false)) {
                    return ItemStack.EMPTY;
                }
            } else if (slotId == 50) {
                movingStack.getItem().onCraftedBy(movingStack, this.level, player);
                if (!this.moveItemStackTo(movingStack, 0, 36, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(movingStack, itemStack);
            } else if (slotId >= 41 && slotId <= 49) {
                if (!this.moveItemStackTo(movingStack, 0, 36, false)) {
                    return ItemStack.EMPTY;
                }
            } else {
                Const.LOGGER.warn("Ohh! Who trigger the quickMoveStack() when slotId >= 51 in server side ?");
            }
            if (movingStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (movingStack.getCount() == itemStack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, movingStack);
            if (slotId == 50) {
                player.drop(movingStack, false);
            }
        }
        return itemStack;
    }

    @ParametersAreNonnullByDefault
    public boolean canTakeItemForPickAll(ItemStack itemStack, Slot slot) {
        return slot.index <= 49;
    }

    @ParametersAreNonnullByDefault
    public boolean stillValid(Player player) {
        return !this.chestTile.isRemoved() && player.distanceToSqr((double)this.blockPos.getX() + 0.5, (double)this.blockPos.getY() + 0.5, (double)this.blockPos.getZ() + 0.5) <= 32.0;
    }

    @ParametersAreNonnullByDefault
    public void removed(Player player) {
        if (this.level.isClientSide) {
            return;
        }
        if (!this.channel.isRemoved()) {
            ((ServerChestHandler)this.channel).removeListener((ServerPlayer)player);
        }
        super.removed(player);
        this.clearCraftSlots();
        if (!this.chestTile.isLocked()) {
            this.saveBlock();
        }
    }

    @ParametersAreNonnullByDefault
    public void slotsChanged(Container container) {
        if (this.level.isClientSide) {
            return;
        }
        if (this.lastCraftingRecipe != null && this.lastCraftingRecipe.matches((Container)this.craftSlots, this.level)) {
            this.resultSlots.setRecipeUsed(this.level, (ServerPlayer)this.player, (Recipe)this.lastCraftingRecipe);
            this.resultSlots.setItem(0, this.lastCraftingRecipe.assemble((Container)this.craftSlots, this.level.registryAccess()));
            return;
        }
        Optional optional = this.level.getServer().getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (Container)this.craftSlots, this.level);
        if (optional.isPresent()) {
            CraftingRecipe recipe = (CraftingRecipe)optional.get();
            if (this.resultSlots.setRecipeUsed(this.level, (ServerPlayer)this.player, (Recipe)recipe)) {
                this.resultSlots.setItem(0, recipe.assemble((Container)this.craftSlots, this.level.registryAccess()));
            }
        } else {
            this.resultSlots.setItem(0, ItemStack.EMPTY);
        }
    }

    public void receivedRecipe(String recipeId, boolean maxTransfer) {
        Optional optional1;
        int i;
        if (this.level.getServer() == null) {
            return;
        }
        RecipeManager manager = this.level.getServer().getRecipeManager();
        Optional optional = manager.byKey(new ResourceLocation(recipeId));
        if (optional.isEmpty()) {
            return;
        }
        Inventory inventory = this.player.getInventory();
        Object t = optional.get();
        if (!(t instanceof CraftingRecipe)) {
            return;
        }
        CraftingRecipe craftingRecipe = (CraftingRecipe)t;
        this.clearCraftSlots();
        this.slotsChanged((Container)this.craftSlots);
        NonNullList ingredients = craftingRecipe.getIngredients();
        HashMap<Item, Long> itemAmount = new HashMap<Item, Long>();
        HashMap<Item, Integer> itemP = new HashMap<Item, Integer>();
        InvItemCounter invItemCounter = null;
        ArrayList<Object> itemChosen = new ArrayList<Object>();
        for (Ingredient ingredient : ingredients) {
            if (ingredient.isEmpty()) {
                itemChosen.add(null);
                continue;
            }
            ItemStack[] stacks = ingredient.getItems();
            long markCount = 0L;
            Item markItem = null;
            boolean hasNbtItem = false;
            for (ItemStack stack : stacks) {
                long count;
                if (stack.hasTag()) {
                    hasNbtItem = true;
                    continue;
                }
                Item item = stack.getItem();
                if (itemAmount.containsKey(item)) {
                    count = (Long)itemAmount.get(item);
                } else {
                    count = this.channel.getRealItemAmount(StorageUtils.getItemId(item));
                    if (count < 576L) {
                        if (invItemCounter == null) {
                            invItemCounter = new InvItemCounter(inventory);
                        }
                        count += (long)invItemCounter.getCount(item);
                    }
                    itemAmount.put(item, count);
                }
                if (count > markCount) {
                    markCount = count;
                    markItem = item;
                }
                if (itemP.containsKey(item)) {
                    itemP.replace(item, (Integer)itemP.get(item) + 1);
                    continue;
                }
                itemP.put(item, 1);
            }
            if (markItem == null && hasNbtItem) {
                itemChosen.add(Items.AIR);
                continue;
            }
            itemChosen.add(markItem);
        }
        CraftingRecipeGridIndexGetter recipeSlotIndexGetter = new CraftingRecipeGridIndexGetter(craftingRecipe);
        block2: for (i = 0; i < itemChosen.size(); ++i) {
            int gridIndex = recipeSlotIndexGetter.get();
            Item item = (Item)itemChosen.get(i);
            if (item == null) continue;
            if (item.equals(Items.AIR)) {
                Ingredient ingredient = (Ingredient)ingredients.get(i);
                for (ItemStack itemStack : ingredient.getItems()) {
                    if (!itemStack.hasTag()) continue;
                    if (invItemCounter == null) {
                        invItemCounter = new InvItemCounter(inventory);
                    }
                    Integer[] itemIndex = invItemCounter.getNbtItemIndex();
                    boolean flag = false;
                    for (Integer index : itemIndex) {
                        ItemStack stack2 = inventory.getItem(index.intValue());
                        if (stack2.isEmpty() || !ItemStack.isSameItemSameTags((ItemStack)itemStack, (ItemStack)stack2)) continue;
                        if (stack2.getCount() == 1) {
                            this.craftSlots.setItem(gridIndex, stack2);
                            inventory.setItem(index.intValue(), ItemStack.EMPTY);
                        } else {
                            ItemStack newStack = stack2.copy();
                            newStack.setCount(1);
                            this.craftSlots.setItem(gridIndex, newStack);
                            stack2.grow(-1);
                        }
                        flag = true;
                        break;
                    }
                    if (flag) continue block2;
                }
                continue;
            }
            if (this.channel.getRealItemAmount(StorageUtils.getItemId(item)) > 0L) {
                this.craftSlots.setItem(gridIndex, new ItemStack((ItemLike)item));
                this.channel.removeItem(StorageUtils.getItemId(item), 1L);
                continue;
            }
            if (invItemCounter == null) {
                invItemCounter = new InvItemCounter(inventory);
            }
            Integer[] itemIndex = invItemCounter.getNoNbtItemIndex();
            for (ItemStack itemStack : itemIndex) {
                ItemStack stack = inventory.getItem(itemStack.intValue());
                if (stack.isEmpty() || !stack.getItem().equals(item)) continue;
                if (stack.getCount() == 1) {
                    this.craftSlots.setItem(gridIndex, stack);
                    inventory.setItem(itemStack.intValue(), ItemStack.EMPTY);
                    continue block2;
                }
                this.craftSlots.setItem(gridIndex, new ItemStack((ItemLike)item));
                stack.grow(-1);
                continue block2;
            }
        }
        if (!craftingRecipe.matches((Container)this.craftSlots, this.level)) {
            return;
        }
        if (maxTransfer) {
            block6: for (i = 0; i < 9; ++i) {
                ItemStack itemStack = this.craftSlots.getItem(i);
                if (itemStack.isEmpty() || itemStack.hasTag() || itemStack.getMaxStackSize() == 1) continue;
                Item item = itemStack.getItem();
                String itemId = StorageUtils.getItemId(item);
                long amount = itemAmount.getOrDefault(item, 0L);
                int p = itemP.getOrDefault(item, 0);
                int n = (int)Long.min(itemStack.getMaxStackSize(), amount / (long)p);
                if (n < 2) continue;
                int channelHas = this.channel.getItemAmount(itemId);
                if (channelHas >= n) {
                    this.channel.removeItem(itemId, n - itemStack.getCount());
                    itemStack.setCount(n);
                    continue;
                }
                if (channelHas > 0) {
                    this.channel.removeItem(itemId, channelHas);
                    itemStack.setCount(itemStack.getCount() + channelHas);
                }
                if (invItemCounter == null) {
                    invItemCounter = new InvItemCounter(inventory);
                }
                Integer[] itemIndex = invItemCounter.getNoNbtItemIndex();
                for (Integer index : itemIndex) {
                    ItemStack invStack = inventory.getItem(index.intValue());
                    if (invStack.isEmpty() || invStack.hasTag() || !item.equals(invStack.getItem())) continue;
                    int invCount = invStack.getCount();
                    if (itemStack.getCount() + invCount > n) {
                        int j = itemStack.getCount() + invCount - n;
                        invStack.setCount(j);
                        itemStack.setCount(n);
                        continue;
                    }
                    inventory.setItem(index.intValue(), ItemStack.EMPTY);
                    itemStack.grow(invCount);
                    if (itemStack.getCount() >= n) continue block6;
                }
            }
        }
        if ((optional1 = manager.getRecipeFor(RecipeType.CRAFTING, (Container)this.craftSlots, this.level)).isPresent()) {
            CraftingRecipe currentRecipe = (CraftingRecipe)optional1.get();
            if (currentRecipe != craftingRecipe && craftingRecipe.matches((Container)this.craftSlots, this.level) && this.resultSlots.setRecipeUsed(this.level, (ServerPlayer)this.player, (Recipe)craftingRecipe)) {
                this.lastCraftingRecipe = craftingRecipe;
                this.resultSlots.setItem(0, craftingRecipe.assemble((Container)this.craftSlots, this.level.registryAccess()));
            }
        } else {
            this.resultSlots.setItem(0, ItemStack.EMPTY);
        }
    }

    public void receivedRecipe(Map<String, Integer> itemNeed) {
        itemNeed.forEach((s, integer) -> {
            ItemStack itemStack = this.channel.takeItem((String)s, (int)integer);
            if (itemStack.isEmpty()) {
                return;
            }
            this.savePushToInventory(itemStack);
        });
    }

    private void craftToChannel(int max) {
        ItemStack resultItem = this.resultSlots.getItem(0).copy();
        if (resultItem.isEmpty() || resultItem.hasTag()) {
            return;
        }
        Recipe recipe = this.resultSlots.getRecipeUsed();
        if (recipe instanceof CraftingRecipe) {
            int maxTry = max % resultItem.getCount() > 0 ? max / resultItem.getCount() + 1 : max / resultItem.getCount();
            int count = resultItem.getCount() * this.doCraft(resultItem, maxTry);
            long notInCount = (long)count - this.channel.addItem(StorageUtils.getItemId(resultItem.getItem()), count);
            if (notInCount > 0L) {
                resultItem.setCount((int)notInCount);
                this.pushToInventory(resultItem);
            }
        }
    }

    private void craftToInventory(int max) {
        ItemStack resultItem = this.resultSlots.getItem(0).copy();
        if (resultItem.isEmpty()) {
            return;
        }
        Recipe recipe = this.resultSlots.getRecipeUsed();
        if (recipe instanceof CraftingRecipe) {
            int maxTry1 = max % resultItem.getCount() > 0 ? max / resultItem.getCount() + 1 : max / resultItem.getCount();
            int maxSpace = 0;
            int maxStackSize = resultItem.getMaxStackSize();
            for (int i = 0; i < 36; ++i) {
                ItemStack slotStack = this.player.getInventory().getItem(i);
                if (slotStack.isEmpty()) {
                    maxSpace += maxStackSize;
                    continue;
                }
                if (maxStackSize <= 1 || !ItemStack.isSameItemSameTags((ItemStack)resultItem, (ItemStack)slotStack)) continue;
                maxSpace = maxSpace + maxStackSize - slotStack.getCount();
            }
            if (maxSpace <= 0) {
                return;
            }
            int maxTry2 = maxSpace / resultItem.getCount();
            int maxTry = Integer.min(maxTry1, maxTry2);
            int count = resultItem.getCount() * this.doCraft(resultItem, maxTry);
            resultItem.setCount(count);
            this.savePushToInventory(resultItem);
        }
    }

    private void craftAndDrop(int max) {
        ItemStack resultItem = this.resultSlots.getItem(0).copy();
        if (resultItem.isEmpty()) {
            return;
        }
        Recipe recipe = this.resultSlots.getRecipeUsed();
        if (recipe instanceof CraftingRecipe) {
            int maxTry = max % resultItem.getCount() > 0 ? max / resultItem.getCount() + 1 : max / resultItem.getCount();
            int count = resultItem.getCount() * this.doCraft(resultItem, maxTry);
            resultItem.setCount(count);
            this.player.drop(resultItem, false);
        }
    }

    private int doCraft(ItemStack resultItem, int maxTry) {
        int remainingCraftTry = maxTry - this.tryFastCraft(maxTry);
        if (remainingCraftTry > 0) {
            ArrayList<ItemStack> beforeItems = new ArrayList<ItemStack>();
            for (int i = 0; i < 9; ++i) {
                beforeItems.add(i, this.craftSlots.getItem(i).copy());
            }
            InvItemCounter invItemCounter = null;
            while (remainingCraftTry > 0) {
                if (remainingCraftTry > 1) {
                    for (int i = 0; i < 9; ++i) {
                        Integer[] noNbtItemIndex;
                        ItemStack craftingStack = this.craftSlots.getItem(i);
                        int maxStackSize = craftingStack.getMaxStackSize();
                        if (craftingStack.isEmpty() || maxStackSize == 1 || craftingStack.getCount() >= 2 || craftingStack.hasTag()) continue;
                        int channelAmount = this.channel.getItemAmount(StorageUtils.getItemId(craftingStack.getItem()));
                        if (channelAmount >= maxStackSize - 1) {
                            craftingStack.setCount(maxStackSize);
                            this.channel.removeItem(StorageUtils.getItemId(craftingStack.getItem()), maxStackSize - 1);
                            continue;
                        }
                        if (channelAmount > 0) {
                            this.channel.removeItem(StorageUtils.getItemId(craftingStack.getItem()), channelAmount);
                            craftingStack.setCount(channelAmount + 1);
                        }
                        if (invItemCounter == null) {
                            invItemCounter = new InvItemCounter(this.player.getInventory());
                        }
                        if (invItemCounter.getCount(craftingStack.getItem()) <= 0) continue;
                        for (Integer integer : noNbtItemIndex = invItemCounter.getNoNbtItemIndex()) {
                            this.applyFromInvIndex(craftingStack, integer);
                        }
                    }
                }
                ((Slot)this.slots.get(50)).onTake(this.player, resultItem);
                --remainingCraftTry;
                if (this.isSameResul(resultItem) || this.fixItems(resultItem, beforeItems)) continue;
                break;
            }
        }
        return maxTry - remainingCraftTry;
    }

    private int tryFastCraft(int maxTry) {
        HashMap<Item, Integer> itemMap = new HashMap<Item, Integer>();
        boolean canFastCraft = true;
        for (int i = 0; i < 9; ++i) {
            ItemStack slotStack = this.craftSlots.getItem(i);
            if (slotStack.isEmpty()) continue;
            if (slotStack.hasTag() || slotStack.hasCraftingRemainingItem()) {
                canFastCraft = false;
                break;
            }
            if (itemMap.containsKey(slotStack.getItem())) {
                itemMap.replace(slotStack.getItem(), (Integer)itemMap.get(slotStack.getItem()) + 1);
                continue;
            }
            itemMap.put(slotStack.getItem(), 1);
        }
        if (canFastCraft) {
            Integer integer;
            Item item;
            int canTry = maxTry;
            for (Map.Entry entry : itemMap.entrySet()) {
                item = (Item)entry.getKey();
                integer = (Integer)entry.getValue();
                int needAmount = integer * canTry;
                int has = this.channel.getItemAmount(StorageUtils.getItemId(item));
                if (has >= needAmount || (canTry = has / integer) != 0) continue;
                break;
            }
            if (canTry > 0) {
                for (Map.Entry entry : itemMap.entrySet()) {
                    item = (Item)entry.getKey();
                    integer = (Integer)entry.getValue();
                    this.channel.removeItem(StorageUtils.getItemId(item), (long)integer.intValue() * (long)canTry);
                }
            }
            return canTry;
        }
        return 0;
    }

    private boolean fixItems(ItemStack resultItem, ArrayList<ItemStack> beforeItems) {
        for (int i = 0; i < 9; ++i) {
            ItemStack needStack;
            ItemStack craftingStack = this.craftSlots.getItem(i);
            if (ItemStack.isSameItemSameTags((ItemStack)craftingStack, (ItemStack)(needStack = beforeItems.get(i)))) continue;
            if (!craftingStack.isEmpty()) {
                this.channel.addItem(craftingStack);
                if (!craftingStack.isEmpty()) {
                    this.moveItemStackTo(craftingStack, 9, 36, false);
                }
                if (!craftingStack.isEmpty()) {
                    this.moveItemStackTo(craftingStack, 0, 9, false);
                }
                if (!craftingStack.isEmpty()) {
                    return false;
                }
            }
            if (!needStack.isEmpty()) {
                if (needStack.hasTag()) {
                    this.moveSameItemToCraftingSlot(i, needStack);
                } else {
                    int channelHas = this.channel.getItemAmount(StorageUtils.getItemId(needStack.getItem()));
                    if (channelHas >= needStack.getMaxStackSize()) {
                        this.craftSlots.setItem(i, this.channel.takeItem(StorageUtils.getItemId(needStack.getItem()), needStack.getMaxStackSize()));
                    } else if (channelHas == 0) {
                        this.moveSameItemToCraftingSlot(i, needStack);
                    } else {
                        this.craftSlots.setItem(i, this.channel.takeItem(StorageUtils.getItemId(needStack.getItem()), channelHas));
                        this.fillStackFromInventory(this.craftSlots.getItem(i));
                    }
                }
            }
            if (!this.isSameResul(resultItem)) continue;
            return true;
        }
        if (!this.isSameResul(resultItem)) {
            int i;
            ArrayList itemMark = new ArrayList();
            ArrayList<ItemStack> itemAmount = new ArrayList<ItemStack>();
            beforeItems.forEach(beforeItem -> {
                if (beforeItem.isEmpty()) {
                    return;
                }
                if (itemMark.size() == 0) {
                    ItemStack inItem = beforeItem.copy();
                    inItem.setCount(1);
                    itemMark.add(inItem);
                } else {
                    boolean flag = true;
                    for (ItemStack itemStack : itemMark) {
                        if (!ItemStack.isSameItemSameTags((ItemStack)beforeItem, (ItemStack)itemStack)) continue;
                        itemStack.setCount(itemStack.getCount() + 1);
                        flag = false;
                        break;
                    }
                    if (flag) {
                        ItemStack inItem = beforeItem.copy();
                        inItem.setCount(1);
                        itemMark.add(inItem);
                    }
                }
            });
            for (i = 0; i < 9; ++i) {
                ItemStack slotItem = this.craftSlots.getItem(i);
                if (slotItem.isEmpty()) continue;
                if (itemAmount.size() == 0) {
                    ItemStack inItem = slotItem.copy();
                    itemAmount.add(inItem);
                } else {
                    boolean flag = true;
                    for (ItemStack itemStack : itemAmount) {
                        if (!ItemStack.isSameItemSameTags((ItemStack)slotItem, (ItemStack)itemStack)) continue;
                        itemStack.setCount(itemStack.getCount() + slotItem.getCount());
                        flag = false;
                        break;
                    }
                    if (flag) {
                        ItemStack inItem = slotItem.copy();
                        itemAmount.add(inItem);
                    }
                }
                this.craftSlots.setItem(i, ItemStack.EMPTY);
            }
            for (i = 0; i < 9; ++i) {
                ItemStack beforeStack = beforeItems.get(i);
                if (beforeStack.isEmpty()) continue;
                ItemStack p = ItemStack.EMPTY;
                ItemStack amount = ItemStack.EMPTY;
                for (ItemStack itemStack : itemMark) {
                    if (!ItemStack.isSameItemSameTags((ItemStack)beforeStack, (ItemStack)itemStack)) continue;
                    p = itemStack;
                    break;
                }
                for (ItemStack itemStack : itemAmount) {
                    if (!ItemStack.isSameItemSameTags((ItemStack)beforeStack, (ItemStack)itemStack)) continue;
                    amount = itemStack;
                    break;
                }
                if (p.isEmpty() || amount.isEmpty()) continue;
                ItemStack itemStack = beforeStack.copy();
                int count = amount.getCount() / p.getCount();
                itemStack.setCount(count);
                this.craftSlots.setItem(i, itemStack);
                amount.setCount(amount.getCount() - count);
                p.setCount(p.getCount() - 1);
            }
        }
        return this.isSameResul(resultItem);
    }

    private void pushToInventory(ItemStack itemStack) {
        this.moveItemStackTo(itemStack, 9, 36, false);
        if (!itemStack.isEmpty()) {
            this.moveItemStackTo(itemStack, 0, 9, false);
        }
        if (!itemStack.isEmpty()) {
            this.player.drop(itemStack, false);
        }
    }

    private void savePushToInventory(ItemStack itemStack) {
        int loops = itemStack.getCount() / itemStack.getMaxStackSize();
        for (int i = 0; i < loops; ++i) {
            ItemStack newStack = itemStack.copy();
            newStack.setCount(itemStack.getMaxStackSize());
            itemStack.setCount(itemStack.getCount() - itemStack.getMaxStackSize());
            this.pushToInventory(newStack);
        }
        if (itemStack.getCount() > 0) {
            this.pushToInventory(itemStack);
        }
    }

    private void fillStackFromInventory(ItemStack stack) {
        int i;
        int maxStackSize = stack.getMaxStackSize();
        for (i = 9; i < 36; ++i) {
            this.applyNbtFromInvIndex(stack, i);
            if (stack.getCount() >= maxStackSize) break;
        }
        if (stack.getCount() < maxStackSize) {
            for (i = 0; i < 9; ++i) {
                this.applyNbtFromInvIndex(stack, i);
                if (stack.getCount() >= maxStackSize) break;
            }
        }
    }

    private void applyFromInvIndex(ItemStack itemStack, int slotId) {
        if (itemStack.getItem().equals(this.player.getInventory().getItem(slotId).getItem())) {
            ItemStack otherStack = this.player.getInventory().getItem(slotId);
            int needAmount = itemStack.getMaxStackSize() - itemStack.getCount();
            if (otherStack.getCount() > needAmount) {
                itemStack.setCount(itemStack.getMaxStackSize());
                otherStack.setCount(otherStack.getCount() - needAmount);
            } else {
                itemStack.setCount(itemStack.getCount() + otherStack.getCount());
                this.player.getInventory().setItem(slotId, ItemStack.EMPTY);
            }
        }
    }

    private void applyNbtFromInvIndex(ItemStack itemStack, int slotId) {
        if (ItemStack.isSameItemSameTags((ItemStack)itemStack, (ItemStack)this.player.getInventory().getItem(slotId))) {
            ItemStack otherStack = this.player.getInventory().getItem(slotId);
            int needAmount = itemStack.getMaxStackSize() - itemStack.getCount();
            if (otherStack.getCount() > needAmount) {
                itemStack.setCount(itemStack.getMaxStackSize());
                otherStack.setCount(otherStack.getCount() - needAmount);
            } else {
                itemStack.setCount(itemStack.getCount() + otherStack.getCount());
                this.player.getInventory().setItem(slotId, ItemStack.EMPTY);
            }
        }
    }

    private void moveSameItemToCraftingSlot(int slotIndex, ItemStack stack) {
        ItemStack otherStack;
        int i;
        boolean flag = true;
        for (i = 9; i < 36; ++i) {
            otherStack = this.player.getInventory().getItem(i);
            if (!ItemStack.isSameItemSameTags((ItemStack)stack, (ItemStack)otherStack)) continue;
            this.craftSlots.setItem(slotIndex, otherStack);
            this.player.getInventory().setItem(i, ItemStack.EMPTY);
            flag = false;
            break;
        }
        if (flag) {
            for (i = 0; i < 9; ++i) {
                otherStack = this.player.getInventory().getItem(i);
                if (!ItemStack.isSameItemSameTags((ItemStack)stack, (ItemStack)otherStack)) continue;
                this.craftSlots.setItem(slotIndex, otherStack);
                this.player.getInventory().setItem(i, ItemStack.EMPTY);
                break;
            }
        }
    }

    private boolean isSameResul(ItemStack itemStack) {
        return ItemStack.isSameItemSameTags((ItemStack)this.resultSlots.getItem(0), (ItemStack)itemStack) && this.resultSlots.getItem(0).getCount() == itemStack.getCount();
    }
}

