/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.menu;

import committee.nova.mods.avaritia.Const;
import committee.nova.mods.avaritia.api.common.container.OffsetContainer;
import committee.nova.mods.avaritia.api.common.menu.BaseMenu;
import committee.nova.mods.avaritia.api.iface.IChangePage;
import committee.nova.mods.avaritia.api.util.InventoryUtils;
import committee.nova.mods.avaritia.common.wrappers.RingStorageWrapper;
import committee.nova.mods.avaritia.init.config.ModConfig;
import committee.nova.mods.avaritia.init.registry.ModItems;
import committee.nova.mods.avaritia.init.registry.ModMenus;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import org.jetbrains.annotations.NotNull;

public class _NeutronRingMenu
extends BaseMenu
implements IChangePage {
    public ItemStack ring = ItemStack.EMPTY;
    public int slot;
    private final Inventory playerInventory;
    private RingStorageWrapper storageWrapper;
    private DataSlot pageData;
    private ContainerData countData;
    private int mainInventorySize;
    private int swapIndex = -1;

    public _NeutronRingMenu(int id, Inventory playerInventory, FriendlyByteBuf buf) {
        this(id, playerInventory, buf.readInt(), OffsetContainer.dummy(54));
    }

    public _NeutronRingMenu(int id, Inventory playerInventory, int slot, OffsetContainer container) {
        super((MenuType)ModMenus.neutron_ring.get(), id, playerInventory);
        this.playerInventory = playerInventory;
        this.slot = slot;
        if (slot > -1) {
            this.ring = playerInventory.getItem(slot);
        }
        if (this.ring.isEmpty()) {
            this.ring = InventoryUtils.findItemInInv(playerInventory.player, stack -> stack.is((Item)ModItems.neutron_ring.get()), stack -> stack);
        }
        this.ring.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(itemHandler -> {
            this.storageWrapper = (RingStorageWrapper)itemHandler;
            this.pageData = this.storageWrapper.pageData;
            this.countData = this.storageWrapper.countData;
            this.mainInventorySize = playerInventory.items.size() + this.storageWrapper.getSlots();
        });
        int rows = (Integer)ModConfig.inventoryRows.get();
        int offset = (rows - 4) * 18;
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)container, j + i * 9, 8 + j * 18, 36 + i * 18));
            }
        }
        this.createInventorySlots(playerInventory, 0, 38 + offset);
        this.addDataSlot(this.pageData);
        int i2 = 0;
        while (i2 < this.countData.getCount()) {
            final int finalI = i2++;
            this.addDataSlot(new DataSlot(){
                private int lastKnownPage = -1;

                public int get() {
                    return _NeutronRingMenu.this.countData.get(finalI);
                }

                public void set(int value) {
                    _NeutronRingMenu.this.countData.set(finalI, value);
                }

                public boolean checkAndClearUpdateFlag() {
                    if (super.checkAndClearUpdateFlag()) {
                        return true;
                    }
                    int page = _NeutronRingMenu.this.storageWrapper.getPage();
                    boolean flag = page != this.lastKnownPage;
                    this.lastKnownPage = page;
                    return flag;
                }
            });
        }
    }

    @Override
    public void changePage(int page) {
        Const.LOGGER.info("Changing page to {}", (Object)page);
        Const.LOGGER.info("Current page is {}", (Object)this.pageData.get());
        int nextPage = Mth.clamp((int)page, (int)0, (int)((Integer)ModConfig.maxPageLimit.get() - 1));
        if (nextPage != this.pageData.get()) {
            this.pageData.set(nextPage);
            Const.LOGGER.info("Page updated to {}", (Object)nextPage);
        } else {
            Const.LOGGER.info("Page remains unchanged at {}", (Object)nextPage);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getMaxPage() {
        return (Integer)ModConfig.maxPageLimit.get();
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getCurrentPage() {
        return this.pageData.get();
    }

    @OnlyIn(value=Dist.CLIENT)
    public long getItemCount(int slot) {
        return Integer.toUnsignedLong(this.countData.get(slot));
    }

    @OnlyIn(value=Dist.CLIENT)
    public Inventory getPlayerInventory() {
        return this.playerInventory;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getSwapIndex() {
        return this.swapIndex;
    }

    @Override
    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int pIndex) {
        ItemStack itemStack = ItemStack.EMPTY;
        Slot slot1 = (Slot)this.slots.get(pIndex);
        if (slot1.hasItem()) {
            ItemStack slot1Item = slot1.getItem();
            itemStack = slot1Item.copy();
            if (pIndex < 54 ? !this.moveItemStackTo(slot1Item, 54, this.slots.size(), true) : !this.moveItemStackTo(slot1Item, 0, 54, false)) {
                return ItemStack.EMPTY;
            }
            if (slot1Item.isEmpty()) {
                slot1.setByPlayer(ItemStack.EMPTY);
            } else {
                slot1.setChanged();
            }
        }
        return itemStack;
    }
}

