/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.net;

import committee.nova.mods.avaritia.api.util.ItemUtils;
import committee.nova.mods.avaritia.common.tile.NeutronCompressorTile;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class C2SCompressorEjectPacket {
    private BlockPos pos;

    public C2SCompressorEjectPacket(FriendlyByteBuf buf) {
        this.pos = buf.readBlockPos();
    }

    public C2SCompressorEjectPacket(BlockPos pos) {
        this.pos = pos;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            Level level = player.level();
            BlockEntity tile = level.getBlockEntity(this.pos);
            if (tile instanceof NeutronCompressorTile) {
                NeutronCompressorTile compressor = (NeutronCompressorTile)tile;
                if (compressor.isRecipeLocked()) {
                    player.sendSystemMessage((Component)Component.literal((String)"\u00a7c[\u4e2d\u5b50\u538b\u7f29\u5668] \u00a7f\u8bf7\u5148\u89e3\u9501\u914d\u65b9"));
                    return;
                }
                if (compressor.getMaterialCount() > 0) {
                    ItemStack materialStack = compressor.getMaterialStack();
                    if (!materialStack.isEmpty()) {
                        ItemStack ejectStack = materialStack.copy();
                        ejectStack.setCount(compressor.getMaterialCount());
                        Inventory playerInventory = player.getInventory();
                        boolean addedToInventory = false;
                        for (int i = 0; i < playerInventory.getContainerSize(); ++i) {
                            int canAdd;
                            ItemStack slotStack = playerInventory.getItem(i);
                            if (slotStack.isEmpty()) {
                                playerInventory.setItem(i, ejectStack);
                                addedToInventory = true;
                                break;
                            }
                            if (!ItemUtils.areStacksSameType(slotStack, ejectStack) || slotStack.getCount() >= slotStack.getMaxStackSize() || (canAdd = Math.min(ejectStack.getCount(), slotStack.getMaxStackSize() - slotStack.getCount())) <= 0) continue;
                            slotStack.grow(canAdd);
                            ejectStack.shrink(canAdd);
                            if (!ejectStack.isEmpty()) continue;
                            addedToInventory = true;
                            break;
                        }
                        if (!addedToInventory) {
                            player.drop(ejectStack, false);
                        }
                        compressor.clearMaterials();
                        player.sendSystemMessage((Component)Component.literal((String)("\u00a7a[\u4e2d\u5b50\u538b\u7f29\u5668] \u00a7f\u5df2\u5f39\u51fa\u6750\u6599: " + ejectStack.getCount() + "x " + ejectStack.getDisplayName().getString())));
                    }
                } else {
                    player.sendSystemMessage((Component)Component.literal((String)"\u00a7c[\u4e2d\u5b50\u538b\u7f29\u5668] \u00a7f\u6ca1\u6709\u53ef\u5f39\u51fa\u7684\u6750\u6599"));
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

