/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.net;

import committee.nova.mods.avaritia.api.iface.ITileIO;
import committee.nova.mods.avaritia.core.io.SideConfiguration;
import committee.nova.mods.avaritia.init.handler.NetworkHandler;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class C2SSideConfigPacket {
    private final BlockPos pos;
    private final SideConfiguration sideConfig;

    public C2SSideConfigPacket(FriendlyByteBuf buf) {
        this.pos = buf.readBlockPos();
        this.sideConfig = SideConfiguration.fromNetwork(buf);
    }

    public C2SSideConfigPacket(BlockPos pos, SideConfiguration sideConfig) {
        this.pos = pos;
        this.sideConfig = sideConfig;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos);
        this.sideConfig.toNetwork(buf);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            Level level = player.level();
            BlockEntity tile = level.getBlockEntity(this.pos);
            if (tile instanceof ITileIO) {
                ITileIO tileIO = (ITileIO)tile;
                if (level.getBlockEntity(this.pos) == null) {
                    return;
                }
                tileIO.setSideConfiguration(this.sideConfig);
                player.sendSystemMessage((Component)Component.literal((String)"\u00a7f\u65b9\u5757\u914d\u7f6e\u5df2\u66f4\u65b0"));
                tileIO.setIOChange();
                NetworkHandler.sendSideConfigSync(level, this.pos, this.sideConfig);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

