/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.net.chest;

import committee.nova.mods.avaritia.Const;
import committee.nova.mods.avaritia.common.menu.InfinityChestMenu;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class C2SInfinityChestActionPack {
    private final int containerId;
    private final int actionId;
    private final String id;

    public C2SInfinityChestActionPack(FriendlyByteBuf buf) {
        this.containerId = buf.readInt();
        this.actionId = buf.readInt();
        this.id = buf.readUtf();
    }

    public C2SInfinityChestActionPack(int containerId, int actionId, String object) {
        this.containerId = containerId;
        this.actionId = actionId;
        this.id = object;
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.containerId);
        buf.writeInt(this.actionId);
        buf.writeUtf(this.id);
    }

    public void run(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
            if (player == null) {
                return;
            }
            if (player.containerMenu.containerId != this.containerId) {
                return;
            }
            if (!player.containerMenu.stillValid((Player)player)) {
                Const.LOGGER.debug("Player {} interacted with invalid menu {}", (Object)player, (Object)player.containerMenu);
            } else {
                ((InfinityChestMenu)player.containerMenu).action(this.actionId, this.id);
                player.containerMenu.broadcastChanges();
            }
        });
        context.get().setPacketHandled(true);
    }
}

