/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.net.chest;

import committee.nova.mods.avaritia.common.net.channel.ChannelState;
import committee.nova.mods.avaritia.core.chest.ClientChestManager;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;

public class S2CInfinityChestStatePack {
    private final ChannelState channelState;
    private final CompoundTag tag;

    public S2CInfinityChestStatePack(FriendlyByteBuf buf) {
        this.channelState = (ChannelState)buf.readEnum(ChannelState.class);
        this.tag = buf.readNbt();
    }

    public S2CInfinityChestStatePack(ChannelState channelState, CompoundTag tag) {
        this.channelState = channelState;
        this.tag = tag;
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeEnum((Enum)this.channelState);
        buf.writeNbt(this.tag);
    }

    public void run(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            switch (this.channelState) {
                case COMMON: {
                    ClientChestManager.getInstance().updateChannel(this.tag);
                    break;
                }
                case FULL: {
                    ClientChestManager.getInstance().fullUpdateChannel(this.tag);
                    break;
                }
                case NAME: {
                    ClientChestManager.getInstance().setUserCache(this.tag);
                }
            }
        }));
        context.get().setPacketHandled(true);
    }
}

