/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.tile;

import committee.nova.mods.avaritia.api.common.tile.BaseTileEntity;
import committee.nova.mods.avaritia.api.util.lang.Localizable;
import committee.nova.mods.avaritia.common.menu.InfinityChestMenu;
import committee.nova.mods.avaritia.core.chest.ServerChestHandler;
import committee.nova.mods.avaritia.core.chest.ServerChestManager;
import committee.nova.mods.avaritia.init.registry.ModTileEntities;
import java.util.UUID;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestLidController;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InfinityChestTile
extends BaseTileEntity
implements LidBlockEntity {
    private UUID owner;
    private boolean locked = false;
    private String filter = "";
    private byte sortType = (byte)4;
    private UUID channelID = UUID.randomUUID();
    private ServerChestHandler channel = new ServerChestHandler();
    private LazyOptional<?> capability = LazyOptional.of(() -> this.channel);
    private final ChestLidController chestLidController = new ChestLidController();

    public InfinityChestTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModTileEntities.infinity_chest_tile.get(), pos, state);
    }

    @NotNull
    public Component getDisplayName() {
        return Localizable.of("block.avaritia.infinity_chest").build();
    }

    @Nullable
    public AbstractContainerMenu createMenu(int containerId, @NotNull Inventory playerInventory, @NotNull Player player) {
        return new InfinityChestMenu(containerId, player, this);
    }

    public void load(@NotNull CompoundTag pTag) {
        if (pTag.contains("owner")) {
            this.owner = pTag.getUUID("owner");
            this.locked = pTag.getBoolean("locked");
        }
        if (pTag.contains("filter")) {
            this.filter = pTag.getString("filter");
        }
        if (pTag.contains("sortType")) {
            this.sortType = pTag.getByte("sortType");
        }
        if (pTag.contains("channelID")) {
            this.channelID = pTag.getUUID("channelID");
        }
        this.channel = ServerChestManager.getInstance().getChannel(this.owner, this.channelID);
    }

    public void saveAdditional(@NotNull CompoundTag pTag) {
        if (this.owner != null) {
            pTag.putUUID("owner", this.owner);
            pTag.putBoolean("locked", this.locked);
        }
        pTag.putString("filter", this.filter);
        pTag.putByte("sortType", this.sortType);
        pTag.putUUID("channelID", this.channelID);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (this.channel.isRemoved()) {
            return LazyOptional.empty();
        }
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.capability.cast();
        }
        return LazyOptional.empty();
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
        this.setChanged();
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
        this.setChanged();
    }

    public void setFilter(String filter) {
        this.filter = filter;
        this.setChanged();
    }

    public void setSortType(byte sortType) {
        this.sortType = sortType;
        this.setChanged();
    }

    public void setChannelId(UUID id) {
        this.channelID = id;
        this.setChanged();
    }

    public static void lidAnimateTick(Level level, BlockPos pos, BlockState state, InfinityChestTile blockEntity) {
        blockEntity.chestLidController.tickLid();
    }

    public boolean triggerEvent(int id, int type) {
        if (id == 1) {
            this.chestLidController.shouldBeOpen(type > 0);
            return true;
        }
        return super.triggerEvent(id, type);
    }

    public float getOpenNess(float partialTicks) {
        return this.chestLidController.getOpenness(partialTicks);
    }

    public static void playSound(Level pLevel, BlockPos pPos, SoundEvent pSound) {
        double d0 = (double)pPos.getX() + 0.5;
        double d1 = (double)pPos.getY() + 0.5;
        double d2 = (double)pPos.getZ() + 0.5;
        pLevel.playSound(null, d0, d1, d2, pSound, SoundSource.BLOCKS, 0.5f, pLevel.random.nextFloat() * 0.1f + 0.9f);
    }

    @Generated
    public UUID getOwner() {
        return this.owner;
    }

    @Generated
    public boolean isLocked() {
        return this.locked;
    }

    @Generated
    public String getFilter() {
        return this.filter;
    }

    @Generated
    public byte getSortType() {
        return this.sortType;
    }

    @Generated
    public UUID getChannelID() {
        return this.channelID;
    }

    @Generated
    public ServerChestHandler getChannel() {
        return this.channel;
    }

    @Generated
    public LazyOptional<?> getCapability() {
        return this.capability;
    }
}

