/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.wrappers;

import committee.nova.mods.avaritia.Const;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class InfiniteItemHandler
implements IItemHandler,
IItemHandlerModifiable {
    public static final int SLOTS_PER_PAGE = 54;
    public static final int MAX_PAGES = 1000000;
    public static final int MAX_ITEMS = 1000000;
    private final List<ItemStack> items;
    private int scrollPosition = 0;
    private String searchQuery = "";
    private SortType sortType = SortType.NONE;
    private Map<String, List<ItemStack>> modItemsMap;
    private boolean rebuildModMap = true;

    public InfiniteItemHandler() {
        this.items = new ArrayList<ItemStack>();
        this.initializeSlots();
    }

    private void initializeSlots() {
        while (this.items.size() < 54) {
            this.items.add(ItemStack.EMPTY);
        }
    }

    public int getSlots() {
        return 54;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        int actualSlot = this.scrollPosition + slot;
        if (actualSlot < 0 || actualSlot >= this.items.size()) {
            return ItemStack.EMPTY;
        }
        return this.items.get(actualSlot);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        int i;
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        if (this.getNonEmptyItemCount() >= 1000000) {
            return stack;
        }
        for (i = 0; i < this.items.size(); ++i) {
            int spaceLeft;
            ItemStack existing = this.items.get(i);
            if (existing.isEmpty() || !ItemStack.isSameItemSameTags((ItemStack)existing, (ItemStack)stack) || (spaceLeft = existing.getMaxStackSize() - existing.getCount()) <= 0) continue;
            int amountToInsert = Math.min(stack.getCount(), spaceLeft);
            if (!simulate) {
                existing.grow(amountToInsert);
                this.rebuildModMap = true;
            }
            return stack.copyWithCount(stack.getCount() - amountToInsert);
        }
        for (i = 0; i < this.items.size(); ++i) {
            if (!this.items.get(i).isEmpty()) continue;
            int amountToInsert = Math.min(stack.getCount(), stack.getMaxStackSize());
            if (!simulate) {
                this.items.set(i, stack.copyWithCount(amountToInsert));
                this.rebuildModMap = true;
            }
            return stack.copyWithCount(stack.getCount() - amountToInsert);
        }
        if (this.items.size() < 1000000) {
            int amountToInsert = Math.min(stack.getCount(), stack.getMaxStackSize());
            if (!simulate) {
                this.items.add(stack.copyWithCount(amountToInsert));
                this.rebuildModMap = true;
            }
            return stack.copyWithCount(stack.getCount() - amountToInsert);
        }
        return stack;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount <= 0) {
            return ItemStack.EMPTY;
        }
        int actualSlot = this.scrollPosition + slot;
        if (actualSlot < 0 || actualSlot >= this.items.size()) {
            return ItemStack.EMPTY;
        }
        ItemStack existing = this.items.get(actualSlot);
        if (existing.isEmpty()) {
            return ItemStack.EMPTY;
        }
        int amountToExtract = Math.min(amount, existing.getCount());
        ItemStack extracted = existing.copyWithCount(amountToExtract);
        if (!simulate) {
            existing.shrink(amountToExtract);
            if (existing.isEmpty()) {
                this.items.set(actualSlot, ItemStack.EMPTY);
            }
            this.rebuildModMap = true;
        }
        return extracted;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return true;
    }

    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        int actualSlot = this.scrollPosition + slot;
        while (actualSlot >= this.items.size()) {
            this.items.add(ItemStack.EMPTY);
        }
        this.items.set(actualSlot, stack);
        this.rebuildModMap = true;
    }

    public int getScrollPosition() {
        return this.scrollPosition;
    }

    public void setScrollPosition(int position) {
        this.scrollPosition = Math.max(0, Math.min(position, Math.max(0, this.items.size() - 54)));
    }

    public int getMaxScrollPosition() {
        return Math.max(0, this.items.size() - 54);
    }

    public int getNonEmptyItemCount() {
        int count = 0;
        for (ItemStack stack : this.items) {
            if (stack.isEmpty()) continue;
            ++count;
        }
        return count;
    }

    public void setSearchQuery(String query) {
        this.searchQuery = query.toLowerCase();
    }

    public String getSearchQuery() {
        return this.searchQuery;
    }

    public List<ItemStack> getFilteredItems() {
        if (this.searchQuery.isEmpty()) {
            return new ArrayList<ItemStack>(this.items);
        }
        ArrayList<ItemStack> filtered = new ArrayList<ItemStack>();
        for (ItemStack stack : this.items) {
            if (stack.isEmpty() || !stack.getDisplayName().getString().toLowerCase().contains(this.searchQuery)) continue;
            filtered.add(stack);
        }
        return filtered;
    }

    public void setSortType(SortType type) {
        this.sortType = type;
        if (type != SortType.NONE) {
            this.sortItems();
        }
    }

    public SortType getSortType() {
        return this.sortType;
    }

    private void sortItems() {
        ArrayList<ItemStack> nonEmptyItems = new ArrayList<ItemStack>();
        for (ItemStack stack : this.items) {
            if (stack.isEmpty()) continue;
            nonEmptyItems.add(stack);
        }
        nonEmptyItems.sort((stack1, stack2) -> {
            switch (this.sortType) {
                case NAME: {
                    return stack1.getDisplayName().getString().compareTo(stack2.getDisplayName().getString());
                }
                case COUNT: {
                    return Integer.compare(stack2.getCount(), stack1.getCount());
                }
                case MOD: {
                    String modId1 = Const.getItemName(stack1.getItem()).getNamespace();
                    String modId2 = Const.getItemName(stack2.getItem()).getNamespace();
                    return modId1.compareTo(modId2);
                }
                case CATEGORY: {
                    return stack1.getItem().getDescription().getString().compareTo(stack2.getItem().getDescription().getString());
                }
            }
            return 0;
        });
        this.items.clear();
        this.items.addAll(nonEmptyItems);
        this.initializeSlots();
        this.rebuildModMap = true;
    }

    public Map<String, List<ItemStack>> getItemsByMod() {
        if (this.rebuildModMap || this.modItemsMap == null) {
            this.rebuildModItemsMap();
        }
        return this.modItemsMap;
    }

    private void rebuildModItemsMap() {
        this.modItemsMap = new HashMap<String, List<ItemStack>>();
        for (ItemStack stack : this.items) {
            if (stack.isEmpty()) continue;
            String modId = Const.getItemName(stack.getItem()).getNamespace();
            this.modItemsMap.computeIfAbsent(modId, k -> new ArrayList()).add(stack);
        }
        this.rebuildModMap = false;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        ListTag itemsList = new ListTag();
        for (ItemStack stack : this.items) {
            CompoundTag itemTag = new CompoundTag();
            if (!stack.isEmpty()) {
                stack.save(itemTag);
            }
            itemsList.add((Object)itemTag);
        }
        tag.put("Items", (Tag)itemsList);
        tag.putInt("ScrollPosition", this.scrollPosition);
        tag.putString("SearchQuery", this.searchQuery);
        tag.putString("SortType", this.sortType.name());
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.items.clear();
        ListTag itemsList = nbt.getList("Items", 10);
        for (int i = 0; i < itemsList.size(); ++i) {
            CompoundTag itemTag = itemsList.getCompound(i);
            if (itemTag.isEmpty()) {
                this.items.add(ItemStack.EMPTY);
                continue;
            }
            this.items.add(ItemStack.of((CompoundTag)itemTag));
        }
        this.scrollPosition = nbt.getInt("ScrollPosition");
        this.searchQuery = nbt.getString("SearchQuery");
        this.sortType = SortType.valueOf(nbt.getString("SortType"));
        this.rebuildModMap = true;
    }

    public List<ItemStack> getAllItems() {
        ArrayList<ItemStack> allItems = new ArrayList<ItemStack>();
        for (ItemStack stack : this.items) {
            if (stack.isEmpty()) continue;
            allItems.add(stack);
        }
        return allItems;
    }

    public static enum SortType {
        NONE,
        NAME,
        COUNT,
        MOD,
        CATEGORY;

    }
}

