/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.common.wrappers;

import committee.nova.mods.avaritia.api.common.wrapper.OffsetItemStackWrapper;
import committee.nova.mods.avaritia.common.item.misc.NeutronRingItem;
import committee.nova.mods.avaritia.common.wrappers.StorageItem;
import committee.nova.mods.avaritia.util.StorageUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import lombok.Generated;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.INBTSerializable;
import org.jetbrains.annotations.NotNull;

public class RingStorageWrapper
extends OffsetItemStackWrapper
implements INBTSerializable<CompoundTag> {
    private final int rows;
    public Int2ObjectMap<StorageItem> containers = StorageUtils.newContainers();
    private int page = 0;
    public final DataSlot pageData = new DataSlot(){

        public int get() {
            return RingStorageWrapper.this.page;
        }

        public void set(int value) {
            RingStorageWrapper.this.page = value;
        }
    };
    public final ContainerData countData = new ContainerData(){

        public int get(int index) {
            return index >= 0 && index < RingStorageWrapper.this.getSlots() ? (int)RingStorageWrapper.this.getContainerInSlot(index).getCount() : 0;
        }

        public void set(int index, int value) {
            if (index >= 0 && index < RingStorageWrapper.this.getSlots()) {
                RingStorageWrapper.this.getContainerInSlot(index).setCount(Integer.toUnsignedLong(value));
            }
        }

        public int getCount() {
            return RingStorageWrapper.this.getSlots();
        }
    };

    public RingStorageWrapper(int rows) {
        this.rows = rows;
    }

    @Override
    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return !(stack.getItem() instanceof NeutronRingItem) && super.isItemValid(slot, stack);
    }

    public CompoundTag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        StorageUtils.saveAllItems(compound, this.containers);
        compound.putInt("Page", this.page);
        return compound;
    }

    public void deserializeNBT(CompoundTag compoundTag) {
        this.containers.clear();
        StorageUtils.loadAllItems(compoundTag, this.containers);
        this.page = compoundTag.getInt("Page");
    }

    @Override
    protected Int2ObjectMap<StorageItem> getContainers() {
        return this.containers;
    }

    @Override
    protected int getOffset() {
        return this.rows * 9 * this.page;
    }

    @Override
    public int getSlots() {
        return this.rows * 9;
    }

    @Generated
    public int getPage() {
        return this.page;
    }
}

