/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.core.channel;

import committee.nova.mods.avaritia.common.container.DummyChannelContainer;
import committee.nova.mods.avaritia.core.channel.Channel;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;

public class ClientChannel
extends Channel {
    @Nullable
    public DummyChannelContainer container;

    public void addListener(DummyChannelContainer container) {
        this.container = container;
    }

    public void removeListener() {
        this.container = null;
        this.storageItems.clear();
        this.storageFluids.clear();
        this.storageEnergies.clear();
    }

    @Override
    public void onItemChanged(String itemId, boolean listChanged) {
        super.onItemChanged(itemId, listChanged);
        if (this.container != null) {
            this.container.refreshContainer(listChanged);
        }
    }

    @Override
    public void onFluidChanged(String fluidId, boolean listChanged) {
        super.onFluidChanged(fluidId, listChanged);
        if (this.container != null) {
            this.container.refreshContainer(listChanged);
        }
    }

    @Override
    public void onEnergyChanged(String energyId, boolean listChanged) {
        if (this.container != null) {
            this.container.refreshContainer(listChanged);
        }
    }

    public void update(CompoundTag tag) {
        if (this.container == null) {
            return;
        }
        CompoundTag items = tag.getCompound("items");
        CompoundTag fluids = tag.getCompound("fluids");
        CompoundTag energies = tag.getCompound("energies");
        String name = tag.getString("name");
        AtomicBoolean fullUpdate = new AtomicBoolean(false);
        AtomicBoolean needRefreshContainer = new AtomicBoolean(false);
        items.getAllKeys().forEach(itemId -> {
            long count = items.getLong(itemId);
            if (count <= 0L) {
                if (this.storageItems.containsKey(itemId)) {
                    this.storageItems.remove(itemId);
                    fullUpdate.set(true);
                    needRefreshContainer.set(true);
                }
            } else if (this.storageItems.containsKey(itemId)) {
                if ((Long)this.storageItems.get(itemId) != count) {
                    this.storageItems.replace(itemId, count);
                    needRefreshContainer.set(true);
                }
            } else {
                this.storageItems.put(itemId, count);
                fullUpdate.set(true);
                needRefreshContainer.set(true);
            }
        });
        fluids.getAllKeys().forEach(fluidId -> {
            long count = fluids.getLong(fluidId);
            if (count <= 0L) {
                if (this.storageFluids.containsKey(fluidId)) {
                    this.storageFluids.remove(fluidId);
                    fullUpdate.set(true);
                    needRefreshContainer.set(true);
                }
            } else if (this.storageFluids.containsKey(fluidId)) {
                if ((Long)this.storageFluids.get(fluidId) != count) {
                    this.storageFluids.replace(fluidId, count);
                    needRefreshContainer.set(true);
                }
            } else {
                this.storageFluids.put(fluidId, count);
                fullUpdate.set(true);
                needRefreshContainer.set(true);
            }
        });
        energies.getAllKeys().forEach(energyId -> {
            long count = energies.getLong(energyId);
            if (count <= 0L) {
                if (this.storageEnergies.containsKey(energyId)) {
                    this.storageEnergies.remove(energyId);
                    fullUpdate.set(true);
                    needRefreshContainer.set(true);
                }
            } else if (this.storageEnergies.containsKey(energyId)) {
                if ((Long)this.storageEnergies.get(energyId) != count) {
                    this.storageEnergies.replace(energyId, count);
                    needRefreshContainer.set(true);
                }
            } else {
                this.storageEnergies.put(energyId, count);
                fullUpdate.set(true);
                needRefreshContainer.set(true);
            }
        });
        if (!name.isEmpty()) {
            this.setName(name);
        }
        if (needRefreshContainer.get()) {
            this.container.refreshContainer(fullUpdate.get());
        }
        if (fullUpdate.get()) {
            this.updateItemKeys();
            this.updateFluidKeys();
        }
    }

    public void fullUpdate(CompoundTag tag) {
        CompoundTag items = tag.getCompound("items");
        CompoundTag fluids = tag.getCompound("fluids");
        CompoundTag energies = tag.getCompound("energies");
        String name = tag.getString("name");
        this.storageItems.clear();
        this.storageFluids.clear();
        this.storageEnergies.clear();
        items.getAllKeys().forEach(itemId -> this.storageItems.put(itemId, items.getLong(itemId)));
        fluids.getAllKeys().forEach(fluidId -> this.storageFluids.put(fluidId, fluids.getLong(fluidId)));
        energies.getAllKeys().forEach(energyId -> this.storageEnergies.put(energyId, energies.getLong(energyId)));
        this.updateItemKeys();
        this.updateFluidKeys();
        this.setName(name);
        if (this.container != null) {
            this.container.refreshContainer(true);
        }
    }

    @Override
    public boolean isRemoved() {
        return false;
    }
}

