/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.core.channel;

import committee.nova.mods.avaritia.Const;
import committee.nova.mods.avaritia.common.net.channel.ChannelAction;
import committee.nova.mods.avaritia.common.net.channel.S2CChannelActionPack;
import committee.nova.mods.avaritia.core.channel.ChannelInfo;
import committee.nova.mods.avaritia.core.channel.IChannelTerminal;
import committee.nova.mods.avaritia.core.channel.ServerChannelManager;
import committee.nova.mods.avaritia.init.handler.NetworkHandler;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class ItemChannelTerminal
implements IChannelTerminal {
    private final UUID terminalOwner;
    private final ItemStack terminal;
    private final int slotID;
    private final Inventory inventory;

    public ItemChannelTerminal(Inventory playerInventory, ItemStack itemStack, int slotID) {
        this.inventory = playerInventory;
        this.slotID = slotID;
        this.terminal = itemStack;
        CompoundTag nbt = itemStack.getOrCreateTag();
        this.terminalOwner = nbt.getUUID("owner");
    }

    @Override
    public UUID getTerminalOwner() {
        return this.terminalOwner;
    }

    @Override
    @Nullable
    public ChannelInfo getChannelInfo() {
        CompoundTag nbt = this.terminal.getOrCreateTag();
        if (!nbt.contains("channel")) {
            return null;
        }
        CompoundTag channel = nbt.getCompound("channel");
        int channelId = channel.getInt("channelID");
        UUID channelOwner = channel.getUUID("channelOwner");
        return new ChannelInfo(channelOwner, channelId);
    }

    @Override
    public void setChannel(UUID channelOwner, int channelId) {
        CompoundTag channel;
        CompoundTag nbt = this.terminal.getOrCreateTag();
        if (nbt.contains("channel")) {
            channel = nbt.getCompound("channel");
        } else {
            channel = new CompoundTag();
            nbt.put("channel", (Tag)channel);
        }
        channel.putUUID("channelOwner", channelOwner);
        channel.putInt("channelID", channelId);
        ServerChannelManager.sendChannelSet((ServerPlayer)this.inventory.player, this.terminalOwner, channelOwner, channelId);
    }

    @Override
    public void addChannelSelector(ServerPlayer player) {
        ChannelInfo info = this.getChannelInfo();
        if (info == null) {
            return;
        }
        ServerChannelManager.sendChannelSet((ServerPlayer)this.inventory.player, this.terminalOwner, info.owner(), info.id());
    }

    @Override
    public void removeChannel(ServerPlayer actor) {
        ChannelInfo info = this.getChannelInfo();
        if (info == null) {
            return;
        }
        if (info.owner().equals(actor.getUUID()) || info.owner().equals(Const.AVARITIA_FAKE_PLAYER.getId())) {
            if (!ServerChannelManager.getInstance().tryRemoveChannel(info.owner(), info.id())) {
                return;
            }
            NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)this.inventory.player), (Object)new S2CChannelActionPack(ChannelAction.SET, -1, "", -1));
            this.terminal.getTag().remove("channel");
        }
    }

    @Override
    public void renameChannel(ServerPlayer actor, String name) {
        ChannelInfo info = this.getChannelInfo();
        if (info == null) {
            return;
        }
        if (info.owner().equals(actor.getUUID()) || info.owner().equals(Const.AVARITIA_FAKE_PLAYER.getId())) {
            ServerChannelManager.getInstance().renameChannel(info, name);
        }
    }

    @Override
    public void removeChannelSelector(ServerPlayer player) {
    }

    @Override
    public boolean stillValid() {
        return this.terminal == this.inventory.getItem(this.slotID);
    }

    @Override
    public void tryReOpenMenu(ServerPlayer player) {
        if (this.getChannelInfo() != null) {
            this.terminal.use(player.level(), (Player)player, InteractionHand.MAIN_HAND);
        }
    }
}

