/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.core.channel;

import committee.nova.mods.avaritia.common.net.channel.ChannelState;
import committee.nova.mods.avaritia.common.net.channel.S2CChannelStatePack;
import committee.nova.mods.avaritia.core.channel.Channel;
import committee.nova.mods.avaritia.init.handler.NetworkHandler;
import java.util.HashSet;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;

public class ServerChannel
extends Channel {
    private final HashSet<String> changedItems = new HashSet();
    private final HashSet<String> changedFluids = new HashSet();
    private final HashSet<String> changedEnergy = new HashSet();
    private boolean nameChanged = false;
    private final HashSet<ServerPlayer> players = new HashSet();
    private boolean removed = false;

    public ServerChannel() {
    }

    public ServerChannel(String name) {
        this.setName(name);
    }

    public ServerChannel(CompoundTag dat) {
        this.initialize(dat);
    }

    @Override
    public void onItemChanged(String itemId, boolean listChanged) {
        super.onItemChanged(itemId, listChanged);
        this.changedItems.add(itemId);
    }

    @Override
    public void onFluidChanged(String fluidId, boolean listChanged) {
        super.onFluidChanged(fluidId, listChanged);
        this.changedFluids.add(fluidId);
    }

    @Override
    public void onEnergyChanged(String energyId, boolean listChanged) {
        this.changedEnergy.add(energyId);
    }

    public void initialize(CompoundTag dat) {
        if (dat.contains("name")) {
            this.setName(dat.getString("name"));
        }
        this.storageItems.clear();
        if (dat.contains("items")) {
            CompoundTag items = dat.getCompound("items");
            items.getAllKeys().forEach(itemId -> {
                if (items.getLong(itemId) > 0L && ForgeRegistries.ITEMS.containsKey(new ResourceLocation(itemId))) {
                    this.storageItems.put(itemId, items.getLong(itemId));
                }
            });
            this.updateItemKeys();
        }
        this.storageFluids.clear();
        if (dat.contains("fluids")) {
            CompoundTag fluids = dat.getCompound("fluids");
            fluids.getAllKeys().forEach(fluidId -> {
                if (fluids.getLong(fluidId) > 0L && ForgeRegistries.FLUIDS.containsKey(new ResourceLocation(fluidId))) {
                    this.storageFluids.put(fluidId, fluids.getLong(fluidId));
                }
            });
            this.updateFluidKeys();
        }
        this.storageEnergies.clear();
        if (dat.contains("energies")) {
            CompoundTag energies = dat.getCompound("energies");
            energies.getAllKeys().forEach(energy -> {
                if (energies.getLong(energy) > 0L && ForgeRegistries.ITEMS.containsKey(new ResourceLocation(energy))) {
                    this.storageEnergies.put(energy, energies.getLong(energy));
                }
            });
        }
    }

    public void addListener(ServerPlayer player) {
        this.players.add(player);
        NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new S2CChannelStatePack(ChannelState.FULL, this.buildData()));
    }

    public void removeListener(ServerPlayer player) {
        this.players.remove(player);
    }

    public void sendUpdate() {
        if (!this.hasChanged()) {
            return;
        }
        if (!this.players.isEmpty()) {
            CompoundTag tag = new CompoundTag();
            CompoundTag items = new CompoundTag();
            this.changedItems.forEach(itemId -> items.putLong(itemId, this.storageItems.getOrDefault(itemId, 0L).longValue()));
            tag.put("items", (Tag)items);
            CompoundTag fluids = new CompoundTag();
            this.changedFluids.forEach(fluidId -> fluids.putLong(fluidId, this.storageFluids.getOrDefault(fluidId, 0L).longValue()));
            tag.put("fluids", (Tag)fluids);
            CompoundTag energies = new CompoundTag();
            this.changedEnergy.forEach(energyId -> energies.putLong(energyId, this.storageEnergies.getOrDefault(energyId, 0L).longValue()));
            tag.put("energies", (Tag)energies);
            if (this.nameChanged) {
                tag.putString("name", this.getName());
            }
            this.players.forEach(player -> NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new S2CChannelStatePack(ChannelState.COMMON, tag)));
        }
        this.resetChanged();
    }

    private boolean hasChanged() {
        return !this.changedItems.isEmpty() || !this.changedFluids.isEmpty() || !this.changedEnergy.isEmpty() || this.nameChanged;
    }

    private void resetChanged() {
        this.changedItems.clear();
        this.changedFluids.clear();
        this.changedEnergy.clear();
        this.nameChanged = false;
    }

    public void sendFullUpdate() {
        if (!this.hasChanged()) {
            return;
        }
        if (!this.players.isEmpty()) {
            this.players.forEach(player -> NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new S2CChannelStatePack(ChannelState.FULL, this.buildData())));
        }
        this.changedItems.clear();
    }

    @Override
    public void setName(String channelName) {
        this.nameChanged = true;
        super.setName(channelName);
    }

    public CompoundTag buildData() {
        CompoundTag items = new CompoundTag();
        this.storageItems.forEach((arg_0, arg_1) -> ((CompoundTag)items).putLong(arg_0, arg_1));
        CompoundTag fluids = new CompoundTag();
        this.storageFluids.forEach((arg_0, arg_1) -> ((CompoundTag)fluids).putLong(arg_0, arg_1));
        CompoundTag energies = new CompoundTag();
        this.storageEnergies.forEach((arg_0, arg_1) -> ((CompoundTag)energies).putLong(arg_0, arg_1));
        CompoundTag data = new CompoundTag();
        data.putString("name", this.getName());
        data.put("items", (Tag)items);
        data.put("fluids", (Tag)fluids);
        data.put("energies", (Tag)energies);
        return data;
    }

    @Override
    public boolean isRemoved() {
        return this.removed;
    }

    public void setRemoved() {
        this.players.clear();
        this.removed = true;
    }
}

