/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.core.chest;

import committee.nova.mods.avaritia.core.chest.ChestHandler;
import committee.nova.mods.avaritia.core.chest.InfinityChestContainer;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;

public class ClientChestHandler
extends ChestHandler {
    @Nullable
    public InfinityChestContainer container;

    public void addListener(InfinityChestContainer container) {
        this.container = container;
    }

    public void removeListener() {
        this.container = null;
        this.storageItems.clear();
    }

    @Override
    public void onItemChanged(String itemId, boolean listChanged) {
        super.onItemChanged(itemId, listChanged);
        if (this.container != null) {
            this.container.refreshContainer(listChanged);
        }
    }

    public void update(CompoundTag tag) {
        if (this.container == null) {
            return;
        }
        CompoundTag items = tag.getCompound("items");
        AtomicBoolean fullUpdate = new AtomicBoolean(false);
        AtomicBoolean needRefreshContainer = new AtomicBoolean(false);
        items.getAllKeys().forEach(itemId -> {
            long count = items.getLong(itemId);
            if (count <= 0L) {
                if (this.storageItems.containsKey(itemId)) {
                    this.storageItems.remove(itemId);
                    fullUpdate.set(true);
                    needRefreshContainer.set(true);
                }
            } else if (this.storageItems.containsKey(itemId)) {
                if ((Long)this.storageItems.get(itemId) != count) {
                    this.storageItems.replace(itemId, count);
                    needRefreshContainer.set(true);
                }
            } else {
                this.storageItems.put(itemId, count);
                fullUpdate.set(true);
                needRefreshContainer.set(true);
            }
        });
        if (needRefreshContainer.get()) {
            this.container.refreshContainer(fullUpdate.get());
        }
        if (fullUpdate.get()) {
            this.updateItemKeys();
        }
    }

    public void fullUpdate(CompoundTag tag) {
        CompoundTag items = tag.getCompound("items");
        this.storageItems.clear();
        items.getAllKeys().forEach(itemId -> this.storageItems.put(itemId, items.getLong(itemId)));
        this.updateItemKeys();
        if (this.container != null) {
            this.container.refreshContainer(true);
        }
    }

    @Override
    public boolean isRemoved() {
        return false;
    }
}

