/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.core.chest;

import committee.nova.mods.avaritia.Const;
import committee.nova.mods.avaritia.common.net.channel.ChannelState;
import committee.nova.mods.avaritia.common.net.chest.S2CInfinityChestStatePack;
import committee.nova.mods.avaritia.core.chest.ServerChestHandler;
import committee.nova.mods.avaritia.init.config.ModConfig;
import committee.nova.mods.avaritia.init.handler.NetworkHandler;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.UUID;
import lombok.Generated;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber(modid="avaritia", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ServerChestManager {
    private static volatile ServerChestManager instance;
    private CompoundTag userCache;
    private File saveDataPath;
    private boolean loadSuccess = true;
    private final MinecraftServer server;
    private final HashMap<UUID, HashMap<UUID, ServerChestHandler>> channelList = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ServerChestManager getInstance() {
        if (instance != null) return instance;
        Class<ServerChestManager> clazz = ServerChestManager.class;
        synchronized (ServerChestManager.class) {
            if (instance != null) return instance;
            instance = new ServerChestManager(ServerLifecycleHooks.getCurrentServer());
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void newInstance(MinecraftServer server) {
        if (instance != null) return;
        Class<ServerChestManager> clazz = ServerChestManager.class;
        synchronized (ServerChestManager.class) {
            if (instance != null) return;
            instance = new ServerChestManager(server);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @SubscribeEvent
    public static void onServerLoad(ServerAboutToStartEvent event) {
        ServerChestManager.newInstance(event.getServer());
    }

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        this.userCache.getCompound("nameCache").putString(event.getEntity().getUUID().toString(), event.getEntity().getGameProfile().getName());
        NetworkHandler.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new S2CInfinityChestStatePack(ChannelState.NAME, this.userCache));
        if (!this.loadSuccess) {
            event.getEntity().sendSystemMessage((Component)Component.translatable((String)"info.avaritia.infinity_chest.load_error"));
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.ServerTickEvent event) {
        MinecraftServer server = event.getServer();
        if (server == null) {
            return;
        }
        int tickCount = server.getTickCount();
        if (tickCount % (Integer)ModConfig.CHANNEL_FULL_UPDATE_RATE.get() == 0) {
            this.channelList.forEach((uuid, map) -> map.forEach((id, channel) -> channel.sendFullUpdate()));
        } else if (tickCount % (Integer)ModConfig.CHANNEL_FAST_UPDATE_RATE.get() == 0) {
            this.channelList.forEach((uuid, map) -> map.forEach((id, channel) -> channel.sendUpdate()));
        }
    }

    @SubscribeEvent
    public void onLevelSave(LevelEvent.Save event) {
        if (this.isOverworld(event.getLevel())) {
            this.save(event.getLevel().getServer());
        }
    }

    @SubscribeEvent
    public void onServerDown(ServerStoppingEvent event) {
        this.save(event.getServer());
        MinecraftForge.EVENT_BUS.unregister((Object)this);
        instance = null;
    }

    private ServerChestManager(MinecraftServer server) {
        this.server = server;
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.load();
    }

    private void load() {
        this.saveDataPath = new File(this.server.getWorldPath(LevelResource.ROOT).toFile(), "data/avaritia/infinity_chest");
        try {
            File[] channelDirs;
            File userCacheFile;
            if (!this.saveDataPath.exists()) {
                this.saveDataPath.mkdirs();
            }
            if ((userCacheFile = new File(this.saveDataPath, "UserCache.dat")).exists() && userCacheFile.isFile()) {
                this.userCache = NbtIo.readCompressed((File)userCacheFile);
                if (!this.userCache.contains("nameCache")) {
                    this.initializeNameCache();
                }
            } else {
                this.initializeNameCache();
            }
            if ((channelDirs = this.saveDataPath.listFiles(pathname -> pathname.isDirectory() && pathname.getName().matches("^[0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}$"))) != null) {
                for (File dir : channelDirs) {
                    UUID player = UUID.fromString(dir.getName());
                    File[] channels = dir.listFiles(pathname -> pathname.isFile() && pathname.getName().matches("^([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})\\.dat$"));
                    if (channels == null) continue;
                    HashMap<UUID, ServerChestHandler> playerChannels = new HashMap<UUID, ServerChestHandler>();
                    for (File channelFile : channels) {
                        UUID channelID = UUID.fromString(channelFile.getName().substring(0, channelFile.getName().lastIndexOf(".")));
                        CompoundTag channelDat = NbtIo.readCompressed((File)channelFile);
                        ServerChestHandler channel = new ServerChestHandler(channelDat);
                        playerChannels.put(channelID, channel);
                        Const.LOGGER.info(Component.translatable((String)"info.avaritia.infinity_chest.load_success", (Object[])new Object[]{dir.getName(), channelID, ""}).getString());
                    }
                    this.channelList.put(player, playerChannels);
                }
            }
            Const.LOGGER.info(Component.translatable((String)"info.avaritia.infinity_chest.load_finish").getString());
        }
        catch (Exception e) {
            this.loadSuccess = false;
            throw new RuntimeException("\u5728\u52a0\u8f7d\u6570\u636e\u7684\u65f6\u5019\u51fa\u9519\u4e86\uff01 \u672c\u6b21\u6e38\u620f\u5c06\u4e0d\u4f1a\u4fdd\u5b58\u6570\u636e\uff01", e);
        }
    }

    private void save(MinecraftServer server) {
        if (!this.loadSuccess) {
            return;
        }
        try {
            File userCache = new File(this.saveDataPath, "UserCache.dat");
            if (!userCache.exists()) {
                userCache.createNewFile();
            }
            NbtIo.writeCompressed((CompoundTag)this.userCache, (File)userCache);
            this.channelList.forEach((uuid, channels) -> {
                File user = new File(this.saveDataPath, uuid.toString());
                if (!user.exists()) {
                    user.mkdir();
                }
                channels.forEach((id, channel) -> {
                    File channelDat = new File(user, id.toString() + ".dat");
                    try {
                        if (!channelDat.exists()) {
                            channelDat.createNewFile();
                        }
                        NbtIo.writeCompressed((CompoundTag)channel.buildData(), (File)channelDat);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    Const.LOGGER.info(Component.translatable((String)"info.avaritia.infinity_chest.save_success", (Object[])new Object[]{uuid, id, ""}).getString());
                });
            });
        }
        catch (Exception e) {
            throw new RuntimeException("\u5728\u4fdd\u5b58\u6570\u636e\u7684\u65f6\u5019\u51fa\u9519\u4e86\uff01 \u4ec0\u4e48\u60c5\u51b5\u5462\uff1f", e);
        }
    }

    private void initializeUserCache() {
        this.userCache = new CompoundTag();
        this.userCache.putInt("dataVersion", 1);
    }

    private void initializeNameCache() {
        CompoundTag nameCache = new CompoundTag();
        nameCache.putString(Const.AVARITIA_FAKE_PLAYER.getId().toString(), Const.AVARITIA_FAKE_PLAYER.getName());
        if (this.userCache == null) {
            this.initializeUserCache();
        }
        this.userCache.put("nameCache", (Tag)nameCache);
    }

    private boolean isOverworld(LevelAccessor level) {
        return !level.isClientSide();
    }

    public String getUserName(UUID uuid) {
        String userName = this.userCache.getCompound("nameCache").getString(uuid.toString());
        if (userName.isEmpty()) {
            this.userCache.getCompound("nameCache").putString(uuid.toString(), "unknownUser");
            NetworkHandler.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new S2CInfinityChestStatePack(ChannelState.NAME, this.userCache));
            userName = "unknownUser";
        }
        return userName;
    }

    public ServerChestHandler getChannel(UUID ownerUUID, UUID channelId) {
        HashMap<UUID, ServerChestHandler> list;
        if (this.channelList.containsKey(ownerUUID) && (list = this.channelList.get(ownerUUID)).containsKey(channelId)) {
            return list.get(channelId);
        }
        return new ServerChestHandler();
    }

    public void tryAddChannel(ServerPlayer player, UUID chestId) {
        HashMap<Object, Object> playerChannels;
        UUID uuid = player.getUUID();
        if (this.channelList.containsKey(uuid)) {
            playerChannels = this.channelList.get(uuid);
        } else {
            playerChannels = new HashMap();
            this.channelList.put(uuid, playerChannels);
        }
        playerChannels.put(chestId, new ServerChestHandler());
        Const.LOGGER.info(Component.translatable((String)"info.avaritia.infinity_chest.add_success", (Object[])new Object[]{uuid, chestId, ""}).getString());
    }

    public boolean tryRemoveChannel(ServerPlayer player, UUID chestId) {
        UUID channelOwner = player.getUUID();
        if (!this.channelList.containsKey(channelOwner)) {
            return false;
        }
        HashMap<UUID, ServerChestHandler> list = this.channelList.get(channelOwner);
        if (!list.containsKey(chestId)) {
            return false;
        }
        ServerChestHandler channel = list.get(chestId);
        if (!channel.isEmpty()) {
            return false;
        }
        if (list.remove(chestId) != null) {
            channel.setRemoved();
            File file = new File(this.saveDataPath, String.valueOf(channelOwner) + "/" + String.valueOf(chestId) + ".dat");
            file.delete();
            return true;
        }
        return false;
    }

    @Generated
    public CompoundTag getUserCache() {
        return this.userCache;
    }
}

