/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.core.singularity;

import committee.nova.mods.avaritia.api.util.lang.Localizable;
import committee.nova.mods.avaritia.init.config.ModConfig;
import lombok.Generated;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.fml.loading.FMLLoader;

public class Singularity {
    private final ResourceLocation id;
    private final String name;
    private final int[] colors;
    private final String tag;
    private final int ingredientCount;
    private final int timeRequired;
    private Ingredient ingredient;
    private boolean enabled = true;
    private boolean recipeDisabled = false;

    public Singularity(ResourceLocation id, String name, int[] colors, Ingredient ingredient, int ingredientCount, int timeRequired) {
        this.id = id;
        this.name = name;
        this.colors = colors;
        this.ingredient = ingredient;
        this.tag = null;
        this.ingredientCount = ingredientCount;
        this.timeRequired = timeRequired;
    }

    public Singularity(ResourceLocation id, String name, int[] colors, Ingredient ingredient) {
        this(id, name, colors, ingredient, -1, FMLLoader.isProduction() ? (Integer)ModConfig.singularityTimeRequired.get() : 240);
    }

    public Singularity(ResourceLocation id, String name, int[] colors, String tag, int ingredientCount, int timeRequired) {
        this.id = id;
        this.name = name;
        this.colors = colors;
        this.ingredient = Ingredient.EMPTY;
        this.tag = tag;
        this.ingredientCount = ingredientCount;
        this.timeRequired = timeRequired;
    }

    public Singularity(ResourceLocation id, String name, int[] colors, String tag) {
        this(id, name, colors, tag, -1, FMLLoader.isProduction() ? (Integer)ModConfig.singularityTimeRequired.get() : 240);
    }

    public static Singularity read(FriendlyByteBuf buffer) {
        ResourceLocation id = buffer.readResourceLocation();
        String name = buffer.readUtf();
        int[] colors = buffer.readVarIntArray();
        boolean isTagIngredient = buffer.readBoolean();
        int timeRequired = buffer.readVarInt();
        String tag = null;
        Ingredient ingredient = Ingredient.EMPTY;
        if (isTagIngredient) {
            tag = buffer.readUtf();
        } else {
            ingredient = Ingredient.fromNetwork((FriendlyByteBuf)buffer);
        }
        int ingredientCount = buffer.readVarInt();
        Singularity singularity = isTagIngredient ? new Singularity(id, name, colors, tag, ingredientCount, timeRequired) : new Singularity(id, name, colors, ingredient, ingredientCount, timeRequired);
        singularity.enabled = buffer.readBoolean();
        singularity.recipeDisabled = buffer.readBoolean();
        return singularity;
    }

    public int getOverlayColor() {
        return this.colors[0];
    }

    public int getUnderlayColor() {
        return this.colors[1];
    }

    public Ingredient getIngredient() {
        if (this.tag != null && this.ingredient == Ingredient.EMPTY) {
            TagKey tag = ItemTags.create((ResourceLocation)new ResourceLocation(this.tag));
            this.ingredient = Ingredient.of((TagKey)tag);
        }
        return this.ingredient;
    }

    public int getIngredientCount() {
        if (this.ingredientCount == -1) {
            return 1000;
        }
        return this.ingredientCount;
    }

    public Component getDisplayName() {
        return Localizable.of(this.name).build();
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.writeResourceLocation(this.id);
        buffer.writeUtf(this.name);
        buffer.writeVarIntArray(this.colors);
        buffer.writeBoolean(this.tag != null);
        buffer.writeVarInt(this.timeRequired);
        if (this.tag != null) {
            buffer.writeUtf(this.tag);
        } else {
            this.ingredient.toNetwork(buffer);
        }
        buffer.writeVarInt(this.ingredientCount);
        buffer.writeBoolean(this.enabled);
        buffer.writeBoolean(this.recipeDisabled);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isRecipeDisabled() {
        return this.recipeDisabled;
    }

    @Generated
    public ResourceLocation getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public int[] getColors() {
        return this.colors;
    }

    @Generated
    public String getTag() {
        return this.tag;
    }

    @Generated
    public int getTimeRequired() {
        return this.timeRequired;
    }

    @Generated
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Generated
    public void setRecipeDisabled(boolean recipeDisabled) {
        this.recipeDisabled = recipeDisabled;
    }
}

