/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.core.singularity;

import committee.nova.mods.avaritia.Const;
import committee.nova.mods.avaritia.common.crafting.recipe.EternalSingularityCraftRecipe;
import committee.nova.mods.avaritia.core.singularity.Singularity;
import committee.nova.mods.avaritia.core.singularity.SingularityRuntimeEvent;
import committee.nova.mods.avaritia.init.registry.ModSingularities;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.apache.logging.log4j.Logger;

public class SingularityDataManager {
    private static final Logger LOGGER = Const.LOGGER;
    private static SingularityDataManager INSTANCE;
    private Map<ResourceLocation, Singularity> cachedSingularities = new LinkedHashMap<ResourceLocation, Singularity>();
    private Map<ResourceLocation, Singularity> runtimeSingularities = new LinkedHashMap<ResourceLocation, Singularity>();
    private boolean isInitialized = false;

    public static SingularityDataManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SingularityDataManager();
        }
        return INSTANCE;
    }

    public static void onCommonSetup() {
        SingularityDataManager.getInstance().initialize();
    }

    private void initialize() {
        if (this.isInitialized) {
            return;
        }
        this.isInitialized = true;
        this.loadFallbackSingularities();
        LOGGER.info("Singularity: Initialized with {} singularities", (Object)this.cachedSingularities.size());
    }

    private void loadFallbackSingularities() {
        this.cachedSingularities.clear();
        for (Singularity singularity : ModSingularities.getDefaults()) {
            this.cachedSingularities.put(singularity.getId(), singularity);
        }
        LOGGER.info("Singularity: Loaded {} fallback singularities", (Object)this.cachedSingularities.size());
    }

    public Collection<Singularity> getSingularities() {
        LinkedHashMap<ResourceLocation, Singularity> allSingularities = new LinkedHashMap<ResourceLocation, Singularity>(this.cachedSingularities);
        allSingularities.putAll(this.runtimeSingularities);
        return allSingularities.values();
    }

    public Collection<Singularity> getDataPackSingularities() {
        return this.cachedSingularities.values();
    }

    public Singularity getSingularity(ResourceLocation id) {
        Singularity runtimeSingularity = this.runtimeSingularities.get(id);
        if (runtimeSingularity != null) {
            return runtimeSingularity;
        }
        return this.cachedSingularities.get(id);
    }

    public void registerRuntimeSingularity(Singularity singularity) {
        if (singularity != null && singularity.getId() != null) {
            Singularity oldSingularity = this.runtimeSingularities.put(singularity.getId(), singularity);
            if (oldSingularity == null) {
                LOGGER.info("Singularity: Registered runtime singularity: {}", (Object)singularity.getId());
            } else {
                LOGGER.info("Singularity: Updated runtime singularity: {}", (Object)singularity.getId());
            }
            EternalSingularityCraftRecipe.invalidate();
            MinecraftForge.EVENT_BUS.post((Event)new SingularityRuntimeEvent.Add(this.getAllSingularities(), singularity));
        }
    }

    public Singularity removeRuntimeSingularity(ResourceLocation id) {
        Singularity removed = this.runtimeSingularities.remove(id);
        if (removed != null) {
            LOGGER.info("Singularity: Removed runtime singularity: {}", (Object)id);
            EternalSingularityCraftRecipe.invalidate();
            MinecraftForge.EVENT_BUS.post((Event)new SingularityRuntimeEvent.Remove(this.getAllSingularities(), id));
        }
        return removed;
    }

    private Map<ResourceLocation, Singularity> getAllSingularities() {
        LinkedHashMap<ResourceLocation, Singularity> all = new LinkedHashMap<ResourceLocation, Singularity>(this.cachedSingularities);
        all.putAll(this.runtimeSingularities);
        return all;
    }

    public boolean hasSingularity(ResourceLocation id) {
        return this.cachedSingularities.containsKey(id) || this.runtimeSingularities.containsKey(id);
    }

    public boolean isRuntimeSingularity(ResourceLocation id) {
        return this.runtimeSingularities.containsKey(id);
    }

    public int getSingularityCount() {
        return this.cachedSingularities.size() + this.runtimeSingularities.size();
    }

    public int getDataPackSingularityCount() {
        return this.cachedSingularities.size();
    }

    public int getRuntimeSingularityCount() {
        return this.runtimeSingularities.size();
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    @Generated
    public Map<ResourceLocation, Singularity> getCachedSingularities() {
        return this.cachedSingularities;
    }

    @Generated
    public void setCachedSingularities(Map<ResourceLocation, Singularity> cachedSingularities) {
        this.cachedSingularities = cachedSingularities;
    }

    @Generated
    public Map<ResourceLocation, Singularity> getRuntimeSingularities() {
        return this.runtimeSingularities;
    }

    @Generated
    public void setRuntimeSingularities(Map<ResourceLocation, Singularity> runtimeSingularities) {
        this.runtimeSingularities = runtimeSingularities;
    }
}

