/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.init.compat.emi;

import committee.nova.mods.avaritia.api.common.crafting.ICompressorRecipe;
import committee.nova.mods.avaritia.common.crafting.recipe.ExtremeSmithingRecipe;
import committee.nova.mods.avaritia.common.crafting.recipe.ITierCraftingRecipe;
import committee.nova.mods.avaritia.init.compat.emi.category.CompressorCategory;
import committee.nova.mods.avaritia.init.compat.emi.category.ExtremeSmithingRecipeCategory;
import committee.nova.mods.avaritia.init.compat.emi.category.tables.EndCraftingTableCategory;
import committee.nova.mods.avaritia.init.compat.emi.category.tables.ExtremeCraftingTableCategory;
import committee.nova.mods.avaritia.init.compat.emi.category.tables.NetherCraftingTableCategory;
import committee.nova.mods.avaritia.init.compat.emi.category.tables.SculkCraftingTableCategory;
import committee.nova.mods.avaritia.init.compat.emi.handler.EndCraftingRecipeHandler;
import committee.nova.mods.avaritia.init.compat.emi.handler.ExtremeCraftingRecipeHandler;
import committee.nova.mods.avaritia.init.compat.emi.handler.NetherCraftingRecipeHandler;
import committee.nova.mods.avaritia.init.compat.emi.handler.SculkCraftingRecipeHandler;
import committee.nova.mods.avaritia.init.registry.ModBlocks;
import committee.nova.mods.avaritia.init.registry.ModItems;
import committee.nova.mods.avaritia.init.registry.ModMenus;
import committee.nova.mods.avaritia.init.registry.ModRecipeTypes;
import committee.nova.mods.avaritia.util.SingularityUtils;
import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiInfoRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.recipe.handler.EmiRecipeHandler;
import dev.emi.emi.api.stack.Comparison;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;

@EmiEntrypoint
public class AvaritiaEmiPlugin
implements EmiPlugin {
    public void register(EmiRegistry registry) {
        registry.setDefaultComparison(ModItems.singularity.get(), Comparison.of((stack1, stack2) -> SingularityUtils.getSingularity(stack1.getItemStack()) == SingularityUtils.getSingularity(stack2.getItemStack())));
        registry.addWorkstation(VanillaEmiRecipeCategories.ANVIL_REPAIRING, (EmiIngredient)EmiStack.of((ItemLike)((ItemLike)ModBlocks.extreme_anvil.get())));
        registry.addCategory(CompressorCategory.CATEGORY);
        registry.addWorkstation(CompressorCategory.CATEGORY, (EmiIngredient)CompressorCategory.WORKSTATION);
        for (Object recipe : registry.getRecipeManager().getAllRecipesFor((RecipeType)ModRecipeTypes.COMPRESSOR_RECIPE.get())) {
            registry.addRecipe((EmiRecipe)new CompressorCategory((ICompressorRecipe)recipe));
        }
        registry.addCategory(ExtremeSmithingRecipeCategory.CATEGORY);
        registry.addWorkstation(ExtremeSmithingRecipeCategory.CATEGORY, (EmiIngredient)ExtremeSmithingRecipeCategory.WORKSTATION);
        for (Object recipe : registry.getRecipeManager().getAllRecipesFor((RecipeType)ModRecipeTypes.EXTREME_SMITHING_RECIPE.get())) {
            registry.addRecipe((EmiRecipe)new ExtremeSmithingRecipeCategory((ExtremeSmithingRecipe)recipe));
        }
        registry.addCategory(SculkCraftingTableCategory.CATEGORY);
        registry.addWorkstation(SculkCraftingTableCategory.CATEGORY, (EmiIngredient)SculkCraftingTableCategory.WORKSTATION);
        registry.addCategory(NetherCraftingTableCategory.CATEGORY);
        registry.addWorkstation(NetherCraftingTableCategory.CATEGORY, (EmiIngredient)NetherCraftingTableCategory.WORKSTATION);
        registry.addCategory(EndCraftingTableCategory.CATEGORY);
        registry.addWorkstation(EndCraftingTableCategory.CATEGORY, (EmiIngredient)EndCraftingTableCategory.WORKSTATION);
        registry.addCategory(ExtremeCraftingTableCategory.CATEGORY);
        registry.addWorkstation(ExtremeCraftingTableCategory.CATEGORY, (EmiIngredient)ExtremeCraftingTableCategory.WORKSTATION);
        for (Object recipe : registry.getRecipeManager().getAllRecipesFor((RecipeType)ModRecipeTypes.CRAFTING_TABLE_RECIPE.get())) {
            registry.addRecipe((EmiRecipe)(switch (recipe.getTier()) {
                case 1 -> new SculkCraftingTableCategory((ITierCraftingRecipe)recipe);
                case 2 -> new NetherCraftingTableCategory((ITierCraftingRecipe)recipe);
                case 3 -> new EndCraftingTableCategory((ITierCraftingRecipe)recipe);
                case 4 -> new ExtremeCraftingTableCategory((ITierCraftingRecipe)recipe);
                default -> throw new UnsupportedOperationException("Unsupported tier " + recipe.getTier());
            }));
        }
        registry.addRecipe((EmiRecipe)new EmiInfoRecipe(List.of(EmiIngredient.of((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModBlocks.neutron_collector.get()}))), List.of(Component.translatable((String)"emi.tooltip.avaritia.neutron_collector")), ResourceLocation.tryBuild((String)"avaritia", (String)"/info_collector")));
        registry.addRecipe((EmiRecipe)new EmiInfoRecipe(List.of(EmiIngredient.of((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModItems.neutron_pile.get()}))), List.of(Component.translatable((String)"emi.tooltip.avaritia.neutron_pile")), ResourceLocation.tryBuild((String)"avaritia", (String)"/info_pile")));
        registry.addRecipeHandler((MenuType)ModMenus.sculk_crafting_tile_table.get(), (EmiRecipeHandler)new SculkCraftingRecipeHandler());
        registry.addRecipeHandler((MenuType)ModMenus.nether_crafting_tile_table.get(), (EmiRecipeHandler)new NetherCraftingRecipeHandler());
        registry.addRecipeHandler((MenuType)ModMenus.end_crafting_tile_table.get(), (EmiRecipeHandler)new EndCraftingRecipeHandler());
        registry.addRecipeHandler((MenuType)ModMenus.extreme_crafting_table.get(), (EmiRecipeHandler)new ExtremeCraftingRecipeHandler());
    }
}

