/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.init.data.listener;

import com.google.gson.JsonElement;
import committee.nova.mods.avaritia.Const;
import committee.nova.mods.avaritia.common.crafting.recipe.EternalSingularityCraftRecipe;
import committee.nova.mods.avaritia.core.singularity.Singularity;
import committee.nova.mods.avaritia.core.singularity.SingularityDataManager;
import committee.nova.mods.avaritia.core.singularity.SingularityReloadEvent;
import committee.nova.mods.avaritia.util.SingularityUtils;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.NotNull;

public class SingularityJsonReloadListener
extends SimpleJsonResourceReloadListener {
    private ICondition.IContext conditionContext;

    public SingularityJsonReloadListener(ICondition.IContext conditionContext) {
        super(Const.GSON, "singularities");
        this.conditionContext = conditionContext;
    }

    protected void apply(Map<ResourceLocation, JsonElement> object, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profiler) {
        LinkedHashMap<ResourceLocation, Singularity> singularities = new LinkedHashMap<ResourceLocation, Singularity>();
        for (Map.Entry<ResourceLocation, JsonElement> entry : object.entrySet()) {
            Singularity singularity = SingularityUtils.loadFromJson(entry.getKey(), entry.getValue().getAsJsonObject(), this.getConditionContext());
            if (singularity == null) continue;
            singularities.put(entry.getKey(), singularity);
        }
        SingularityDataManager.getInstance().getCachedSingularities().clear();
        SingularityDataManager.getInstance().setCachedSingularities(singularities);
        Const.LOGGER.info("Singularity: Loaded {} singularities", (Object)singularities.size());
        this.onSingularitiesReloaded(singularities);
    }

    private void onSingularitiesReloaded(Map<ResourceLocation, Singularity> singularities) {
        EternalSingularityCraftRecipe.invalidate();
        MinecraftForge.EVENT_BUS.post((Event)new SingularityReloadEvent(singularities));
    }

    @NotNull
    public String getName() {
        return "Avaritia Singularity Listener";
    }

    @Generated
    public ICondition.IContext getConditionContext() {
        return this.conditionContext;
    }
}

