/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.init.handler;

import committee.nova.mods.avaritia.api.iface.ISwitchable;
import committee.nova.mods.avaritia.api.util.lang.TextUtils;
import committee.nova.mods.avaritia.common.block.extreme.ExtremeAnvilBlock;
import committee.nova.mods.avaritia.common.entity.ImmortalItemEntity;
import committee.nova.mods.avaritia.common.item.resources.MatterClusterItem;
import committee.nova.mods.avaritia.common.item.tools.InfinityArmorItem;
import committee.nova.mods.avaritia.common.item.tools.infinity.InfinityAxeItem;
import committee.nova.mods.avaritia.common.item.tools.infinity.InfinityBowItem;
import committee.nova.mods.avaritia.common.item.tools.infinity.InfinityCrossBowItem;
import committee.nova.mods.avaritia.common.item.tools.infinity.InfinityHoeItem;
import committee.nova.mods.avaritia.common.item.tools.infinity.InfinityPickaxeItem;
import committee.nova.mods.avaritia.common.item.tools.infinity.InfinityShieldItem;
import committee.nova.mods.avaritia.common.item.tools.infinity.InfinityShovelItem;
import committee.nova.mods.avaritia.common.item.tools.infinity.InfinitySwordItem;
import committee.nova.mods.avaritia.common.net.S2CTotemPack;
import committee.nova.mods.avaritia.init.config.ModConfig;
import committee.nova.mods.avaritia.init.handler.NetworkHandler;
import committee.nova.mods.avaritia.init.registry.ModBlocks;
import committee.nova.mods.avaritia.init.registry.ModDamageTypes;
import committee.nova.mods.avaritia.init.registry.ModEntities;
import committee.nova.mods.avaritia.init.registry.ModItems;
import committee.nova.mods.avaritia.init.registry.ModTags;
import committee.nova.mods.avaritia.util.ToolUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EndPortalFrameBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.item.ItemEvent;
import net.minecraftforge.event.entity.item.ItemExpireEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class InfinityHandler {
    @SubscribeEvent
    public static void onPlayerMine(PlayerInteractEvent.LeftClickBlock event) {
        ItemStack item = event.getItemStack();
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        BlockState state = level.getBlockState(pos);
        Player player = event.getEntity();
        Direction face = event.getFace();
        if (face == null || level.isClientSide || item.isEmpty() || player.isCreative()) {
            return;
        }
        if (item.is((Item)ModItems.crystal_pickaxe.get()) || item.is((Item)ModItems.infinity_pickaxe.get())) {
            if (state.is(Blocks.BEDROCK)) {
                level.setBlock(pos, ((Block)ModBlocks.fake_bedrock.get()).defaultBlockState(), 2);
            } else if (state.is(Blocks.END_PORTAL_FRAME)) {
                BlockState fakeEndPortalFrameState = (BlockState)((BlockState)((Block)ModBlocks.fake_end_portal_frame.get()).defaultBlockState().setValue((Property)EndPortalFrameBlock.FACING, (Comparable)((Direction)state.getValue((Property)EndPortalFrameBlock.FACING)))).setValue((Property)EndPortalFrameBlock.HAS_EYE, (Comparable)((Boolean)state.getValue((Property)EndPortalFrameBlock.HAS_EYE)));
                level.setBlock(pos, fakeEndPortalFrameState, 2);
            } else if (state.is(Blocks.END_PORTAL)) {
                level.setBlock(pos, ((Block)ModBlocks.fake_end_portal.get()).defaultBlockState(), 2);
            }
        }
        if (!item.is((Item)ModItems.crystal_pickaxe.get()) && !item.is((Item)ModItems.infinity_pickaxe.get())) {
            if (state.is((Block)ModBlocks.fake_bedrock.get())) {
                level.setBlock(pos, Blocks.BEDROCK.defaultBlockState(), 2);
            } else if (state.is((Block)ModBlocks.fake_end_portal_frame.get())) {
                BlockState endPortalFrameState = (BlockState)((BlockState)Blocks.END_PORTAL_FRAME.defaultBlockState().setValue((Property)EndPortalFrameBlock.FACING, (Comparable)((Direction)state.getValue((Property)EndPortalFrameBlock.FACING)))).setValue((Property)EndPortalFrameBlock.HAS_EYE, (Comparable)((Boolean)state.getValue((Property)EndPortalFrameBlock.HAS_EYE)));
                level.setBlock(pos, endPortalFrameState, 2);
            } else if (state.is((Block)ModBlocks.fake_end_portal.get())) {
                level.setBlock(pos, Blocks.END_PORTAL.defaultBlockState(), 2);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerMine(BlockEvent.BreakEvent event) {
        if (event.getLevel().isClientSide()) {
            return;
        }
        ServerLevel level = (ServerLevel)event.getLevel();
        BlockPos pos = event.getPos();
        BlockState state = event.getState();
        if (!event.getPlayer().isCreative()) {
            if (state.is((Block)ModBlocks.fake_bedrock.get())) {
                Block.popResource((Level)level, (BlockPos)pos, (ItemStack)Blocks.BEDROCK.asItem().getDefaultInstance());
            } else if (state.is((Block)ModBlocks.fake_end_portal_frame.get())) {
                Block.popResource((Level)level, (BlockPos)pos, (ItemStack)Blocks.END_PORTAL_FRAME.asItem().getDefaultInstance());
            } else if (state.is((Block)ModBlocks.fake_end_portal.get())) {
                Block.popResource((Level)level, (BlockPos)pos, (ItemStack)Blocks.END_PORTAL.asItem().getDefaultInstance());
            } else if (state.is(Blocks.REINFORCED_DEEPSLATE)) {
                Block.popResource((Level)level, (BlockPos)pos, (ItemStack)Blocks.REINFORCED_DEEPSLATE.asItem().getDefaultInstance());
            }
        }
    }

    @SubscribeEvent
    public static void digging(PlayerEvent.BreakSpeed event) {
        ItemStack held;
        if (!event.getEntity().getMainHandItem().isEmpty() && ((held = event.getEntity().getMainHandItem()).is((Item)ModItems.infinity_pickaxe.get()) || held.is((Item)ModItems.infinity_shovel.get()))) {
            if (!event.getEntity().onGround()) {
                event.setNewSpeed(event.getNewSpeed() * 5.0f);
            }
            if (!event.getEntity().isInWater() && !EnchantmentHelper.hasAquaAffinity((LivingEntity)event.getEntity())) {
                event.setNewSpeed(event.getNewSpeed() * 5.0f);
            }
            if (ISwitchable.isMode(held, "infinity_pickaxe_hammer") || ISwitchable.isMode(held, "infinity_shovel_destroyer")) {
                event.setNewSpeed(event.getNewSpeed() * 0.5f);
            }
        }
    }

    @SubscribeEvent
    public static void clusterCluster(EntityItemPickupEvent event) {
        Player player = event.getEntity();
        ItemStack stack = event.getItem().getItem();
        if (player != null && ((Boolean)ModConfig.isMergeMatterCluster.get()).booleanValue() && event.getItem().getItem().is((Item)ModItems.matter_cluster.get())) {
            boolean mergedAny = false;
            for (ItemStack slot : player.getInventory().items) {
                if (stack.isEmpty()) break;
                if (!slot.is((Item)ModItems.matter_cluster.get())) continue;
                mergedAny |= MatterClusterItem.mergeClusters(stack, slot);
            }
            if (mergedAny) {
                player.level().playSound(null, (Entity)player, SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 0.2f, (player.level().random.nextFloat() - player.level().random.nextFloat()) * 1.4f + 2.0f);
            }
        }
    }

    @SubscribeEvent
    public static void expCancel(ItemExpireEvent event) {
        if (event.getEntity() instanceof ImmortalItemEntity) {
            event.setCanceled(true);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onTooltip(ItemTooltipEvent event) {
        block4: {
            block3: {
                Item item;
                if (!((Boolean)ModConfig.isSwordAttackEndless.get()).booleanValue() || !((item = event.getItemStack().getItem()) instanceof InfinitySwordItem)) break block3;
                InfinitySwordItem swordItem = (InfinitySwordItem)item;
                for (int x = 0; x < event.getToolTip().size(); ++x) {
                    if (!((Component)event.getToolTip().get(x)).getString().contains(I18n.get((String)"attribute.name.generic.attack_damage", (Object[])new Object[0]))) continue;
                    Boolean endlessDamage = (Boolean)ModConfig.isSwordAttackEndless.get();
                    event.getToolTip().set(x, Component.literal((String)(endlessDamage != false ? TextUtils.makeFabulous(I18n.get((String)"tooltip.infinity", (Object[])new Object[0])) : String.valueOf(swordItem.getTier().getAttackDamageBonus()))).append(" ").append((Component)Component.translatable((String)"tooltip.infinity.desc").withStyle(ChatFormatting.DARK_GREEN)));
                    return;
                }
                break block4;
            }
            if (!(event.getItemStack().getItem() instanceof InfinityArmorItem)) break block4;
            for (int x = 0; x < event.getToolTip().size(); ++x) {
                if (((Component)event.getToolTip().get(x)).getString().contains(I18n.get((String)"attribute.name.generic.armor", (Object[])new Object[0]))) {
                    event.getToolTip().set(x, Component.literal((String)"+").withStyle(ChatFormatting.BLUE).append((Component)Component.literal((String)TextUtils.makeFabulous(I18n.get((String)"tooltip.infinity", (Object[])new Object[0])))).append(" ").append((Component)Component.translatable((String)"tooltip.armor.desc").withStyle(ChatFormatting.BLUE)));
                    return;
                }
                if (!((Component)event.getToolTip().get(x)).getString().contains(I18n.get((String)"attribute.name.generic.armor_toughness", (Object[])new Object[0]))) continue;
                event.getToolTip().set(x, Component.literal((String)"+").withStyle(ChatFormatting.BLUE).append((Component)Component.literal((String)TextUtils.makeFabulous(I18n.get((String)"tooltip.infinity", (Object[])new Object[0])))).append(" ").append((Component)Component.translatable((String)"tooltip.armor_toughness.desc").withStyle(ChatFormatting.BLUE)));
                return;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            if (ToolUtils.isInfinite((LivingEntity)player)) {
                event.setCanceled(true);
                player.setHealth(player.getMaxHealth());
            } else {
                ItemStack totem = ToolUtils.getPlayerTotemItem((Player)player);
                if (!totem.isEmpty()) {
                    NetworkHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new S2CTotemPack(totem, player.getId()));
                    player.removeAllEffects();
                    if (totem.getDamageValue() == 1) {
                        player.setHealth(player.getMaxHealth());
                        player.addEffect(new MobEffectInstance(MobEffects.JUMP, 800, 1));
                        player.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SPEED, 800, 1));
                        ToolUtils.aoeAttack((Player)player, 8.0f, 1000.0f, false, false);
                        player.displayClientMessage((Component)Component.translatable((String)"tooltip.avaritia.totem_break"), false);
                    } else {
                        player.setHealth(player.getMaxHealth());
                    }
                    player.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 2600, 4));
                    player.addEffect(new MobEffectInstance(MobEffects.DAMAGE_RESISTANCE, 400, 1));
                    player.addEffect(new MobEffectInstance(MobEffects.ABSORPTION, 700, 2));
                    player.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 1100, 0));
                    totem.hurtAndBreak(1, (LivingEntity)player, e -> e.swing(InteractionHand.MAIN_HAND));
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onGetHurt(LivingHurtEvent event) {
        Player player;
        DamageSource damageSource = event.getSource();
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && ToolUtils.isInfinite((LivingEntity)(player = (Player)livingEntity)) && !damageSource.is(ModDamageTypes.INFINITY)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onAttacked(LivingAttackEvent event) {
        if (ToolUtils.isInfinite(event.getEntity())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent event) {
        Player player;
        DamageSource damageSource = event.getSource();
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && ToolUtils.isInfinite((LivingEntity)(player = (Player)livingEntity)) && !damageSource.is(ModDamageTypes.INFINITY)) {
            event.setAmount(0.0f);
            player.hurtTime = 0;
            player.deathTime = 0;
        }
    }

    @SubscribeEvent
    public static void onLivingDrops(LivingDropsEvent event) {
        Player player;
        Entity entity;
        if (event.isRecentlyHit() && event.getEntity() instanceof AbstractSkeleton && (entity = event.getSource().getEntity()) instanceof Player && ((player = (Player)entity).getMainHandItem().is((Item)ModItems.blaze_sword.get()) || player.getOffhandItem().is((Item)ModItems.blaze_sword.get()))) {
            if (event.getDrops().isEmpty()) {
                InfinityHandler.addDrop(event, new ItemStack((ItemLike)Items.WITHER_SKELETON_SKULL, 1));
            } else {
                int skulls = 0;
                for (ItemEntity drop : event.getDrops()) {
                    ItemStack stack = drop.getItem();
                    if (!stack.is(Items.WITHER_SKELETON_SKULL)) continue;
                    ++skulls;
                }
                if (skulls == 0) {
                    InfinityHandler.addDrop(event, new ItemStack((ItemLike)Items.WITHER_SKELETON_SKULL, 1));
                }
            }
        }
    }

    @SubscribeEvent
    public static void toolEnchant(BlockEvent.BreakEvent event) {
        ISwitchable switchable;
        Item item;
        Player player = event.getPlayer();
        if (player == null) {
            return;
        }
        ItemStack tool = player.getMainHandItem();
        if (tool.isEmpty()) {
            return;
        }
        Level world = (Level)event.getLevel();
        BlockPos pos = event.getPos();
        Block block = event.getState().getBlock();
        BlockState state = event.getState();
        if ((tool.is((Item)ModItems.blaze_pickaxe.get()) || tool.is((Item)ModItems.blaze_shovel.get())) && (item = tool.getItem()) instanceof ISwitchable && (switchable = (ISwitchable)item).isActive(tool, "smelt")) {
            ToolUtils.melting(block, state, world, pos, player, tool, event);
        }
    }

    @SubscribeEvent
    public static void entityItemUnDeath(ItemEvent event) {
        ItemEntity entityItem = event.getEntity();
        Item item = entityItem.getItem().getItem();
        if (item instanceof InfinityArmorItem || item instanceof InfinityAxeItem || item instanceof InfinityBowItem || item instanceof InfinityHoeItem || item instanceof InfinityShovelItem || item instanceof InfinityPickaxeItem || item instanceof InfinitySwordItem || item instanceof InfinityCrossBowItem) {
            entityItem.setInvulnerable(true);
        }
    }

    private static void addDrop(LivingDropsEvent event, ItemStack drop) {
        ItemEntity entity = new ItemEntity(event.getEntity().level(), event.getEntity().getX(), event.getEntity().getY(), event.getEntity().getZ(), drop);
        entity.setDefaultPickUpDelay();
        event.getDrops().add(entity);
    }

    @SubscribeEvent
    public static void onItemSpawn(ItemEvent event) {
        ItemEntity entity = event.getEntity();
        ItemStack stack = entity.getItem();
        Object player = null;
        if (stack.is(ModTags.IMMORTAL_ITEM) && !(entity instanceof ImmortalItemEntity)) {
            Level level = entity.level();
            ImmortalItemEntity immortalEntity = ImmortalItemEntity.create((EntityType<ImmortalItemEntity>)((EntityType)ModEntities.IMMORTAL.get()), level, entity.getX(), entity.getY(), entity.getZ(), stack);
            immortalEntity.setDeltaMovement(entity.getDeltaMovement());
            immortalEntity.setDefaultPickUpDelay();
            immortalEntity.setPickUpDelay(0);
            if (!level.isClientSide) {
                entity.discard();
                level.addFreshEntity((Entity)immortalEntity);
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onEntityHurting(LivingHurtEvent event) {
        Player player;
        LivingEntity fallingBlock;
        Block block;
        Entity sourceEntity;
        if (event.getSource().is(DamageTypes.FALLING_BLOCK) && (sourceEntity = event.getSource().getDirectEntity()) instanceof FallingBlockEntity && (block = (fallingBlock = (FallingBlockEntity)sourceEntity).getBlockState().getBlock()) instanceof ExtremeAnvilBlock) {
            LivingEntity entity = event.getEntity();
            float damage = event.getAmount();
            float newHealth = Math.max(0.0f, entity.getHealth() - damage);
            entity.setHealth(newHealth);
            event.setCanceled(true);
        }
        if ((fallingBlock = event.getEntity()) instanceof Player && (player = (Player)fallingBlock).isUsingItem() && player.getUseItem().getItem() instanceof InfinityShieldItem) {
            Level level = player.level();
            if (!level.isClientSide) {
                LivingEntity attacker;
                level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.SHIELD_BLOCK, SoundSource.PLAYERS, 1.0f, 1.0f);
                DamageSource source = event.getSource();
                LivingEntity livingEntity = attacker = source.getDirectEntity() instanceof LivingEntity ? (LivingEntity)source.getDirectEntity() : null;
                if (attacker != null && attacker != player) {
                    float reflectedDamage = event.getAmount();
                    DamageSource reflectedSource = player.level().damageSources().playerAttack(player);
                    attacker.hurt(reflectedSource, reflectedDamage);
                }
                event.setAmount(0.0f);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingKnockBack(LivingKnockBackEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && (player = (Player)livingEntity).isUsingItem() && player.getUseItem().getItem() instanceof InfinityShieldItem) {
            event.setCanceled(true);
        }
    }
}

